/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.ftbquests;

import com.fast.fastcollection.O2LOpenCacheHashMap;
import com.gtolib.utils.ServerUtils;
import dev.architectury.event.EventResult;
import dev.ftb.mods.ftbquests.events.ObjectCompletedEvent;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public final class AdditionalTeamData
extends SavedData {
    public static AdditionalTeamData instance = new AdditionalTeamData();
    private final O2LOpenCacheHashMap<IdsData> uuids2lastCompleteMillis = new O2LOpenCacheHashMap();
    private final O2LOpenCacheHashMap<IdsData> uuids2lastCompleteServerTick = new O2LOpenCacheHashMap();

    public AdditionalTeamData() {
    }

    public AdditionalTeamData(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("dataList", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag dataTag = list.m_128728_(i);
            IdsData data = IdsData.readFromNBT(dataTag.m_128469_("idsData"));
            long lastCompleteStamp = dataTag.m_128454_("lastCompleteStamp");
            long lastCompleteServerTick = dataTag.m_128454_("lastCompleteServerTick");
            this.uuids2lastCompleteMillis.put((Object)data, lastCompleteStamp);
            this.uuids2lastCompleteServerTick.put((Object)data, lastCompleteServerTick);
        }
    }

    public static long getLastCompleteMillis(long questID, UUID teamUUID) {
        IdsData data = new IdsData(questID, teamUUID);
        return AdditionalTeamData.instance.uuids2lastCompleteMillis.getLong((Object)data);
    }

    public static long getLastCompleteServerTick(long questID, UUID teamUUID) {
        IdsData data = new IdsData(questID, teamUUID);
        return AdditionalTeamData.instance.uuids2lastCompleteServerTick.getLong((Object)data);
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compoundTag) {
        ListTag list = new ListTag();
        for (IdsData data : this.uuids2lastCompleteMillis.keySet()) {
            CompoundTag dataTag = new CompoundTag();
            dataTag.m_128365_("idsData", (Tag)data.writeToNBT());
            dataTag.m_128356_("lastCompleteStamp", this.uuids2lastCompleteMillis.getLong((Object)data));
            dataTag.m_128356_("lastCompleteServerTick", this.uuids2lastCompleteServerTick.getLong((Object)data));
            list.add((Object)dataTag);
        }
        compoundTag.m_128365_("dataList", (Tag)list);
        return compoundTag;
    }

    public static EventResult onCompleted(ObjectCompletedEvent.TaskEvent event) {
        AdditionalTeamData.instance.uuids2lastCompleteMillis.put((Object)new IdsData(event.getTask().getQuest().id, event.getData().getTeamId()), event.getTime().getTime());
        AdditionalTeamData.instance.uuids2lastCompleteServerTick.put((Object)new IdsData(event.getTask().getQuest().id, event.getData().getTeamId()), (long)ServerUtils.getServer().m_129921_());
        instance.m_77762_();
        return EventResult.pass();
    }

    static {
        ObjectCompletedEvent.TASK.register(AdditionalTeamData::onCompleted);
    }

    public record IdsData(long questID, UUID teamUUID) implements Comparable<IdsData>
    {
        @Override
        public int compareTo(IdsData o) {
            return this.questID != o.questID ? Long.compare(this.questID, o.questID) : this.teamUUID.compareTo(o.teamUUID);
        }

        public static IdsData readFromNBT(CompoundTag nbt) {
            return new IdsData(nbt.m_128454_("questID"), nbt.m_128342_("teamUUID"));
        }

        public CompoundTag writeToNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_("questID", this.questID);
            nbt.m_128362_("teamUUID", this.teamUUID);
            return nbt;
        }
    }
}

