/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.jade.provider;

import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.integration.jade.provider.CapabilityBlockProvider;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtolib.GTOCore;
import com.gtolib.api.capability.IManaContainer;
import com.gtolib.api.machine.mana.feature.IManaMachine;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElementHelper;

public final class ManaContainerBlockProvider
extends CapabilityBlockProvider<IManaContainer> {
    public ManaContainerBlockProvider() {
        super(GTOCore.id((String)"mana_container_provider"));
    }

    @Nullable
    protected IManaContainer getCapability(Level level, BlockPos pos, BlockEntity blockEntity, @Nullable Direction side) {
        MetaMachine machine = MetaMachine.getMachine((BlockEntity)blockEntity);
        if (machine instanceof IManaMachine) {
            IManaMachine manaMachine = (IManaMachine)machine;
            return manaMachine.getManaContainer();
        }
        return null;
    }

    protected void write(CompoundTag data, IManaContainer capability) {
        data.m_128356_("Mana", capability.getCurrentMana());
        data.m_128356_("MaxMana", capability.getMaxMana());
    }

    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor block, BlockEntity blockEntity, IPluginConfig config) {
        long maxStorage = capData.m_128454_("MaxMana");
        if (maxStorage == 0L) {
            return;
        }
        long stored = capData.m_128454_("Mana");
        IElementHelper helper = tooltip.getElementHelper();
        tooltip.add(helper.progress(this.getProgress(stored, maxStorage), (Component)Component.m_237113_((String)(FormattingUtil.formatNumbers((long)stored) + " / " + FormattingUtil.formatNumbers((long)maxStorage) + " Mana")), helper.progressStyle().color(-16731649, -16731649).textColor(-1), (IBoxStyle)Util.m_137469_((Object)BoxStyle.DEFAULT, style -> {
            style.borderColor = -7829368;
        }), true));
    }
}

