/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.jade.provider;

import com.glodblock.github.extendedae.client.render.EAEHighlightHandler;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.error.PatternError;
import com.gtocore.client.ClientCache;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

@DataGeneratorScanned
public final class MultiblockStructureProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    @RegisterLanguage(cn="\u6b63\u5728\u68c0\u67e5\u7ed3\u6784", en="Checking structure")
    private static final String CHECKING = "gtocore.top.checking";
    @RegisterLanguage(cn="\u6392\u961f\u7b49\u5f85\u68c0\u67e5\u7ed3\u6784", en="Waiting in line for check structure")
    private static final String WAITING = "gtocore.top.waiting";
    @RegisterLanguage(cn="\u53ef\u80fd\u7684\u9519\u8bef ", en="Probable errors ")
    private static final String ERRORS = "gtocore.top.errors";

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        if (blockAccessor.getServerData().m_128441_("hasError")) {
            if (blockAccessor.getServerData().m_128471_("hasError")) {
                iTooltip.add((Component)Component.m_237115_((String)"gtceu.top.invalid_structure").m_130940_(ChatFormatting.RED));
                if (blockAccessor.getServerData().m_128471_("checking")) {
                    iTooltip.add((Component)Component.m_237115_((String)CHECKING).m_130940_(ChatFormatting.YELLOW));
                } else if (blockAccessor.getServerData().m_128471_("waiting")) {
                    iTooltip.add((Component)Component.m_237115_((String)WAITING).m_130940_(ChatFormatting.DARK_AQUA));
                } else {
                    boolean highlight = ClientCache.highlightTime < 1;
                    boolean isHighlight = false;
                    int i = 0;
                    for (Tag error : blockAccessor.getServerData().m_128437_("error", 10)) {
                        if (!(error instanceof CompoundTag)) continue;
                        CompoundTag compoundTag = (CompoundTag)error;
                        ListTag infos = compoundTag.m_128437_("info", 8);
                        iTooltip.add((Component)Component.m_237115_((String)ERRORS).m_130946_(String.valueOf(++i)).m_130940_(ChatFormatting.GOLD));
                        for (Tag info : infos) {
                            MutableComponent c = Component.Serializer.m_130701_((String)info.m_7916_());
                            if (c == null) continue;
                            iTooltip.add((Component)c);
                        }
                        long errorPos = compoundTag.m_128454_("pos");
                        if (errorPos == 0L || !highlight) continue;
                        isHighlight = true;
                        EAEHighlightHandler.highlight((BlockPos)BlockPos.m_122022_((long)errorPos), (ResourceKey)blockAccessor.getLevel().m_46472_(), (long)(System.currentTimeMillis() + 10000L));
                    }
                    if (isHighlight) {
                        ClientCache.highlightTime = 200;
                    }
                }
            } else {
                iTooltip.add((Component)Component.m_237115_((String)"gtceu.top.valid_structure").m_130940_(ChatFormatting.GREEN));
            }
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        MetaMachineBlockEntity blockEntity;
        BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
        if (blockEntity2 instanceof MetaMachineBlockEntity && (blockEntity2 = (blockEntity = (MetaMachineBlockEntity)blockEntity2).getMetaMachine()) instanceof IMultiController) {
            IMultiController controller = (IMultiController)blockEntity2;
            if (controller.isFormed()) {
                compoundTag.m_128379_("hasError", false);
            } else {
                compoundTag.m_128379_("hasError", true);
                if (controller.checking()) {
                    compoundTag.m_128379_("checking", true);
                } else if (controller.getMultiblockState().hasError()) {
                    if (controller.getMultiblockState().error == MultiblockState.UNINIT_ERROR && controller.getWaitingTime() == 0) {
                        compoundTag.m_128379_("waiting", true);
                    } else {
                        ListTag errors = new ListTag();
                        LongOpenHashSet posSet = new LongOpenHashSet();
                        for (PatternError error : controller.getMultiblockState().errorRecord) {
                            Tag tag = MultiblockStructureProvider.toTag(error, (LongSet)posSet);
                            if (tag == null) continue;
                            errors.add((Object)tag);
                        }
                        Tag tag = MultiblockStructureProvider.toTag(controller.getMultiblockState().error, (LongSet)posSet);
                        if (tag != null) {
                            errors.add((Object)tag);
                        }
                        compoundTag.m_128365_("error", (Tag)errors);
                    }
                } else {
                    compoundTag.m_128379_("waiting", true);
                }
            }
        }
    }

    private static Tag toTag(PatternError error, LongSet set) {
        ListTag infos = new ListTag();
        infos.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)error.getErrorInfo())));
        CompoundTag tag = new CompoundTag();
        BlockPos pos = error.getPos();
        if (pos != null) {
            long posLong = pos.m_121878_();
            if (set.contains(posLong)) {
                return null;
            }
            tag.m_128356_("pos", posLong);
            set.add(posLong);
        }
        tag.m_128365_("info", (Tag)infos);
        return tag;
    }

    public ResourceLocation getUid() {
        return GTCEu.id((String)"multiblock_structure");
    }
}

