/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.ae2.blockentity;

import appeng.api.behaviors.StackExportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.FuzzyMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.storage.IStorageService;
import appeng.api.parts.IPartItem;
import appeng.api.stacks.AEKey;
import appeng.api.storage.AEKeyFilter;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.parts.automation.ExportBusPart;
import appeng.parts.automation.IOBusPart;
import com.gtolib.api.ae2.StorageExportCacheStrategy;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ExportBusPart.class})
public abstract class ExportBusPartMixin
extends IOBusPart
implements ICraftingRequester {
    @Shadow(remap=false)
    @Nullable
    private StackExportStrategy exportStrategy;

    @Shadow(remap=false)
    protected abstract StackTransferContext createTransferContext(IStorageService var1, IEnergyService var2);

    @Shadow(remap=false)
    protected abstract int getStartingSlot(SchedulingMode var1, int var2);

    @Shadow(remap=false)
    protected abstract void attemptCrafting(StackTransferContext var1, ICraftingService var2, int var3, AEKey var4);

    @Shadow(remap=false)
    protected abstract void updateSchedulingMode(SchedulingMode var1, int var2);

    protected ExportBusPartMixin(TickRates tickRates, @Nullable AEKeyFilter filter, IPartItem<?> partItem) {
        super(tickRates, filter, partItem);
    }

    @Overwrite(remap=false)
    protected final StackExportStrategy getExportStrategy() {
        if (this.exportStrategy == null) {
            BlockEntity self = this.getHost().getBlockEntity();
            this.exportStrategy = StorageExportCacheStrategy.createExportFacade((ServerLevel)((ServerLevel)self.m_58904_()), (BlockEntity)self, (BlockPos)self.m_58899_().m_121945_(this.getSide()), (Direction)this.getSide(), (Direction)this.getSide().m_122424_());
        }
        return this.exportStrategy;
    }

    @Overwrite(remap=false)
    protected boolean doBusWork(IGrid grid) {
        int x;
        IStorageService storageService = grid.getStorageService();
        ICraftingService cg = grid.getCraftingService();
        FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
        SchedulingMode schedulingMode = (SchedulingMode)this.getConfigManager().getSetting(Settings.SCHEDULING_MODE);
        StackTransferContext context = this.createTransferContext(storageService, grid.getEnergyService());
        StackExportStrategy strategy = this.getExportStrategy();
        boolean isFuzzy = this.isUpgradedWith((ItemLike)AEItems.FUZZY_CARD);
        boolean isCraftingEnabled = this.isUpgradedWith((ItemLike)AEItems.CRAFTING_CARD);
        for (x = 0; x < this.availableSlots(); ++x) {
            int slotToExport = this.getStartingSlot(schedulingMode, x);
            AEKey what = this.getConfig().getKey(slotToExport);
            if (what == null) continue;
            if (isCraftingEnabled && this.getConfigManager().getSetting(Settings.CRAFT_ONLY) == YesNo.YES) {
                this.attemptCrafting(context, cg, slotToExport, what);
                continue;
            }
            int before = context.getOperationsRemaining();
            if (isFuzzy) {
                for (Object2LongMap.Entry fuzzyWhat : storageService.getCachedInventory().findFuzzy(what, fzMode)) {
                    amount = fuzzyWhat.getLongValue();
                    if (amount <= 0L || (amount = strategy.transfer(context, (AEKey)fuzzyWhat.getKey(), amount)) <= 0L) continue;
                    context.reduceOperationsRemaining(1L);
                }
            } else {
                amount = storageService.getCachedInventory().get(what);
                if (amount > 0L && (amount = strategy.transfer(context, what, amount)) > 0L) {
                    context.reduceOperationsRemaining(1L);
                }
            }
            if (!isCraftingEnabled || before != context.getOperationsRemaining()) continue;
            this.attemptCrafting(context, cg, slotToExport, what);
        }
        if (context.hasDoneWork()) {
            this.updateSchedulingMode(schedulingMode, x);
        }
        return context.hasDoneWork();
    }
}

