/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.ae2.crafting;

import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.blockentity.crafting.CraftingBlockEntity;
import appeng.blockentity.crafting.CraftingMonitorBlockEntity;
import appeng.crafting.execution.CraftingCpuLogic;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.me.helpers.MachineSource;
import appeng.util.ConfigManager;
import com.gtocore.api.ae2.crafting.OptimizedCraftingCpuLogic;
import com.gtolib.api.ae2.crafting.ICraftingCPUCluster;
import com.gtolib.api.machine.impl.part.CraftingInterfacePartMachine;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CraftingCPUCluster.class})
public abstract class CraftingCPUClusterMixin
implements ICraftingCPUCluster {
    @Shadow(remap=false)
    private MachineSource machineSrc;
    @Shadow(remap=false)
    @Final
    private List<CraftingBlockEntity> blockEntities;
    @Shadow(remap=false)
    @Final
    private List<CraftingMonitorBlockEntity> status;
    @Shadow(remap=false)
    private long storage;
    @Shadow(remap=false)
    private int accelerator;
    @Mutable
    @Shadow(remap=false)
    @Final
    public CraftingCpuLogic craftingLogic;
    @Shadow(remap=false)
    @Final
    private ConfigManager configManager;
    @Shadow(remap=false)
    private Component myName;
    @Shadow(remap=false)
    private boolean isDestroyed;
    @Unique
    private CraftingInterfacePartMachine gtolib$machine;

    @Shadow(remap=false)
    protected abstract CraftingBlockEntity getCore();

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void init(BlockPos boundsMin, BlockPos boundsMax, CallbackInfo ci) {
        this.craftingLogic = new OptimizedCraftingCpuLogic((CraftingCPUCluster)this);
    }

    @Overwrite(remap=false)
    void addBlockEntity(CraftingBlockEntity te) {
        if (this.machineSrc == null || te.isCoreBlock()) {
            this.machineSrc = new MachineSource((IActionHost)te);
        }
        te.setCoreBlock(false);
        te.saveChanges();
        this.blockEntities.add(0, te);
        if (te instanceof CraftingMonitorBlockEntity) {
            this.status.add((CraftingMonitorBlockEntity)te);
        }
        if (te.getStorageBytes() > 0L) {
            this.storage += te.getStorageBytes();
            ++this.accelerator;
        }
        if (te.getAcceleratorThreads() > 0) {
            this.accelerator += 16;
        }
    }

    @Overwrite(remap=false)
    public void markDirty() {
        if (this.gtolib$machine == null) {
            this.getCore().saveChanges();
        } else {
            this.gtolib$machine.onChanged();
        }
    }

    @Overwrite(remap=false)
    @Nullable
    public IGridNode getNode() {
        if (this.gtolib$machine == null) {
            CraftingBlockEntity core = this.getCore();
            return core != null ? core.getActionableNode() : null;
        }
        return this.gtolib$machine.getActionableNode();
    }

    @Overwrite(remap=false)
    public Level getLevel() {
        if (this.gtolib$machine == null) {
            return this.getCore().m_58904_();
        }
        return this.gtolib$machine.getLevel();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public void setName(Component name) {
        this.myName = name;
    }

    public void setDestroyed(boolean destroyed) {
        this.isDestroyed = destroyed;
    }

    public void setStorage(long storage) {
        this.storage = storage;
    }

    public void setMachineSrc(MachineSource src) {
        this.machineSrc = src;
    }

    public void setAccelerator(int accelerator) {
        this.accelerator = accelerator;
    }

    public void setMachine(CraftingInterfacePartMachine machine) {
        this.gtolib$machine = machine;
    }
}

