/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.ae2.stacks;

import appeng.api.stacks.AEFluidKey;
import com.fast.recipesearch.IntLongMap;
import com.gtolib.IFluid;
import com.gtolib.api.ae2.stacks.IAEFluidKey;
import com.gtolib.api.misc.IMapValueCache;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={AEFluidKey.class})
public class AEFluidKeyMixin
implements IAEFluidKey {
    @Shadow(remap=false)
    @Final
    private Fluid fluid;
    @Shadow(remap=false)
    @Nullable
    private FluidStack readOnlyStack;

    @Overwrite(remap=false)
    public static AEFluidKey of(Fluid fluid, @Nullable CompoundTag tag) {
        if (tag == null || tag.m_128456_()) {
            return ((IFluid)fluid).gtolib$getAEKey();
        }
        return (AEFluidKey)IMapValueCache.FLUID_KEY_CACHE.getCache((Object)new FluidStack(fluid, 1, tag));
    }

    @Overwrite(remap=false)
    public static AEFluidKey of(Fluid fluid) {
        return ((IFluid)fluid).gtolib$getAEKey();
    }

    @Overwrite(remap=false)
    @Nullable
    public static AEFluidKey of(FluidStack fluidVariant) {
        if (fluidVariant.isEmpty()) {
            return null;
        }
        Fluid fluid = fluidVariant.getFluid();
        CompoundTag tag = fluidVariant.getTag();
        if (tag == null || tag.m_128456_()) {
            return ((IFluid)fluid).gtolib$getAEKey();
        }
        return (AEFluidKey)IMapValueCache.FLUID_KEY_CACHE.getCache((Object)fluidVariant);
    }

    @Overwrite(remap=false)
    public static AEFluidKey fromPacket(FriendlyByteBuf data) {
        Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7942_(data.m_130242_());
        CompoundTag tag = data.m_130260_();
        if (tag == null || tag.m_128456_()) {
            return ((IFluid)fluid).gtolib$getAEKey();
        }
        return (AEFluidKey)IMapValueCache.FLUID_KEY_CACHE.getCache((Object)new FluidStack(fluid, 1, tag));
    }

    @Overwrite(remap=false)
    public ResourceLocation getId() {
        return ((IFluid)this.fluid).gtolib$getIdLocation();
    }

    public void gtolib$setReadOnlyStack(FluidStack stack) {
        this.readOnlyStack = stack;
    }

    public void gtolib$convert(long amount, IntLongMap map) {
        map.add(((IFluid)this.fluid).gtolib$getMapFluid(), amount);
    }
}

