/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.eae;

import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.me.patternaccess.PatternContainerRecord;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.util.inv.AppEngInternalInventory;
import com.fast.fastcollection.OpenCacheHashSet;
import com.glodblock.github.extendedae.client.button.HighlightButton;
import com.glodblock.github.extendedae.client.gui.GuiExPatternTerminal;
import com.glodblock.github.extendedae.container.ContainerExPatternTerminal;
import com.glodblock.github.extendedae.util.MessageUtil;
import com.google.common.collect.HashMultimap;
import com.gtocore.integration.jech.PinYinUtils;
import com.gtolib.api.ae2.GTOSettings;
import com.gtolib.api.ae2.IPatternAccessTermMenu;
import com.gtolib.api.ae2.ShowMolecularAssembler;
import com.gtolib.api.ae2.gui.hooks.IExtendedGuiEx;
import com.gtolib.api.ae2.me2in1.Me2in1Menu;
import com.gtolib.api.ae2.me2in1.Me2in1Screen;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiExPatternTerminal.class})
public abstract class GuiExPatternTerminalMixin<T extends ContainerExPatternTerminal>
extends AEBaseScreen<T>
implements IExtendedGuiEx {
    @Unique
    private static final AppEngInternalInventory gto$emptyInv = new AppEngInternalInventory(0);
    @Unique
    private static final int gto$COLUMNS = 9;
    @Shadow(remap=false)
    @Final
    private Map<String, Set<Object>> cachedSearches;
    @Shadow(remap=false)
    @Final
    private AETextField searchOutField;
    @Shadow(remap=false)
    @Final
    private AETextField searchInField;
    @Shadow(remap=false)
    @Final
    private HashMultimap<PatternContainerGroup, PatternContainerRecord> byGroup;
    @Shadow(remap=false)
    @Final
    private HashMap<Integer, HighlightButton> highlightBtns;
    @Shadow(remap=false)
    @Final
    private Set<ItemStack> matchedStack;
    @Shadow(remap=false)
    @Final
    private Set<PatternContainerRecord> matchedProvider;
    @Shadow(remap=false)
    @Final
    private HashMap<Long, PatternContainerRecord> byId;
    @Shadow(remap=false)
    @Final
    private ArrayList<PatternContainerGroup> groups;
    @Shadow(remap=false)
    @Final
    private ArrayList<Object> rows;
    @Shadow(remap=false)
    @Final
    private HashMap<Long, GuiExPatternTerminal.PatternProviderInfo> infoMap;
    @Unique
    private ServerSettingToggleButton<ShowMolecularAssembler> gtolib$showMolecularAssembler;

    @Shadow(remap=false)
    protected abstract boolean itemStackMatchesSearchTerm(ItemStack var1, String var2, boolean var3);

    @Shadow(remap=false)
    protected abstract int getMaxRows();

    @Shadow(remap=false)
    protected abstract double playerToBlockDis(BlockPos var1);

    @Shadow(remap=false)
    protected abstract void resetScrollbar();

    protected GuiExPatternTerminalMixin(T menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void onInit(ContainerExPatternTerminal menu, Inventory playerInventory, Component title, ScreenStyle style, CallbackInfo ci) {
        this.gtolib$showMolecularAssembler = new ServerSettingToggleButton(GTOSettings.TERMINAL_SHOW_MOLECULAR_ASSEMBLERS, (Enum)ShowMolecularAssembler.ALL);
        this.addToLeftToolbar((Button)this.gtolib$showMolecularAssembler);
        if (this instanceof Me2in1Screen) {
            this.searchInField.setTooltipMessage(Collections.singletonList(Component.m_237115_((String)"gtocore.ae.appeng.me2in1.search_in")));
            this.searchOutField.setTooltipMessage(Collections.singletonList(Component.m_237115_((String)"gtocore.ae.appeng.me2in1.search_out")));
        }
    }

    @Redirect(method={"init"}, at=@At(value="INVOKE", target="Lcom/glodblock/github/extendedae/client/gui/GuiExPatternTerminal;setInitialFocus(Lnet/minecraft/client/gui/components/events/GuiEventListener;)V"))
    private void onSetFocus(GuiExPatternTerminal<?> instance, GuiEventListener guiEventListener) {
        if (!(this.m_6262_() instanceof Me2in1Menu)) {
            instance.m_264313_(guiEventListener);
        }
    }

    @Inject(method={"updateBeforeRender"}, at={@At(value="TAIL")}, remap=false)
    private void updateBeforeRender(CallbackInfo ci) {
        this.gtolib$showMolecularAssembler.set((Enum)((IPatternAccessTermMenu)this.m_6262_()).gtolib$getShownMolecularAssemblers());
    }

    @Overwrite(remap=false)
    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set cache = this.cachedSearches.computeIfAbsent(searchTerm, k -> new OpenCacheHashSet());
        if (cache.isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
        }
        return cache;
    }

    @Redirect(method={"refreshList"}, at=@At(value="INVOKE", target="Ljava/util/ArrayList;sort(Ljava/util/Comparator;)V"), remap=false)
    private void sort(ArrayList<PatternContainerRecord> list, Comparator<PatternContainerRecord> comparator) {
    }

    @Inject(remap=false, method={"refreshList"}, at={@At(value="HEAD")}, cancellable=true)
    private void refreshList0(CallbackInfo ci) {
        if (this.gto$getSearchProviderField() == null) {
            return;
        }
        ci.cancel();
        this.byGroup.clear();
        this.highlightBtns.forEach((k, v) -> this.m_169411_((GuiEventListener)v));
        this.highlightBtns.clear();
        this.matchedStack.clear();
        this.matchedProvider.clear();
        String outputFilter = this.searchOutField.m_94155_().toLowerCase();
        String inputFilter = this.searchInField.m_94155_().toLowerCase();
        String patternFilter = this.gto$getSearchProviderField().m_94155_().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm("out:" + outputFilter + "in:" + inputFilter + "pat:" + patternFilter);
        boolean rebuild = cachedSearch.isEmpty();
        for (PatternContainerRecord entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean skipSearch = outputFilter.isEmpty() && inputFilter.isEmpty();
            boolean found = skipSearch && patternFilter.isEmpty();
            boolean match = PinYinUtils.match(entry.getSearchName(), patternFilter);
            if (!skipSearch && match) {
                for (ItemStack itemStack : entry.getInventory()) {
                    boolean midRes = !outputFilter.isEmpty() ? this.itemStackMatchesSearchTerm(itemStack, outputFilter, true) : true;
                    if (!inputFilter.isEmpty() && midRes) {
                        midRes = this.itemStackMatchesSearchTerm(itemStack, inputFilter, false);
                    }
                    if (!midRes) continue;
                    found = true;
                }
            }
            if (found || match && skipSearch) {
                this.byGroup.put((Object)entry.getGroup(), (Object)entry);
                cachedSearch.add(entry);
                if (!match) continue;
                this.matchedProvider.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.groups.clear();
        this.groups.addAll(this.byGroup.keySet());
        this.rows.clear();
        this.rows.ensureCapacity(this.getMaxRows());
        ArrayList<Object> row = this.rows;
        for (PatternContainerGroup group : this.groups) {
            row.add(GuiExPatternTerminalMixin.gto$constructGroupHeaderRow(group));
            ArrayList containers = new ArrayList(this.byGroup.get((Object)group));
            Collections.sort(containers);
            for (PatternContainerRecord container : containers) {
                AppEngInternalInventory inventory = container.getInventory();
                if (inventory.size() > 0) {
                    GuiExPatternTerminal.PatternProviderInfo info = this.infoMap.get(container.getServerId());
                    HighlightButton btn = new HighlightButton();
                    btn.setMultiplier(this.playerToBlockDis(info.pos()));
                    btn.setTarget(info.pos(), info.face(), info.world());
                    btn.setSuccessJob(() -> {
                        if (this.getPlayer() != null && info.pos() != null && info.world() != null) {
                            Component message = MessageUtil.createEnhancedHighlightMessage((Player)this.getPlayer(), (BlockPos)info.pos(), (ResourceKey)info.world(), (String)"chat.ex_pattern_access_terminal.pos");
                            this.getPlayer().m_5661_(message, false);
                        }
                    });
                    btn.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.expatternprovider.ex_pattern_access_terminal.tooltip.03")));
                    btn.setVisibility(false);
                    this.highlightBtns.put(this.rows.size(), (HighlightButton)this.m_142416_((GuiEventListener)btn));
                }
                for (int offset = 0; offset < inventory.size(); offset += 9) {
                    int slots = Math.min(inventory.size() - offset, 9);
                    Object containerRow = GuiExPatternTerminalMixin.gto$constructSlotRow(container, offset, slots);
                    row.add(containerRow);
                }
            }
        }
        this.resetScrollbar();
    }

    @Unique
    private static Object gto$constructSlotRow(PatternContainerRecord container, int offset, int slots) {
        try {
            Class<?> slotRowClass = Class.forName("com.glodblock.github.extendedae.client.gui.GuiExPatternTerminal$SlotsRow");
            Constructor<?> constructor = slotRowClass.getDeclaredConstructor(PatternContainerRecord.class, Integer.TYPE, Integer.TYPE);
            constructor.setAccessible(true);
            return constructor.newInstance(container, offset, slots);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Unique
    private static Object gto$constructGroupHeaderRow(PatternContainerGroup group) {
        try {
            Class<?> groupHeaderRowClass = Class.forName("com.glodblock.github.extendedae.client.gui.GuiExPatternTerminal$GroupHeaderRow");
            Constructor<?> constructor = groupHeaderRowClass.getDeclaredConstructor(PatternContainerGroup.class);
            constructor.setAccessible(true);
            return constructor.newInstance(group);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void gto$refreshSearch() {
        this.gto$eae$refreshList();
    }

    @Shadow(remap=false, prefix="gto$eae$")
    private void gto$eae$refreshList() {
    }
}

