/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.api.machine;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtolib.api.recipe.ingredient.FastFluidIngredient;
import com.gtolib.api.recipe.ingredient.SimpleFluidIngredient;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={NotifiableFluidTank.class})
public abstract class NotifiableFluidTankMixin {
    @Shadow(remap=false)
    @Final
    public IO handlerIO;
    @Shadow(remap=false)
    @Final
    protected CustomFluidTank[] storages;
    @Shadow(remap=false)
    @Final
    protected CustomFluidTank lockedFluid;

    @Overwrite(remap=false)
    public List<FluidIngredient> handleRecipeInner(IO io, GTRecipe recipe, List<FluidIngredient> left, boolean simulate) {
        if (io != this.handlerIO) {
            return left;
        }
        if (io != IO.IN && io != IO.OUT) {
            return left.isEmpty() ? null : left;
        }
        Runnable[] listeners = null;
        if (!simulate) {
            listeners = new Runnable[this.storages.length];
            for (int i = 0; i < this.storages.length; ++i) {
                listeners[i] = this.storages[i].getOnContentsChanged();
                this.storages[i].setOnContentsChangedAndfreeze(GTUtil.NOOP);
            }
        }
        boolean changed = false;
        SimpleFluidIngredient[] visited = new SimpleFluidIngredient[this.storages.length];
        IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
        Iterator<FluidIngredient> it = left.iterator();
        block1: while (it.hasNext()) {
            FluidIngredient ingredient = it.next();
            FluidStack[] fluids = FastFluidIngredient.getFluidStack((Object)ingredient);
            if (fluids.length == 0 || fluids[0].isEmpty()) {
                it.remove();
                continue;
            }
            for (int tank = 0; tank < this.storages.length; ++tank) {
                int amount;
                CustomFluidTank storage = this.storages[tank];
                FluidStack stored = storage.getFluid();
                int n = amount = visited[tank] == null ? stored.getAmount() : visited[tank].amount();
                if (io == IO.IN) {
                    FluidStack drained;
                    if (amount == 0 || (visited[tank] != null || !ingredient.test(stored)) && (visited[tank] == null || !ingredient.test(visited[tank].stack())) || (drained = storage.drain(ingredient.getAmount(), action)).getAmount() <= 0) continue;
                    if (simulate) {
                        visited[tank] = new SimpleFluidIngredient(drained, amount - drained.getAmount());
                    }
                    changed = true;
                    ingredient.shrink(drained.getAmount());
                    if (ingredient.getAmount() > 0) continue;
                    it.remove();
                    continue block1;
                }
                FluidStack fluid = fluids[0];
                if (amount >= storage.getCapacity() || !this.lockedFluid.isEmpty() && this.lockedFluid.getFluid().getFluid() != fluid.getFluid() || !stored.isEmpty() && !stored.isFluidEqual(fluid) || visited[tank] != null && !visited[tank].stack().isFluidEqual(fluid)) continue;
                FluidStack output = fluid.copy();
                output.setAmount(ingredient.getAmount());
                int filled = storage.fill(output, action);
                if (filled <= 0) continue;
                if (simulate) {
                    visited[tank] = new SimpleFluidIngredient(output, filled);
                }
                changed = true;
                ingredient.shrink(filled);
                if (ingredient.getAmount() > 0) continue;
                it.remove();
                continue block1;
            }
        }
        if (listeners != null) {
            for (int i = 0; i < this.storages.length; ++i) {
                this.storages[i].setOnContentsChangedAndfreeze(listeners[i]);
                if (!changed) continue;
                listeners[i].run();
            }
        }
        return left.isEmpty() ? null : left;
    }
}

