/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.machine;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.WorkableTieredPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.machine.multiblock.part.DataAccessHatchMachine;
import com.gtocore.common.data.GTOItems;
import com.gtolib.api.recipe.Recipe;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DataAccessHatchMachine.class})
public class DataAccessHatchMachineMixin
extends WorkableTieredPartMachine {
    @Unique
    private static final Map<Item, Integer> gtolib$DATA = Map.of(GTOItems.NEURAL_MATRIX.m_5456_(), 9, GTOItems.ATOMIC_ARCHIVES.m_5456_(), 11, GTOItems.OBSIDIAN_MATRIX.m_5456_(), 12, GTOItems.MICROCOSM.m_5456_(), 13);
    @Shadow(remap=false)
    @Final
    public NotifiableItemStackHandler importItems;
    @Shadow(remap=false)
    @Final
    private Set<GTRecipe> recipes;
    @Shadow(remap=false)
    @Final
    private boolean isCreative;

    public DataAccessHatchMachineMixin(MetaMachineBlockEntity holder, int tier) {
        super(holder, tier);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void init(MetaMachineBlockEntity holder, int tier, boolean isCreative, CallbackInfo ci) {
        this.importItems.setFilter(i -> gtolib$DATA.getOrDefault(i.m_41720_(), 0) <= tier);
    }

    @Inject(method={"getInventorySize"}, at={@At(value="TAIL")}, remap=false, cancellable=true)
    private void getInventorySize(CallbackInfoReturnable<Integer> cir) {
        switch (this.getTier()) {
            case 9: {
                cir.setReturnValue((Object)25);
                break;
            }
            case 11: {
                cir.setReturnValue((Object)36);
                break;
            }
            case 13: {
                cir.setReturnValue((Object)49);
            }
        }
    }

    @Overwrite(remap=false)
    @Nullable
    public GTRecipe modifyRecipe(IWorkableMultiController controller, GTRecipe recipe) {
        if (this.isCreative) {
            return recipe;
        }
        if (recipe instanceof Recipe) {
            Recipe gtoRecipe = (Recipe)recipe;
            Recipe root = gtoRecipe.rootRecipe;
            if (root == null || root.researchData == null) {
                return recipe;
            }
            if (this.recipes.contains(root)) {
                return recipe;
            }
        }
        return null;
    }
}

