/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.machine;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.FusionReactorMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={FusionReactorMachine.class})
public abstract class FusionReactorMachineMixin
extends WorkableElectricMultiblockMachine {
    @Shadow(remap=false)
    protected long heat;
    @Final
    @Shadow(remap=false)
    protected NotifiableEnergyContainer energyContainer;

    @Shadow(remap=false)
    public abstract long getMaxVoltage();

    protected FusionReactorMachineMixin(MetaMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    @Nullable
    public GTRecipe getRealRecipe(@NotNull GTRecipe recipe) {
        long eu = recipe.data.m_128454_("eu_to_start");
        if (eu > this.energyContainer.getEnergyCapacity()) {
            return null;
        }
        long heatDiff = eu - this.heat;
        if (heatDiff > 0L) {
            if (this.energyContainer.getEnergyStored() < heatDiff) {
                return null;
            }
            this.energyContainer.removeEnergy(heatDiff);
            this.heat += heatDiff;
        }
        return RecipeModifierFunction.perfectOverclocking((MetaMachine)this, (Recipe)((Recipe)recipe));
    }

    public long getOverclockVoltage() {
        return super.getMaxVoltage();
    }
}

