/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.WorkableTieredPartMachine;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.machine.electric.AirScrubberMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.MufflerPartMachine;
import com.gtocore.common.item.ItemMap;
import com.gtolib.api.machine.feature.IAirScrubberInteractor;
import com.gtolib.api.machine.feature.IDroneInteractionMachine;
import com.gtolib.api.machine.feature.IGTOMufflerMachine;
import com.gtolib.api.machine.feature.multiblock.IDroneControlCenterMachine;
import com.gtolib.api.misc.Drone;
import com.gtolib.utils.MachineUtils;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.Position;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MufflerPartMachine.class})
public abstract class MufflerPartMachineMixin
extends WorkableTieredPartMachine
implements IGTOMufflerMachine,
IDroneInteractionMachine,
IAirScrubberInteractor {
    @Unique
    @Persisted
    private boolean gtocore$isWorkingEnabled;
    @Shadow(remap=false)
    @Final
    private CustomItemStackHandler inventory;
    @Unique
    private IDroneControlCenterMachine gtolib$cache;
    @Unique
    private AirScrubberMachine gtolib$airScrubberCache;
    @Unique
    private int gto$chanceOfNotProduceAsh = 100;
    @Unique
    private boolean gtolib$lastFrontFaceFree;
    @Unique
    private long gtocore$refresh = 0L;

    protected MufflerPartMachineMixin(MetaMachineBlockEntity holder, int tier) {
        super(holder, tier);
    }

    @Unique
    public AirScrubberMachine getAirScrubberMachineCache() {
        return this.gtolib$airScrubberCache;
    }

    @Unique
    public void setAirScrubberMachineCache(AirScrubberMachine cache) {
        this.gtolib$airScrubberCache = cache;
    }

    @Unique
    public IDroneControlCenterMachine getNetMachineCache() {
        return this.gtolib$cache;
    }

    @Unique
    public void setNetMachineCache(IDroneControlCenterMachine cache) {
        this.gtolib$cache = cache;
    }

    @Unique
    private void gtolib$push_drone() {
        IDroneControlCenterMachine centerMachine = (IDroneControlCenterMachine)this.getNetMachine();
        if (centerMachine == null) {
            return;
        }
        int eu = this.inventory.size << 4;
        Drone drone = this.getFirstUsableDrone(d -> d.getCharge() >= (long)eu);
        if (drone == null || !drone.start(4, eu, "gtocore.drone.removing_ash")) {
            return;
        }
        for (int i = 0; i < this.inventory.size; ++i) {
            ItemStack stack = this.inventory.stacks[i];
            if (stack.m_41613_() <= 0) continue;
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
            MachineUtils.outputItem((IRecipeCapabilityHolder)centerMachine, (ItemStack[])new ItemStack[]{stack});
        }
    }

    public boolean hasOnWorkingMethod() {
        return true;
    }

    public boolean hasModifyRecipeMethod() {
        return false;
    }

    public boolean hasAfterWorkingMethod() {
        return false;
    }

    public boolean hasBeforeWorkingMethod() {
        return true;
    }

    public void onLoad() {
        super.onLoad();
        this.gto$chanceOfNotProduceAsh = Math.min(Math.max(this.gto$chanceOfNotProduceAsh, 0), this.getTier() * 10);
    }

    public void onUnload() {
        super.onUnload();
        this.gtolib$airScrubberCache = null;
        this.removeNetMachineCache();
    }

    public boolean isWorkingEnabled() {
        return this.gtocore$isWorkingEnabled;
    }

    public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.gtocore$isWorkingEnabled = isWorkingAllowed;
    }

    public boolean isFrontFaceFree() {
        int time = this.getOffsetTimer();
        if ((long)time > this.gtocore$refresh) {
            this.gtolib$lastFrontFaceFree = true;
            BlockPos pos = this.self().getPos();
            for (int i = 0; i < 3; ++i) {
                pos = pos.m_121945_(this.self().getFrontFacing());
                if (this.self().getLevel().m_8055_(pos).m_60795_()) continue;
                this.gtolib$lastFrontFaceFree = false;
            }
            this.gtocore$refresh = time + 100;
        }
        return this.gtolib$lastFrontFaceFree;
    }

    @Unique
    public boolean gtolib$checkAshFull() {
        ItemStack item = this.inventory.getStackInSlot(this.inventory.getSlots() - 1);
        int count = item.m_41613_();
        if (count == 0) {
            return false;
        }
        return count == 64 || item.m_41720_() != ItemMap.ASH.m_41720_();
    }

    public int gtolib$getRecoveryChance() {
        return this.gto$chanceOfNotProduceAsh;
    }

    public void recoverItemsTable(ItemStack recoveryItems) {
        AirScrubberMachine machine = this.getAirScrubberMachine();
        if (machine != null && GTValues.RNG.m_188503_(machine.getTier() << 2) > 1) {
            MachineUtils.outputItem((IRecipeCapabilityHolder)machine, (ItemStack[])new ItemStack[]{recoveryItems});
            return;
        }
        CustomItemStackHandler.insertItemStackedFast((CustomItemStackHandler)this.inventory, (ItemStack)recoveryItems);
        if (this.inventory.getStackInSlot(this.inventory.size - this.tier - 1).m_41613_() > 0) {
            this.gtolib$push_drone();
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void gtolib$init(MetaMachineBlockEntity holder, int tier, CallbackInfo ci) {
        this.inventory.setOnContentsChanged(() -> {
            for (IMultiController controller : this.getControllers()) {
                if (!(controller instanceof IRecipeLogicMachine)) continue;
                IRecipeLogicMachine recipeLogicMachine = (IRecipeLogicMachine)controller;
                recipeLogicMachine.getRecipeLogic().updateTickSubscription();
            }
        });
        this.gtocore$isWorkingEnabled = false;
    }

    @Inject(method={"createUI"}, at={@At(value="RETURN")}, remap=false, cancellable=true)
    private void gtolib$createUI(Player entityPlayer, CallbackInfoReturnable<ModularUI> cir) {
        ModularUI originUI = (ModularUI)cir.getReturnValue();
        if (GTCEu.isDev()) {
            int rowSize = (int)Math.sqrt(this.inventory.getSlots());
            int xOffset = rowSize == 10 ? 9 : 0;
            ModularUI modular = new ModularUI(176 + xOffset * 2, 18 + 18 * rowSize + 94, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new LabelWidget(10, 5, this.getBlockState().m_60734_().m_7705_())).widget((Widget)UITemplate.bindPlayerInventory((Inventory)entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT, (int)(7 + xOffset), (int)(18 + 18 * rowSize + 12), (boolean)true));
            for (int y = 0; y < rowSize; ++y) {
                for (int x = 0; x < rowSize; ++x) {
                    int index = y * rowSize + x;
                    modular.widget((Widget)new SlotWidget((IItemHandlerModifiable)this.inventory, index, 88 - rowSize * 9 + x * 18 + xOffset, 18 + y * 18, true, true).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT));
                }
            }
            originUI = modular;
        }
        ConfiguratorPanel configuratorPanel = new ConfiguratorPanel(-26, originUI.getHeight());
        cir.setReturnValue((Object)originUI.widget((Widget)configuratorPanel));
        this.attachConfigurators(configuratorPanel);
        configuratorPanel.setSelfPosition(new Position(-26, originUI.getHeight() - configuratorPanel.getSize().height - 4));
    }

    public Widget createMainPage(FancyMachineUIWidget widget2) {
        return super.createMainPage(widget2);
    }

    public void gtolib$addMufflerEffect() {
        List entities = this.self().getLevel().m_45976_(LivingEntity.class, new AABB(this.self().getPos().m_121945_(this.self().getFrontFacing())));
        entities.forEach(e -> {
            e.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 80, 2));
            e.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 40, 1));
        });
    }
}

