/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.registry;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.SimpleGeneratorMachine;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.client.renderer.machine.SimpleGeneratorMachineRenderer;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gtocore.utils.register.MachineRegisterUtils;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import com.gtolib.api.registries.GTOMachineBuilder;
import com.gtolib.api.registries.GTORegistration;
import com.gtolib.utils.GTOUtils;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GTMachineUtils.class})
public final class GTMachineUtilsMixin {
    @Inject(method={"registerTieredMachines"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void registerTieredMachines(String name, BiFunction<MetaMachineBlockEntity, Integer, MetaMachine> factory, BiFunction<Integer, GTOMachineBuilder, MachineDefinition> builder, int[] tiers, CallbackInfoReturnable<MachineDefinition[]> cir) {
        if (name.equals("macerator")) {
            cir.setReturnValue((Object)MachineRegisterUtils.registerTieredGTMMachines("macerator", (holder, tier) -> new SimpleTieredMachine(holder, tier.intValue(), GTMachineUtils.defaultTankSizeFunction, new Object[0]), (tier, builder1) -> {
                GTOMachineBuilder gTOMachineBuilder = builder1.editableUI((EditableMachineUI)SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id((String)"macerator"), GTRecipeTypes.MACERATOR_RECIPES)).nonYAxisRotation().recipeType(GTRecipeTypes.MACERATOR_RECIPES);
                return gTOMachineBuilder.addOutputLimit((RecipeCapability)ItemRecipeCapability.CAP, switch (tier) {
                    case 1, 2 -> 1;
                    case 3 -> 3;
                    default -> 4;
                }).recipeModifier((RecipeModifier)RecipeModifierFunction.OVERCLOCKING).workableTieredHullRenderer(GTCEu.id((String)"block/machines/macerator")).tooltips(GTMachineUtils.workableTiered((int)tier, (long)GTValues.V[tier], (long)(GTValues.V[tier] << 6), (GTRecipeType)GTRecipeTypes.MACERATOR_RECIPES, (long)((Integer)GTMachineUtils.defaultTankSizeFunction.apply(tier)).intValue(), (boolean)true)).register();
            }, GTMachineUtils.ELECTRIC_TIERS));
        }
    }

    @Inject(method={"registerSimpleGenerator"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void registerSimpleGenerator(String name, GTRecipeType recipeType, Int2IntFunction tankScalingFunction, float hazardStrengthPerOperation, int[] tiers, CallbackInfoReturnable<MachineDefinition[]> cir) {
        cir.setReturnValue((Object)MachineRegisterUtils.registerTieredGTMMachines(name, (holder, tier) -> new SimpleGeneratorMachine(holder, tier.intValue(), hazardStrengthPerOperation * (float)tier.intValue(), tankScalingFunction, new Object[0]), (tier, builder) -> builder.editableUI((EditableMachineUI)SimpleGeneratorMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id((String)name), recipeType)).allRotation().recipeType(recipeType).recipeModifier(RecipeModifierFunction.SIMPLE_GENERATOR_MACHINEMODIFIER).addOutputLimit((RecipeCapability)ItemRecipeCapability.CAP, 0).addOutputLimit((RecipeCapability)FluidRecipeCapability.CAP, 0).renderer(() -> new SimpleGeneratorMachineRenderer(tier.intValue(), GTCEu.id((String)("block/generators/" + name)))).tooltips(new Component[]{Component.m_237110_((String)"gtocore.machine.efficiency.tooltip", (Object[])new Object[]{GTOUtils.getGeneratorEfficiency((GTRecipeType)recipeType, (int)tier)}).m_130946_("%")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.amperage_out", (Object[])new Object[]{GTOUtils.getGeneratorAmperage((int)tier)})}).tooltips(GTMachineUtils.workableTiered((int)tier, (long)GTValues.V[tier], (long)(GTValues.V[tier] << 6), (GTRecipeType)recipeType, (long)((Integer)tankScalingFunction.apply(tier)).intValue(), (boolean)false)).register(), tiers));
    }

    @Inject(method={"registerSimpleMachines(Ljava/lang/String;Lcom/gregtechceu/gtceu/api/recipe/GTRecipeType;Lit/unimi/dsi/fastutil/ints/Int2IntFunction;Z[I)[Lcom/gregtechceu/gtceu/api/machine/MachineDefinition;"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void registerSimpleMachines(String name, GTRecipeType recipeType, Int2IntFunction tankScalingFunction, boolean hasPollutionDebuff, int[] tiers, CallbackInfoReturnable<MachineDefinition[]> cir) {
        cir.setReturnValue((Object)MachineRegisterUtils.registerTieredGTMMachines(name, (holder, tier) -> new SimpleTieredMachine(holder, tier.intValue(), tankScalingFunction, new Object[0]), (tier, builder) -> builder.editableUI((EditableMachineUI)SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id((String)name), recipeType)).nonYAxisRotation().recipeType(recipeType).recipeModifier(RecipeModifierFunction.OVERCLOCKING).workableTieredHullRenderer(GTCEu.id((String)("block/machines/" + name))).tooltips(GTMachineUtils.workableTiered((int)tier, (long)GTValues.V[tier], (long)(GTValues.V[tier] << 6), (GTRecipeType)recipeType, (long)((Integer)tankScalingFunction.apply(tier)).intValue(), (boolean)true)).register(), tiers));
    }

    @Overwrite(remap=false)
    public static MultiblockMachineDefinition registerLargeCombustionEngine(String name, int tier, Supplier<? extends Block> casing, Supplier<? extends Block> gear, Supplier<? extends Block> intake, ResourceLocation casingTexture, ResourceLocation overlayModel) {
        return MachineRegisterUtils.registerLargeCombustionEngine(GTORegistration.GTM, name, null, tier, GTRecipeTypes.COMBUSTION_GENERATOR_FUELS, casing, gear, intake, casingTexture, overlayModel, true);
    }

    @Overwrite(remap=false)
    public static MultiblockMachineDefinition registerLargeTurbine(String name, int tier, GTRecipeType recipeType, Supplier<? extends Block> casing, Supplier<? extends Block> gear, ResourceLocation casingTexture, ResourceLocation overlayModel, boolean needsMuffler) {
        return MachineRegisterUtils.registerLargeTurbine(GTORegistration.GTM, name, null, tier, false, recipeType, casing, gear, casingTexture, overlayModel, true);
    }
}

