<div align="center">

# <img src="https://raw.githubusercontent.com/vrcx-team/VRCX/master/images/VRCX.ico" width="64" height="64"> </img> VRCX

[![GitHub release](https://img.shields.io/github/release/vrcx-team/VRCX.svg)](https://github.com/vrcx-team/VRCX/releases/latest)
[![Downloads](https://img.shields.io/github/downloads/vrcx-team/VRCX/total?color=6451f1)](https://github.com/vrcx-team/VRCX/releases/latest)
[![GitHub Workflow Status](https://github.com/vrcx-team/VRCX/actions/workflows/github_actions.yml/badge.svg)](https://github.com/vrcx-team/VRCX/actions/workflows/github_actions.yml)
[![VRCX Discord Invite](https://img.shields.io/discord/854071236363550763?color=%237289DA&logo=discord&logoColor=white&label=discord)](https://vrcx.app/discord)

| [English](/README.md) |

VRCX 是一款用于 VRChat 的外部辅助小工具，可以比 VRChat 游戏客户端（无论是 PC 模式或 VR 模式）以及它的官网更方便地提供与 VRChat 相关的信息，同时能让你更轻松地完成各种操作。此外，它还提供了一些好用的功能。

# 开始使用

<div align="center">

可以从[这里](https://github.com/vrcx-team/VRCX/releases/latest)下载最新的安装程序（安装程序的文件名是`VRCX_Setup.exe`）。

如果需要，每夜（测试版）构建也可从[这里](https://vrcx.app/github/nightly)下载，或通过程序内的 `设置 -> 通用 -> VRCX 更新设置 -> 更改版本` 按钮获取。

# 功能

<div align="left">

- :family: 好友、世界和模型列表管理
    - 在 VRChat 之外管理你的好友/世界/群组以及模型列表。
    - 查看好友所在的房间，在线状态，以及他们的模型变动情况。
    - 记录与某人成为好友以及上次见面的时间。
    - 查看你和朋友们在世界中一起度过了多长时间（以及见了多少次）。
    - 监视好友的名字变更情况，再也不用担心某人改名之后忘了是谁了！
    - 保存备注，方便记住彼此。同时也可以通过这个提醒自己：你是怎么认识 TA 的？
- :electric_plug: 当你启动 VRChat 时自动启动其他程序
    - 你可以配置 VRCX，让其在启动 VRChat 时自动启动你指定的程序。
    - 例如，你可以在启动时让 VRCX 打开一个 OSC 应用或变声器。
- :mag: 以更加方便的形式搜索模型、房间、世界以及群组。
- :earth_americas: 创建本地的、没有任何限制的世界收藏夹
- :camera: 将世界数据存储在你在游戏内拍摄的照片中，这样即使几个月后也能知道当时是在什么世界拍的照片
- :bell: 监视通知，让你可以及时回复你的朋友
    - 你可以通过 VRCX 发送/接收各种邀请和好友请求，也可以通过它查看邀请中指向的房间信息。
- :scroll: 查看当前房间的统计信息和用户列表
- :tv: 查看你所在世界中正在播放的视频的实际链接，以及各种其他记录
- :bar_chart: 改进的 Discord 状态面板
    - 你可以选择在 Discord 的状态面板上显示更多关于当前房间的信息。
    - 针对 PyPyDance、LSMedia、Movies&Chill、VRDancing 等热门世界进行了深度集成。
    - 这包括世界封面图、世界名称、房间 ID、用户数量等，具体取决于你的状态设置以及房间是否为私人，公共房间还可以在状态面板上添加一个“加入”按钮！
- :crystal_ball: VR 叠加界面，可以用于实时监控所有受支持的事件以及通知
- :outbox_tray: 无需打开 Unity 即可上传模型以及世界的封面图
- :page_facing_up: 无需打开 Unity 即可管理已上传的模型以及世界的信息。
- :skull: 当 VRChat 崩溃时自动重启并重新加入崩溃之前的房间。
- :left_right_arrow: 一键导入/导出收藏列表。

## 一些其他的东西

- 想让 VRCX 的外观看起来独特一些？请查看 [Themes](https://github.com/vrcx-team/VRCX/wiki/Themes) （英语）了解如何制作界面主题
- 查看 [Building from source](https://github.com/vrcx-team/VRCX/wiki/Building-from-source) （英语）以获得从源码构建 VRCX 的相关说明
- 若想了解如何在 Linux 上运行 VRCX，请点击[这里](https://github.com/vrcx-team/VRCX/wiki/Running-VRCX-on-Linux)（英语）查看相关说明

# 界面截图

<div align="center">

<h3>登录</h3>

<table>
  <tr>
    <td align="center"><img src="https://user-images.githubusercontent.com/47104993/246643085-8a230eb9-6bac-4f83-8f6c-4b6ea76c37e2.png" alt="login"></td>
    <td align="center"><img src="https://user-images.githubusercontent.com/47104993/246643167-b3988e3d-77ab-421f-862e-1b9fc59d46e9.png" alt="2fa"></td>
  </tr>
</table>

<h3>好友动态</h3>

<img src="https://user-images.githubusercontent.com/47104993/246643541-6c3f64cb-7a22-493e-8f66-8524caff2994.png" alt="feed">

<h3>游戏日志</h3>

<img src="https://user-images.githubusercontent.com/47104993/246643608-b8472c89-ac38-4fbe-b2f3-b6bd5be06b28.png" alt="gamelog">

<h3>用户信息页</h3>

<h4>我的</h4>

<img src="https://user-images.githubusercontent.com/47104993/246643835-d4b9e008-7a64-4163-a53c-7c01bc78a780.png" alt="me">

<h4>好友信息</h4>

<img src="https://user-images.githubusercontent.com/47104993/246644739-b1d7d2df-40f2-465e-bd50-3127ee7a6fdd.png" alt="friend">

<h3>世界信息</h3>

<table>
  <tr>
    <td align="center"><img src="https://user-images.githubusercontent.com/47104993/246643937-5a5197ed-f1dc-4fd1-abed-61467107b51c.png" alt="instance"></td>
    <td align="center"><img src="https://user-images.githubusercontent.com/47104993/246643971-a82900ab-8020-48d9-a700-0fb7db7f3892.png" alt="info"></td>
  </tr>
</table>

<h3>收藏夹</h3>

<h4>好友收藏（星标）界面</h4>

<img src="https://user-images.githubusercontent.com/47104993/246644035-edf5b224-004c-4aee-b7e7-88169834ea24.png" alt="好友收藏夹">

<h4>世界收藏界面</h4>

<img src="https://user-images.githubusercontent.com/47104993/246644127-7d055aec-5df1-44af-82a9-8b107fc2329b.png" alt="world">

<h4>模型收藏界面</h4>

<img src="https://user-images.githubusercontent.com/47104993/246644243-0ccbfc65-194e-4510-a785-16a171849cd8.png" alt="模型收藏夹">

<h3>好友日志</h3>

<img src="https://user-images.githubusercontent.com/47104993/246644384-540953c8-e5aa-49d0-82da-45728483456c.png" alt="好友日志">

<h3>Discord 状态面板</h3>

<img src="https://user-images.githubusercontent.com/47104993/246644534-5d07589e-0464-46c8-a78a-1cb927fab08e.png" alt="Discord 状态面板">

<!-- The other images will be similar to this -->
</div>

## VRCX 有没有违反 VRChat 的服务条款？

**简而言之：没有违反**

VRCX 是一个外部工具，使用 VRChat API 来提供相关功能。

它并不会以任何方式修改游戏，只是合理使用 API 来提供相应的功能。它不是 mod，也不是作弊工具，更不是对游戏任何形式的修改。

要了解 VRChat 对 API 使用的相关态度，请查看 [VRChat Discord](https://discord.gg/vrchat) 服务器的 #faq 频道。

---

VRCX 未获得 VRChat 的认可，也不代表 VRChat 或任何正式参与制作或管理 VRChat 的个人/组织的观点或立场。VRChat 及所有相关内容均为 VRChat Inc. 的商标或注册商标。VRChat © VRChat Inc.
