import { createPinia } from 'pinia';

import { getSentry, isSentryOptedIn } from '../plugin';
import { createPiniaActionTrailPlugin } from '../plugin/piniaActionTrail';
import { useAdvancedSettingsStore } from './settings/advanced';
import { useAppearanceSettingsStore } from './settings/appearance';
import { useAuthStore } from './auth';
import { useAvatarProviderStore } from './avatarProvider';
import { useAvatarStore } from './avatar';
import { useChartsStore } from './charts';
import { useDiscordPresenceSettingsStore } from './settings/discordPresence';
import { useFavoriteStore } from './favorite';
import { useFeedStore } from './feed';
import { useFriendStore } from './friend';
import { useGalleryStore } from './gallery';
import { useGameLogStore } from './gameLog';
import { useGameStore } from './game';
import { useGeneralSettingsStore } from './settings/general';
import { useGroupStore } from './group';
import { useInstanceStore } from './instance';
import { useInviteStore } from './invite';
import { useLaunchStore } from './launch';
import { useLocationStore } from './location';
import { useModalStore } from './modal';
import { useModerationStore } from './moderation';
import { useNotificationStore } from './notification';
import { useNotificationsSettingsStore } from './settings/notifications';
import { usePhotonStore } from './photon';
import { useSearchStore } from './search';
import { useSharedFeedStore } from './sharedFeed';
import { useUiStore } from './ui';
import { useUpdateLoopStore } from './updateLoop';
import { useUserStore } from './user';
import { useVRCXUpdaterStore } from './vrcxUpdater';
import { useVrStore } from './vr';
import { useVrcStatusStore } from './vrcStatus';
import { useVrcxStore } from './vrcx';
import { useWorldStore } from './world';
import { useWristOverlaySettingsStore } from './settings/wristOverlay';

export const pinia = createPinia();

function registerPiniaActionTrailPlugin() {
    if (!NIGHTLY) return;
    pinia.use(createPiniaActionTrailPlugin({ maxEntries: 200 }));
}

async function registerSentryPiniaPlugin() {
    if (!NIGHTLY) return;
    if (!(await isSentryOptedIn())) return;

    const Sentry = await getSentry();

    pinia.use(
        Sentry.createSentryPiniaPlugin({
            stateTransformer: (state) => ({
                ...state,
                Auth: null,
                Feed: null,
                Favorite: null,
                Friend: null,
                User: {
                    // @ts-ignore
                    ...state.User,
                    currentUser: null,
                    subsetOfLanguages: null,
                    languageDialog: {
                        // @ts-ignore
                        ...state.User.languageDialog,
                        languages: null
                    }
                },
                GameLog: {
                    // @ts-ignore
                    ...state.GameLog,
                    gameLogTable: null
                },
                Notification: {
                    // @ts-ignore
                    ...state.Notification,
                    notificationTable: null
                },
                Moderation: {
                    // @ts-ignore
                    ...state.Moderation,
                    playerModerationTable: null,
                    cachedPlayerModerations: null,
                    cachedPlayerModerationsUserIds: null
                },
                Photon: null,
                SharedFeed: {
                    // @ts-ignore
                    ...state.SharedFeed,
                    sharedFeedData: null
                },
                Group: {
                    // @ts-ignore
                    ...state.Group,
                    groupInstances: null,
                    inGameGroupOrder: null
                },
                Avatar: {
                    // @ts-ignore
                    ...state.Avatar,
                    avatarHistory: null
                },
                Gallery: {
                    // @ts-ignore
                    ...state.Gallery,
                    emojiTable: null,
                    galleryTable: null,
                    instanceStickersCache: null,
                    inventoryTable: null,
                    printTable: null,
                    stickerTable: null,
                    VRCPlusIconsTable: null
                }
            })
        })
    );
}

export async function initPiniaPlugins() {
    await registerSentryPiniaPlugin();
    setTimeout(() => {
        registerPiniaActionTrailPlugin();
    }, 60000);
}

export function createGlobalStores() {
    return {
        advancedSettings: useAdvancedSettingsStore(),
        appearanceSettings: useAppearanceSettingsStore(),
        discordPresenceSettings: useDiscordPresenceSettingsStore(),
        generalSettings: useGeneralSettingsStore(),
        notificationsSettings: useNotificationsSettingsStore(),
        wristOverlaySettings: useWristOverlaySettingsStore(),
        avatarProvider: useAvatarProviderStore(),
        favorite: useFavoriteStore(),
        friend: useFriendStore(),
        photon: usePhotonStore(),
        user: useUserStore(),
        vrcxUpdater: useVRCXUpdaterStore(),
        avatar: useAvatarStore(),
        world: useWorldStore(),
        group: useGroupStore(),
        location: useLocationStore(),
        instance: useInstanceStore(),
        moderation: useModerationStore(),
        invite: useInviteStore(),
        gallery: useGalleryStore(),
        notification: useNotificationStore(),
        feed: useFeedStore(),
        ui: useUiStore(),
        gameLog: useGameLogStore(),
        search: useSearchStore(),
        game: useGameStore(),
        launch: useLaunchStore(),
        vr: useVrStore(),
        vrcx: useVrcxStore(),
        sharedFeed: useSharedFeedStore(),
        updateLoop: useUpdateLoopStore(),
        auth: useAuthStore(),
        vrcStatus: useVrcStatusStore(),
        charts: useChartsStore(),
        modal: useModalStore()
    };
}

export {
    useAuthStore,
    useAvatarStore,
    useAvatarProviderStore,
    useFavoriteStore,
    useFeedStore,
    useFriendStore,
    useGalleryStore,
    useGameStore,
    useGameLogStore,
    useGroupStore,
    useInstanceStore,
    useInviteStore,
    useLaunchStore,
    useLocationStore,
    useModerationStore,
    useNotificationStore,
    usePhotonStore,
    useSearchStore,
    useChartsStore,
    useAdvancedSettingsStore,
    useAppearanceSettingsStore,
    useDiscordPresenceSettingsStore,
    useGeneralSettingsStore,
    useNotificationsSettingsStore,
    useWristOverlaySettingsStore,
    useUiStore,
    useUserStore,
    useVrStore,
    useVrcxStore,
    useVRCXUpdaterStore,
    useWorldStore,
    useSharedFeedStore,
    useUpdateLoopStore,
    useVrcStatusStore,
    useModalStore
};
