# References/sources 
Please cite the below references if you use the respective maps!  
Please also note that some of the PET maps are released under specific licenses that are provided with the respective reference.  

While the initial collection provided with JuSpace was curated and published with the [JuSpace publication](https://doi.org/10.1002/hbm.25244), many of the later maps could be added due to the work by [Hansen et al., 2022](https://doi.org/10.1038/s41593-022-01186-3) and [Markello, Hansen et al., 2022](https://doi.org/10.1038/s41592-022-01625-w). Most of these maps were then used in [Lotter et al., 2023](https://doi.org/10.1038/s41467-024-52366-7). A related collection is also curated and provided via the Python-based [NiSpace toolbox](https://github.com/leondlotter/nispace) (under development), including some more [detailed information on the maps](https://github.com/LeonDLotter/NiSpace-data/blob/main/reference/pet/metadata.csv). 

## CBF
#### ASL_MRI: Cerebral Blood Flow
- Holiga et al., 2018: [10.1371/journal.pone.0206583](https://doi.org/10.1371/journal.pone.0206583)

## GABAa 
#### FLUMAZENIL_c11
- Dukart et al., 2018: [10.1038/s41598-018-22444-0](https://doi.org/10.1038/s41598-018-22444-0)
#### flumazenil_hc16_norgaard
- Norgaard et al., 2021: [10.1016/j.neuroimage.2021.117878](https://doi.org/10.1016/j.neuroimage.2021.117878)
- **NOTE**: This map was processed in fsaverage surface space and transformed back to MNI space. FLUMAZENIL_c11 should be preferred.

## GABAa5
#### ro154513_HC10_lukow2022
- Lukow et al., 2022: [10.1038/s42003-022-03268-1](https://doi.org/10.1038/s42003-022-03268-1)

## D1 
#### SCH23390_c11 
- Kaller et al., 2017: [10.1007/s00259-017-3645-0](https://doi.org/10.1007/s00259-017-3645-0)

## D2
#### RACLOPRIDE_c11
- Alakurtti et al., 2025: [10.1038/jcbfm.2015.53](https://doi.org/10.1038/jcbfm.2015.53)
#### fallypride_hc49_jaworska
- Jaworska et al., 2020: [10.1038/s41386-020-0662-7](https://doi.org/10.1038/s41386-020-0662-7)

## DAT
#### DATSPECT
- Dukart et al. 2018: [10.1038/s41598-018-22444-0](https://doi.org/10.1038/s41598-018-22444-0)

## NAT (NET)
#### MRB_c11
- Hesse et al., 2017: [10.1007/s00259-016-3590-3](https://doi.org/10.1007/s00259-016-3590-3)

## SERT (5HTT)
#### MADAM_c11
- Fazio et al., 2016: [10.1016/j.neuroimage.2016.03.019](https://doi.org/10.1016/j.neuroimage.2016.03.019)
- https://www.nitrc.org/projects/ki-5htt
#### DASB_HC30
- https://neurovault.org/collections/1206/
- Savli et al., 2012: [10.1016/j.neuroimage.2012.07.001](https://doi.org/10.1016/j.neuroimage.2012.07.001)
#### dasb_hc100_beliveau
- Beliveau et al., 2017: [10.1523/JNEUROSCI.2830-16.2016](https://doi.org/10.1523/JNEUROSCI.2830-16.2016)
- license: https://xtra.nru.dk/FS5ht-atlas/
- **NOTE**: This map was processed in fsaverage surface space and transformed back to MNI space. SERT_DASB (5HTT) should be preferred.

## F-Dopa
#### FDOPA_f18 
- https://www.nitrc.org/projects/spmtemplates/ 
- Garcia-Gomez et al., 2018: [10.33588/imagendiagnostica.901.2](https://doi.org/10.33588/imagendiagnostica.901.2)

## 5HT1a
#### WAY_HC36
- https://neurovault.org/collections/1206/
- Savli et al., 2012: [10.1016/j.neuroimage.2012.07.001](https://doi.org/10.1016/j.neuroimage.2012.07.001)
#### cumi_hc8_beliveau
- Beliveau et al., 2017: [10.1523/JNEUROSCI.2830-16.2016](https://doi.org/10.1523/JNEUROSCI.2830-16.2016)
- license: https://xtra.nru.dk/FS5ht-atlas/
- **NOTE**: This map was processed in fsaverage surface space and transformed back to MNI space. WAY_HC36 should be preferred.

## 5HT1b
#### P943_HC22
- https://neurovault.org/collections/1206/
- Savli et al., 2012: [10.1016/j.neuroimage.2012.07.001](https://doi.org/10.1016/j.neuroimage.2012.07.001) 
#### az_hc36_beliveau
- Beliveau et al., 2017: [10.1523/JNEUROSCI.2830-16.2016](https://doi.org/10.1523/JNEUROSCI.2830-16.2016)
- license: https://xtra.nru.dk/FS5ht-atlas/
- **NOTE**: This map was processed in fsaverage surface space and transformed back to MNI space. P943_HC22 should be preferred.

## 5HT2a
#### ALT_HC19
- https://neurovault.org/collections/1206/
- Savli et al., 2012: [10.1016/j.neuroimage.2012.07.001](https://doi.org/10.1016/j.neuroimage.2012.07.001) 
#### cimbi_hc29_beliveau
- Beliveau et al., 2017: [10.1523/JNEUROSCI.2830-16.2016](https://doi.org/10.1523/JNEUROSCI.2830-16.2016)
- license: https://xtra.nru.dk/FS5ht-atlas/
- **NOTE**: This map was processed in fsaverage surface space and transformed back to MNI space. ALT_HC19 should be preferred.

## 5HT4
#### sb20_hc59_beliveau
- Beliveau et al., 2017: [10.1523/JNEUROSCI.2830-16.2016](https://doi.org/10.1523/JNEUROSCI.2830-16.2016)
- license: https://xtra.nru.dk/FS5ht-atlas/
- **NOTE**: This map was processed in fsaverage surface space and transformed back to MNI space. There is no alternative, but use with care!

## 5HT6
#### gsk215083_HC30_radhakrishnan2018
- Radhakrishnan et al., 2018: [10.2967/jnumed.117.206516](https://doi.org/10.2967/jnumed.117.206516)
- Radhakrishnan et al., 2020: [10.1016/j.pscychresns.2019.111007](https://doi.org/10.1016/j.pscychresns.2019.111007)

## MU
#### CARFENTANIL_c11
- https://identifiers.org/neurovault.image:303255
- Kantonen et al., 2020: [10.1038/mp.2017.183](https://doi.org/10.1016/10.1038/mp.2017.183)
#### carfentanil_hc39_turtonen
- Turtonen et al., 2021: [10.1016/j.bpsc.2020.10.013](https://doi.org/10.1016/j.bpsc.2020.10.013)

## Kappa Opiod
#### KappaOp_LY2795050_10m_ShokriKojori
- Shokri-Kojori et al., 2022: [10.1002/hbm.25733](https://doi.org/10.1002/hbm.25733)
- https://github.com/eshoko/OPIOID
- license: Attribution-NonCommercial-ShareAlike 4.0 International
#### ly2795050_HC28_vijay
- Vijay et al., 2018: [10.1016/j.bpsc.2020.10.013](https://doi.org/10.1016/10.1016/j.bpsc.2020.10.013)

## mGluR5 
#### abp_hc22_rosaneto
- Hansen et al., 2022: [10.1038/s41593-022-01186-3](https://doi.org/10.1038/s41593-022-01186-3)
- license: Attribution-NonCommercial-ShareAlike 4.0 International
#### abp_hc28_dubois
- Dubois et al., 2015: [10.1007/s00259-015-3167-6](https://doi.org/10.1007/s00259-015-3167-6)
#### abp_hc73_smart
- Smart et al., 2019: [10.1007/s00259-018-4252-4](https://doi.org/10.1007/s00259-018-4252-4)

## CB1
#### FMPEPd2_hc22_laurikainen.nii 
- Laurikainen et al., 2019: [10.1016/j.neuroimage.2018.10.013](https://doi.org/10.1016/j.neuroimage.2018.10.013)
#### omar_HC77_normandin2015
- Normandin et al., 2015: [10.1016/j.neuroimage.2018.10.013](https://doi.org/10.1016/j.neuroimage.2018.10.013)

## VAChT
#### feobv_hc4_tuominen
- Hansen et al., 2022: [10.1038/s41593-022-01186-3](https://doi.org/10.1038/s41593-022-01186-3)
- license: Attribution-NonCommercial-ShareAlike 4.0 International
#### feobv_hc18_aghourian
- Aghourian et al., 2017: [10.1038/mp.2017.183](https://doi.org/10.1016/10.1038/mp.2017.183)
#### feobv_hc5_bedard
- Bedard et al., 2019: [10.1016/j.sleep.2018.12.020](https://doi.org/10.1016/j.sleep.2018.12.020)

## NMDA
#### ge179_29hc_galovic2021
- Galovic et al., 2023: [10.1001/jamaneurol.2022.4352](https://doi.org/10.1001/jamaneurol.2022.4352)
- Galovic et al., 2021: [10.1016/j.neuroimage.2021.118194](https://doi.org/10.1016/j.neuroimage.2021.118194)
- McGinnity et al., 2014: [10.2967/jnumed.113.130641](https://doi.org/10.2967/jnumed.113.130641)
- license: Attribution-NonCommercial-ShareAlike 4.0 International

## CMRglu
#### fdg_HC20_castrillon2023
- Castrillon et al., 2023: [10.1126/sciadv.adi7632](https://doi.org/10.1126/sciadv.adi7632)

## COX1
#### ps13_HC11_kim2020
- Kim et al., 2020: [10.1007/s00259-020-04855-2](https://doi.org/10.1007/s00259-020-04855-2)
- [10.18112/openneuro.ds004401.v1.0.1](https://doi.org/10.18112/openneuro.ds004401.v1.0.1)

## HDAC
#### martinostat_HC8_wey2016
- Wey et al., 2016: [10.1126/scitranslmed.aaf7551](https://doi.org/10.1126/scitranslmed.aaf7551)

## M1
#### lsn3172176_HC24_naganawa2020
- Naganawa et al., 2020: [10.2967/jnumed.120.246967](https://doi.org/10.2967/jnumed.120.246967)

## Microglia
#### TSPO_pbr28_HC6_lois2018
- Lois et al., 2018: [10.1021/acschemneuro.8b00072](https://doi.org/10.1021/acschemneuro.8b00072)
- [10.5281/zenodo.1174364](https://doi.org/10.5281/zenodo.1174364)

## SV2A
#### ucbj_HC10_finnema2016
- [10.1177/0271678X17724947](https://doi.org/10.1177/0271678X17724947)
- [10.2967/jnumed.120.246967](https://doi.org/10.2967/jnumed.120.246967)
- [10.1177/0271678X211004312](https://doi.org/10.1177/0271678X211004312)
- [10.1186/s13195-020-00742-y](https://doi.org/10.1186/s13195-020-00742-y)
- [10.1177/0271678X20946198](https://doi.org/10.1177/0271678X20946198)
- [10.1093/cid/ciab484](https://doi.org/10.1093/cid/ciab484)
- [10.1038/s41380-021-01184-0](https://doi.org/10.1038/s41380-021-01184-0)
- [10.1016/j.bpsc.2015.09.008](https://doi.org/10.1016/j.bpsc.2015.09.008)
- [10.1111/epi.16653](https://doi.org/10.1111/epi.16653)
- [10.1186/s13550-020-00670-w](https://doi.org/10.1186/s13550-020-00670-w)
- [10.1002/alz.12097](https://doi.org/10.1002/alz.12097)
- [10.1111/epi.14701](https://doi.org/10.1111/epi.14701)
- [10.1038/s41467-019-09562-7](https://doi.org/10.1038/s41467-019-09562-7)
- [10.1001/jamaneurol.2018.1836](https://doi.org/10.1001/jamaneurol.2018.1836)

## VMAT2
#### dtbz_HC76_larsen2020
- Larsen et al., 2020: [10.1038/s41467-020-14693-3](https://doi.org/10.1038/s41467-020-14693-3)
- [10.18112/openneuro.ds002385.v1.1.0](https://doi.org/10.18112/openneuro.ds002385.v1.1.0)

## A4B2
#### flubatine_HC30_hillmer2016
- Hillmer et al., 2016: [10.1016/j.neuroimage.2016.07.026](https://doi.org/10.1016/j.neuroimage.2016.07.026)
- Baldassarri et al., 2018: [10.1093/ntr/ntx091](https://doi.org/10.1093/ntr/ntx091)

## Cell type maps for glia and neurons:
Data was downloaded from the Allen Brain Institute and processed using the abagen toolbox (Markello et l., 2021, doi:10.7554/eLife.72129) with the settings described in Lotter et al. (2024). 
Instead of mapping individual mRNA samples to brain regions as in Lotter et al., here, continuous maps were interpolated by assigning to each voxel a distance-weighted average of its 10 nearest samples.
For further information regarding the cell types, see Lake et al. (2016) and Darmanis et al. (2015) as well as a summary in Lotter et al, Supplementary Data S1.
- Data source: Hawrylycz et al. (2012). "An anatomically comprehensive atlas of the adult human brain transcriptome", Nature, doi:10.1038/nature11405
- Neuronal cell markers: Lake et al. (2016). "Neuronal subtypes and diversity revealed by single-nucleus {RNA} sequencing of the human brain", Science, doi:10.1126/science.aaf1204
- Glial cell markers: Darmanis et al. (2015). "A survey of human brain transcriptome diversity at the single cell level", PNAS, doi:10.1073/pnas.1507125112
- Originally used in: Lotter et al. (2024). "Regional patterns of human cortex development correlate with underlying neurobiology", Nature Communications, doi:10.1038/s41467-024-52366-7  

## Cell type maps for mitochondria:

Maps are based on the publication by Mosharov, E.V., Rosenberg, A.M., Monzel, A.S. et al. A human brain map of mitochondrial respiratory capacity and diversity. Nature (2025). https://doi.org/10.1038/s41586-025-08740-6 and were downloaded from this neurovault directory: https://neurovault.org/collections/16418/