function [Results] = compute_DomainGauges(list1,list2,files_PET,atlas, options,image_save)
% [res,p_all,stats,data, D1,D2,data_PET] = compute_DomainGauges(list1,list2,files_PET,atlas, options, image_save)
% Inputs:
% list1, list2, files_PET are cellarrays of strings containing the filepath
% atlas cellstr of filepath to the atlas to use for DomainGauges, i.e.
% /atlas/m_labels_Neuromorphometrics.nii
% options: a numeric array, i.e. [1 1]
% first index indicates the computing option
    % option(1) = 1 --> es between
    % option(1) = 2 --> es within
    % option(1) = 3 --> mean list 1
    % option(1) = 4 --> list 1 each
    % option(1) = 5 --> ind z-score list 1 to list 2
    % option(1) = 6 --> pair-wise difference list 1 to list 2
    % options(1) = 7 --> leave one out from list 1
    % options(1) = 8 --> list 1 each compares against null distribution of
    % correlation coefficients
% second index indicates the analysis option
    % option(2) = 1 --> % Spearman correlation
    % option(2) = 2 --> % Pearson correlation
    % option(2) = 3 --> % multiple linear regresion
% if option(1) < 4 --> image_save: filepath (char) to save the produced image
% Outputs:
% [res,p_all,stats,data, D1,D2,data_PET]
% res --> Fisher's z transformed correlation / multiple linear regression coefficient matrix, rows correspond to
% input files, columns to PET maps
% p_all --> p-values from one-sample t-test testing if the Fisher's z
% transformed correlations /regression coefficients are different from zero
% stats --> Summary statistics
% stats.CorrOrig --> not Fisher's z transformed individual correlation
% coefficients
% stats.p_ind --> p-values for correlations (CorrOrig) of individual files with PET
% maps 
% stats.res_ind --> Individual Fisher's z-transformed correlation
% coefficients / regression coefficients
% stats.ci95 --> 95% confidence interval of the one sample t-test for
% the group test if the correlation coefficient distribution is different
% from 0 (see also the p_all output)
% D1 --> data matrix from list 1
% D2 --> data matrix for list 2 (if not empty)
% data_PET --> PET data matrix
% Resh --> Reshaped results matrix [file_index PET_map Correlation_result p-value file_path]


atlas_hdr = spm_vol(atlas);
atlas1 = spm_read_vols(atlas_hdr);
[a,b,c] = unique(atlas1(:));
a = a(a~=0);
atlas_vals = a(~isnan(a));

D1 = mean_time_course(list1,atlas, atlas_vals);

if ~isemptycell(list2)
    D2 = mean_time_course(list2,atlas, atlas_vals); 
else
    D2 = [];
end

data_PET = mean_time_course(files_PET,atlas,atlas_vals);

if options(4)==1 % adjust for structural correlation
    if isdeployed
        [~, ~] = system('path');
        path_base = pwd; 
        path_T1 = fullfile(path_base,'mask','TPM.nii,1');
    else
        path_T1 = fullfile(fileparts(which('JuSpace')),'mask','TPM.nii,1');
    end
    T1 =  mean_time_course({path_T1},atlas, atlas_vals); 
else
    T1 = '';
end

switch options(1)
    % opt_comp = 1 --> es between
    % opt_comp = 2 --> es within
    % opt_comp = 3 --> mean list 1
    % opt_comp = 4 --> list 1 each
    % opt_comp = 5 --> ind z-score list 1 to list 2
    % opt_comp = 6 --> pair-wise difference list 1 to list 2
    % opt_comp = 7 --> ind z-scores from list 1
    % opt_comp = 8 --> list 1 each compares against null distribution of
    % correlation coefficients
    case 1 % Cohen's d between groups
        m_D1 = mean(D1);
        std_D1 = std(D1);
        m_D2 = mean(D2);
        std_D2 = std(D2);
        data = (m_D1-m_D2)./sqrt((std_D1.^2+std_D2.^2)./2);
    case 2 % Cohen's d within group change
        delta_d = D1-D2;
        data = mean(delta_d)./std(delta_d);
    case 3 % mean list 1
        if size(D1,1)==1
            data = D1;
        else
            data = mean(D1);
        end
    case 4 % list 1 with PET data
        data = D1;
    case 5 % compute z-score list 1 relative to list 2
        m_D2 = mean(D2);
        std_D2 = std(D2);
        data = (D1 - repmat(m_D2,size(D1,1),1))./repmat(std_D2,size(D1,1),1);
    case 6 % pair-wise differences list 1 - list 2
        data = D1 - D2;
    case 7 % leave one out
        for i = 1:size(D1,1)
            data_i = D1(i,:);
            data_z = D1([1:i-1 i+1:end],:);
            data(i,:) = (data_i-mean(data_z))./std(data_z);
        end
    case 8
        data = D1;
end

% if options(2) == 3 % 1 = Spearman, 2 = Pearson, 3 = multiple linear regression
%     [res,p_all,stats] = correlateModalities(data,data_PET, options(2));
% else
if options(4)==1
    [res,stats] = correlateModalities(data,data_PET,options,T1);
else 
    [res,stats] = correlateModalities(data,data_PET,options);
end
% end
if options(2) < 3
    [Resh] = reshape_res(options,res, files_PET,list1, stats.corrOrig);
else
    [Resh] = reshape_res(options,res, files_PET,list1);
end
    a = 1;
    if options(1)<4
        Y = zeros(size(atlas1));
        for i = 1:length(atlas_vals)
            Y(atlas1(:)==atlas_vals(i)) = data(i);
        end
        atlas_hdr.fname = image_save;
        atlas_hdr.pinfo(1) = 0.001;
        atlas_hdr.dt = [16 0];
        spm_write_vol(atlas_hdr,Y);
    end
    
    
    Results.res = res;
    Results.stats = stats;
    Results.data = data;
    Results.data_set1 = D1;
    Results.data_set2 = D2;
    Results.data_PET = data_PET;
    Results.T1 = T1;
    Results.Resh = Resh;

end

function [res,stats] = correlateModalities(data,data_PET,opts,T1)
    

for i = 1:size(data,1)
    switch opts(2)
        case 1 % Spearman correlation
            for j = 1:size(data_PET,1)
                if opts(4)==1
                    data_ij = removenan_my([data',data_PET',T1']);
                    [r] = partialcorr(data_ij(:,1:size(data',2)),data_ij(:,size(data',2)+1:size(data',2)+size(data_PET',2)),data_ij(:,size(data',2)+size(data_PET',2)+1:end),'type','Spearman');
                else
                    data_ij = removenan_my([data',data_PET']);
                    [r] = corr(data_ij(:,1:size(data',2)),data_ij(:,size(data',2)+1:size(data',2)+size(data_PET',2)),'type','Spearman');
                end
                    corrOrig = r;

            end
            res_ind = fishers_r_to_z(corrOrig);
            stats.corrOrig = corrOrig;
            stats.res_ind = res_ind;
            
            
        case 2 % Pearson correlation
            for j = 1:size(data_PET,1)
                if opts(4)==1
                    data_ij = removenan_my([data',data_PET',T1']);
                    [r,p] = partialcorr(data_ij(:,1:size(data',2)),data_ij(:,size(data',2)+1:size(data',2)+size(data_PET',2)),data_ij(:,size(data',2)+size(data_PET',2)+1:end),'type','Pearson');
                else
                    data_ij = removenan_my([data',data_PET']);
                    [r,p] = corr(data_ij(:,1:size(data',2)),data_ij(:,size(data',2)+1:size(data',2)+size(data_PET',2)),'type','Pearson');
                end
                    corrOrig = r;
                    p_ind = p;
            end 
            res_ind = fishers_r_to_z(corrOrig);
            stats.corrOrig = corrOrig;
            stats.p_ind = p_ind;
            stats.res_ind = res_ind;
        
        case 3 % multiple linear regresion
            
            y = data(i,:)';
            if opts(4)==1
                X = [data_PET' T1'];
                ind_PET = 2:size(X,2);
            else
                X = [data_PET'];
                ind_PET = 2:size(X,2)+1;
            end
            
            dd = removenan_my([y X]);
            y = dd(:,1);
            y = zscore(y);
            
            X = dd(:,2:end);
            X = zscore(X);
            
%             X = zscore(X); % zscore_update
            Stats = regstats(y,X);
            res_ind(i,:) = Stats.beta(ind_PET)';
            stats.res_ind(i,:) = Stats.beta(ind_PET)';
            stats.ind(i).p_ftest_full = Stats.fstat.pval;
            stats.ind(i).f_ftest_full = Stats.fstat.f;
            stats.ind(i).t_all = Stats.tstat.t;
            stats.p_ind(i,:) = Stats.tstat.pval(ind_PET)';
            stats.rsquare(i,1) = Stats.rsquare;
    end
end

    % opt_comp = 1 --> es between
    % opt_comp = 2 --> es within
    % opt_comp = 3 --> mean list 1
    % opt_comp = 4 --> list 1 each
    % opt_comp = 5 --> ind z-score list 1 to list 2
    % opt_comp = 6 --> pair-wise difference list 1 to list 2
    % opt_comp = 7 --> ind z-scores from list 1
    % opt_comp = 8 --> list 1 each compares against null distribution of
    % correlation coefficients
 switch opts(1)
     case {1,2,3,4} 
     res = res_ind;     
     case {5,6,7,8}
         if size(res_ind,1)>1
             res = mean(res_ind);
             [h,p_all,ci] = ttest(res_ind);
             stats.ci95 = ci;
         end
 end

end

function [Resh]  = reshape_res(options,res, files_PET,list1, corrOrig)


for i = 1:length(files_PET);
   [path,name] = fileparts(files_PET{i});
   tt = regexp(name,'_','Split');
   Rec_list{i}=tt{1};
end
% 
% switch options(1)
%     case 1
%         ff = 'Effect Size';
%     case 2
%         ff = 'Effect Size (within subject)';
%     case 3
%         ff = 'Mean list';
%     case 4
%         ff = 'List 1 image';
%     case 5
%         ff = 'Z-score file';
%     case 6
%         ff = 'Delta';
%     case 7
%         ff = 'Z-score loo';
%     case 8
%         ff = 'List 1 all against null';
%         
% end

switch options(2)
    case 1
        if options(1)<4
%             Resh = {ff 'PET Map' 'Fisher''s z (Spearman rho)' 'p-val (parametric)' 'File'};
              Resh = {'PET Map' 'Fisher''s z ' 'Spearman rho' 'File Modality' 'PET or cell map'};
        else
             Resh = { 'PET Map' 'Mean Fisher''s z' 'Median Spearman rho' 'File' 'PET or cell map'};
        end
    case 2
        if options(1)<4
             Resh = {'PET Map' 'Fisher''s z' 'Pearson r' 'File' 'PET or cell map'};
        else
             Resh = {'PET Map' 'Mean Fisher''s z' 'Median Pearson r)' 'File' 'PET or cell map'};
        end
    otherwise
             Resh = {'PET Map' 'Standardized Beta' 'File' 'PET or cell map'};
end

if exist('corrOrig','var')
    if size(corrOrig,1)>1 && size(res,1)==1
        corrOrig = median(corrOrig);
    end
end

for i = 1:size(res,1)
    for j = 1:size(res,2)
        if options(2)<3
           Resh{end+1,1} = Rec_list{j};
           Resh{end,2} = res(i,j);
           Resh{end,3} = corrOrig(i,j);
           Resh{end,4} = list1{i};
           Resh{end,5} = files_PET{j};
        else
           Resh{end+1,1} = Rec_list{j};
           Resh{end,2} = res(i,j);
           Resh{end,3} = list1{i};
           Resh{end,4} = files_PET{j};
        end
    end
end
end
