/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.common;

public final class BuildResult<T> {
    private final boolean success;
    private final String message;
    private final FormatType format;
    private final T data;

    private BuildResult(boolean success, String message, FormatType format, T data) {
        this.success = success;
        this.message = message;
        this.format = format;
        this.data = data;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public FormatType getFormat() {
        return this.format;
    }

    public T getData() {
        return this.data;
    }

    public static <T> BuildResult<T> success(T data) {
        return new BuildResult<T>(true, null, null, data);
    }

    public static <T> BuildResult<T> success(T data, String message) {
        return new BuildResult<T>(true, message, null, data);
    }

    public static <T> BuildResult<T> fail(String message) {
        return new BuildResult<Object>(false, message, null, null);
    }

    public static <T> BuildResult<T> fail(String message, FormatType format) {
        return new BuildResult<Object>(false, message, format, null);
    }

    public BuildResult<T> withMessage(String message) {
        return new BuildResult<T>(this.success, message, this.format, this.data);
    }

    public BuildResult<T> withFormat(FormatType format) {
        return new BuildResult<T>(this.success, this.message, format, this.data);
    }

    public <N> BuildResult<N> withData(N data) {
        FormatType newFormat = this.format;
        if (data != null) {
            newFormat = data instanceof byte[] ? FormatType.BYTE : (data instanceof String ? FormatType.STRING : FormatType.OBJECT);
        }
        return new BuildResult<N>(this.success, this.message, newFormat, data);
    }

    public String toString() {
        return "BuildResult{success=" + this.success + ", message='" + this.message + '\'' + ", format=" + (Object)((Object)this.format) + ", data=" + this.data + '}';
    }

    public static enum FormatType {
        BYTE,
        STRING,
        OBJECT;

    }
}

