/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.common;

public class Result<T> {
    private String message = "";
    private Boolean status = false;
    private int code = 0;
    private T data;

    public static <T> Result success(T data) {
        Result result = Result.success();
        result.setData(data);
        result.setCode(0);
        return result;
    }

    public static <T> Result successMsg(String message) {
        Result result = Result.success();
        result.setMessage(message);
        result.setCode(0);
        return result;
    }

    public static <T> Result success() {
        Result<T> result = new Result<T>();
        result.setStatus(true);
        result.setCode(0);
        return result;
    }

    public static <T> Result error(String message) {
        Result<T> result = new Result<T>();
        result.setMessage(message);
        result.setStatus(false);
        result.setCode(500);
        return result;
    }

    public Result error() {
        this.setStatus(false);
        this.setCode(500);
        return this;
    }

    public boolean isSuccess() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public int getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        Boolean this$status = this.getStatus();
        Boolean other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        Boolean $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(message=" + this.getMessage() + ", status=" + this.getStatus() + ", code=" + this.getCode() + ", data=" + this.getData() + ")";
    }
}

