/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.common.util;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class ByteHelper {
    public static byte[] int2bytes(int x) {
        byte[] bb = new byte[]{(byte)(x >> 24), (byte)(x >> 16), (byte)(x >> 8), (byte)(x >> 0)};
        return bb;
    }

    public static int bytes2int(byte[] bb, int idx) {
        return (bb[idx] & 0xFF) << 24 | (bb[idx + 1] & 0xFF) << 16 | (bb[idx + 2] & 0xFF) << 8 | (bb[idx + 3] & 0xFF) << 0;
    }

    public static byte[] long2bytes(long x) {
        byte[] bb = new byte[]{(byte)(x >> 56), (byte)(x >> 48), (byte)(x >> 40), (byte)(x >> 32), (byte)(x >> 24), (byte)(x >> 16), (byte)(x >> 8), (byte)(x >> 0)};
        return bb;
    }

    public static long bytes2long(byte[] bb, int idx) {
        return ((long)bb[idx] & 0xFFL) << 56 | ((long)bb[idx + 1] & 0xFFL) << 48 | ((long)bb[idx + 2] & 0xFFL) << 40 | ((long)bb[idx + 3] & 0xFFL) << 32 | ((long)bb[idx + 4] & 0xFFL) << 24 | ((long)bb[idx + 5] & 0xFFL) << 16 | ((long)bb[idx + 6] & 0xFFL) << 8 | ((long)bb[idx + 7] & 0xFFL) << 0;
    }

    public static byte[] combine(byte[] b1, byte[] b2) {
        byte[] ret = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, ret, 0, b1.length);
        System.arraycopy(b2, 0, ret, b1.length, b2.length);
        return ret;
    }

    public static String bytesToHexString(byte[] src) {
        return Hex.encodeHexString(src);
    }

    public static byte[] hexStringToBytes(String hexString) {
        try {
            return Hex.decodeHex(hexString);
        }
        catch (DecoderException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static byte[] copy(byte[] array, int from, int to) {
        if (to - from < 0) {
            return new byte[0];
        }
        byte[] a = new byte[to - from];
        System.arraycopy(array, from, a, 0, to - from);
        return a;
    }

    public static int copy(byte[] des, int desPos, byte[] src, int srcPos, int length) {
        System.arraycopy(src, srcPos, des, desPos, length);
        int resPos = srcPos + length;
        return length;
    }

    public static void writeLong(byte[] bytes, int offset, long value) {
        bytes[offset] = (byte)(0xFFL & value >> 56);
        bytes[offset + 1] = (byte)(0xFFL & value >> 48);
        bytes[offset + 2] = (byte)(0xFFL & value >> 40);
        bytes[offset + 3] = (byte)(0xFFL & value >> 32);
        bytes[offset + 4] = (byte)(0xFFL & value >> 24);
        bytes[offset + 5] = (byte)(0xFFL & value >> 16);
        bytes[offset + 6] = (byte)(0xFFL & value >> 8);
        bytes[offset + 7] = (byte)(0xFFL & value);
    }

    public static void writeInt(byte[] bytes, int offset, int value) {
        bytes[offset] = (byte)(0xFF & value >> 24);
        bytes[offset + 1] = (byte)(0xFF & value >> 16);
        bytes[offset + 2] = (byte)(0xFF & value >> 8);
        bytes[offset + 3] = (byte)(0xFF & value);
    }

    public static void short2bytes(short value, byte[] bytes, int off) {
        bytes[off + 1] = (byte)value;
        bytes[off] = (byte)(value >>> 8);
    }

    public static void long2bytes(long value, byte[] bytes, int off) {
        bytes[off + 7] = (byte)value;
        bytes[off + 6] = (byte)(value >>> 8);
        bytes[off + 5] = (byte)(value >>> 16);
        bytes[off + 4] = (byte)(value >>> 24);
        bytes[off + 3] = (byte)(value >>> 32);
        bytes[off + 2] = (byte)(value >>> 40);
        bytes[off + 1] = (byte)(value >>> 48);
        bytes[off] = (byte)(value >>> 56);
    }

    public static void int2bytes(int value, byte[] bytes, int off) {
        bytes[off + 3] = (byte)value;
        bytes[off + 2] = (byte)(value >>> 8);
        bytes[off + 1] = (byte)(value >>> 16);
        bytes[off] = (byte)(value >>> 24);
    }
}

