/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.common.util;

import com.ar3h.chains.common.exception.ThrowsUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;

public class FileHelper {
    public static byte[] fileGetContent(String filepath) throws IOException {
        File file = new File(filepath);
        if (file.exists() && file.isFile()) {
            return Files.readAllBytes(file.toPath());
        }
        throw new FileNotFoundException(filepath);
    }

    public static String fileGetContentString(String filepath) {
        try {
            return new String(FileHelper.fileGetContent(filepath));
        }
        catch (IOException e) {
            ThrowsUtil.throwGadgetException(e);
            return null;
        }
    }

    public static void filePutContent(String filepath, byte[] data) throws IOException {
        if (filepath != null && data != null) {
            try (OutputStream outputStream = Files.newOutputStream(Paths.get(filepath, new String[0]), new OpenOption[0]);){
                outputStream.write(data);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        throw new FileNotFoundException(filepath);
    }

    public static Set readFile(String filename) {
        InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        if (resourceAsStream == null) {
            resourceAsStream = FileHelper.class.getClassLoader().getResourceAsStream(filename);
        }
        if (resourceAsStream == null) {
            resourceAsStream = FileHelper.class.getResourceAsStream(filename);
        }
        StringBuilder textBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8));){
            int c = 0;
            while ((c = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)c);
            }
        }
        catch (IOException e) {
            ThrowsUtil.throwGadgetException(e);
        }
        String[] classNames = textBuilder.toString().split("\n");
        HashSet classNameSet = new HashSet();
        Arrays.stream(classNames).forEach(name -> {
            if (name.trim().length() > 0) {
                classNameSet.add(name.trim());
            }
        });
        return classNameSet;
    }

    public static String getRandomClassName() {
        Set set = FileHelper.readFile("classNames.txt");
        ArrayList list = new ArrayList(set);
        int randomIndex = new Random().nextInt(list.size());
        String randomItem = (String)list.get(randomIndex);
        randomItem = randomItem + UUID.randomUUID().toString().replaceAll("-", "");
        return randomItem;
    }

    public static String getRandomSimpleClassName() {
        String[] split2 = FileHelper.getRandomClassName().split("\\.");
        return split2[split2.length - 1];
    }

    public static String compressFileToBase64(String inputFilePath) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (FileInputStream fileInputStream = new FileInputStream(inputFilePath);
             GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = fileInputStream.read(buffer)) > 0) {
                gzipOutputStream.write(buffer, 0, len);
            }
        }
        byte[] compressedBytes = byteArrayOutputStream.toByteArray();
        String base64Encoded = Base64.getEncoder().encodeToString(compressedBytes);
        return base64Encoded;
    }

    public static String compressBytesToBase64(byte[] bytes) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
            gzipOutputStream.write(bytes);
        }
        byte[] compressedBytes = byteArrayOutputStream.toByteArray();
        return Base64.getEncoder().encodeToString(compressedBytes);
    }

    public static byte[] inputStreamToByteArray(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, length);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static List<String> cutString(String input, int length) {
        ArrayList<String> result = new ArrayList<String>();
        for (int start = 0; start < input.length(); start += length) {
            int end = Math.min(start + length, input.length());
            result.add(input.substring(start, end));
        }
        return result;
    }
}

