/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.common.util;

import com.ar3h.chains.common.exception.ThrowsUtil;
import com.ar3h.chains.common.util.CommonUtil;
import com.ar3h.chains.common.util.ShortClassVisitor;
import com.ar3h.chains.common.util.ThirdLibsClassLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import jmg.core.util.JavassistUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavassistHelper {
    private static final Logger log;
    public static ClassPool pool;
    private CtClass ctClass;
    private String className;
    private int version;
    private boolean compress = false;

    public JavassistHelper(Class clazz) {
        this(clazz.getName());
    }

    public JavassistHelper(String name) {
        try {
            this.ctClass = pool.get(name);
        }
        catch (NotFoundException e) {
            this.ctClass = pool.makeClass(name);
        }
    }

    public JavassistHelper(byte[] bytes) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        try {
            this.ctClass = pool.makeClass(byteArrayInputStream);
            this.className = this.ctClass.getName();
            this.ctClass.defrost();
        }
        catch (IOException e) {
            ThrowsUtil.throwGadgetException(e);
        }
    }

    public JavassistHelper(CtClass ctClass) {
        this.ctClass = ctClass;
    }

    public static ClassPool getPool() {
        return pool;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        if (this.ctClass.isFrozen()) {
            this.ctClass.defrost();
        }
        this.ctClass.setName(className);
        this.className = className;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void handleTemplatesImpl(Class abstractTranslet) {
        try {
            this.setSuperClass(abstractTranslet);
            log.info("using AbstractTranslet class: " + abstractTranslet);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertField(String fieldName, String value) throws Exception {
        Class<JavassistHelper> clazz = JavassistHelper.class;
        synchronized (JavassistHelper.class) {
            if (this.ctClass.isFrozen()) {
                this.ctClass.defrost();
            }
            try {
                CtField field = this.ctClass.getDeclaredField(fieldName);
                this.ctClass.removeField(field);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            this.ctClass.addField(CtField.make(value, this.ctClass));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void setSerialVersionUID(String value) throws Exception {
        this.insertField("serialVersionUID", "private static final long serialVersionUID = " + value + ";");
    }

    public static synchronized void insertField(CtClass ctClass, String fieldName, String fieldCode) throws Exception {
        ctClass.defrost();
        try {
            CtField field = ctClass.getDeclaredField(fieldName);
            ctClass.removeField(field);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        ctClass.addField(CtField.make(fieldCode, ctClass));
    }

    public void handleFastjsonGroovyASTTransformation() {
        this.implementInterface("org.codehaus.groovy.transform.ASTTransformation");
        this.addAnnotation("org.codehaus.groovy.transform.GroovyASTTransformation");
    }

    public void modifyStringField(String fieldName, String value) {
        try {
            CtField deleteField = this.ctClass.getDeclaredField(fieldName);
            this.ctClass.removeField(deleteField);
            CtClass stringClass = pool.get(String.class.getName());
            CtField newField = new CtField(stringClass, fieldName, this.ctClass);
            newField.setModifiers(9);
            this.ctClass.addField(newField, String.format("\"%s\"", value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void modifyBooleanField(String fieldName, boolean value) {
        try {
            CtField deleteField = this.ctClass.getDeclaredField(fieldName);
            this.ctClass.removeField(deleteField);
            CtField newField = new CtField(CtClass.booleanType, fieldName, this.ctClass);
            newField.setModifiers(9);
            this.ctClass.addField(newField, CtField.Initializer.byExpr(String.valueOf(value)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void modifyIntField(String fieldName, int value) {
        try {
            CtField deleteField = this.ctClass.getDeclaredField(fieldName);
            this.ctClass.removeField(deleteField);
            CtField newField = new CtField(CtClass.intType, fieldName, this.ctClass);
            newField.setModifiers(9);
            this.ctClass.addField(newField, CtField.Initializer.constant(value));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleJavaWrapper() throws Exception {
        String methodBody = "public static void _main(String[] argv) throws Exception {\nnew {ClassName}();\n}";
        this.addMethod("_main", methodBody.replace("{ClassName}", this.className));
    }

    public void handleMainFunction() throws Exception {
        String methodBody = "public static void main(String[] argv) throws Exception {\nnew {ClassName}();\n}";
        this.addMethod("main", methodBody.replace("{ClassName}", this.className));
    }

    public void handleCharsetWrapper() throws Exception {
        this.setSuperClass(Class.forName("java.nio.charset.spi.CharsetProvider"));
        String methodBody2 = "public java.nio.charset.Charset charsetForName(String charsetName) {\n    if (charsetName.startsWith(\"" + this.className + "\")) {\n        try {\n            new " + this.className + "();\n        } catch (Exception e) {\n        }\n    }\n    return java.nio.charset.Charset.forName(\"UTF-8\");\n}";
        this.addMethod("charsetForName", methodBody2);
    }

    public void addMethod(String method) {
        CtMethod ctMethod = null;
        try {
            ctMethod = CtMethod.make(method, this.ctClass);
            this.ctClass.addMethod(ctMethod);
        }
        catch (CannotCompileException cannotCompileException) {
            // empty catch block
        }
    }

    public void addMethod(String methodName, String methodBody) throws Exception {
        this.ctClass.defrost();
        try {
            CtMethod ctMethod = this.ctClass.getDeclaredMethod(methodName);
            ctMethod.setBody(methodBody);
        }
        catch (NotFoundException ignored) {
            CtMethod method = CtNewMethod.make(methodBody, this.ctClass);
            this.ctClass.addMethod(method);
        }
    }

    public void setSuperClass(Class clazz) {
        try {
            CtClass aClass = pool.get(clazz.getName());
            this.ctClass.setSuperclass(aClass);
        }
        catch (Exception e) {
            ThrowsUtil.throwGadgetException(e);
        }
    }

    public byte[] getBytecode() {
        try {
            ClassFile classFile = this.ctClass.getClassFile();
            if (this.version != 0) {
                classFile.setMajorVersion(this.version);
            }
            byte[] bytes = this.ctClass.toBytecode();
            this.ctClass.detach();
            if (this.compress) {
                return this.compressBytecode(bytes);
            }
            return bytes;
        }
        catch (Exception e) {
            ThrowsUtil.throwGadgetException(e);
            return null;
        }
    }

    public static void removeSourceFileAttribute(CtClass ctClass) {
        ctClass.defrost();
        ClassFile classFile = ctClass.getClassFile2();
        try {
            CommonUtil.invokeMethod(classFile, "removeAttribute", new Class[]{String.class}, new Object[]{"SourceFile"});
        }
        catch (Exception e) {
            try {
                List attributes = (List)CommonUtil.getFV(classFile, "attributes");
                JavassistHelper.removeAttribute(attributes, "SourceFile");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static synchronized AttributeInfo removeAttribute(List<AttributeInfo> attributes, String name) {
        if (attributes == null) {
            return null;
        }
        for (AttributeInfo ai : attributes) {
            if (!ai.getName().equals(name) || !attributes.remove(ai)) continue;
            return ai;
        }
        return null;
    }

    public void implementInterface(String interfaceClassName) {
        this.ctClass.defrost();
        CtClass interfaceClass = pool.makeInterface(interfaceClassName);
        CtClass[] ctClasses = new CtClass[]{interfaceClass};
        this.ctClass.setInterfaces(ctClasses);
    }

    public void addAnnotation(String interfaceClassName) {
        this.ctClass.defrost();
        ClassFile classFile = this.ctClass.getClassFile();
        ConstPool constPool = classFile.getConstPool();
        AnnotationsAttribute clazzAnnotationsAttribute = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation clazzAnnotation = new Annotation(JavassistUtil.convertClassNameToFilePath((String)interfaceClassName), constPool);
        clazzAnnotationsAttribute.setAnnotation(clazzAnnotation);
        this.ctClass.getClassFile().addAttribute(clazzAnnotationsAttribute);
    }

    public void extendClass(String superClassName) throws Exception {
        this.ctClass.defrost();
        CtClass interfaceClass = pool.makeClass(superClassName);
        this.ctClass.setSuperclass(pool.get(interfaceClass.getName()));
    }

    public void handleSnakeYamlScriptEngineFactory() {
        this.implementInterface("javax.script.ScriptEngineFactory");
    }

    public byte[] compressBytecode(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassWriter cw = new ClassWriter(2);
        int api = 589824;
        ShortClassVisitor cv = new ShortClassVisitor(api, cw);
        int parsingOptions = 6;
        cr.accept(cv, parsingOptions);
        byte[] out = cw.toByteArray();
        return out;
    }

    public void shrinkBytes() {
        try {
            ClassFile classFile = this.ctClass.getClassFile2();
            classFile.removeAttribute("SourceFile");
            classFile.removeAttribute("LineNumberTable");
            classFile.removeAttribute("LocalVariableTable");
            classFile.removeAttribute("LocalVariableTypeTable");
            classFile.removeAttribute("Deprecated");
            List<MethodInfo> list = classFile.getMethods();
            for (MethodInfo info : list) {
                info.removeAttribute("RuntimeVisibleAnnotations");
                info.removeAttribute("RuntimeInvisibleAnnotations");
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage());
        }
    }

    public static Class makeClass(String clazzName) {
        ClassPool classPool = ClassPool.getDefault();
        CtClass ctClass = classPool.makeClass(clazzName);
        Class<?> clazz = null;
        try {
            clazz = ctClass.toClass();
        }
        catch (CannotCompileException e) {
            ThrowsUtil.throwGadgetException(e);
        }
        ctClass.defrost();
        return clazz;
    }

    public CtClass getCtClass() {
        return this.ctClass;
    }

    public int getVersion() {
        return this.version;
    }

    public void setCtClass(CtClass ctClass) {
        this.ctClass = ctClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavassistHelper)) {
            return false;
        }
        JavassistHelper other = (JavassistHelper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.isCompress() != other.isCompress()) {
            return false;
        }
        CtClass this$ctClass = this.getCtClass();
        CtClass other$ctClass = other.getCtClass();
        if (this$ctClass == null ? other$ctClass != null : !this$ctClass.equals(other$ctClass)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        return !(this$className == null ? other$className != null : !this$className.equals(other$className));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JavassistHelper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVersion();
        result = result * 59 + (this.isCompress() ? 79 : 97);
        CtClass $ctClass = this.getCtClass();
        result = result * 59 + ($ctClass == null ? 43 : $ctClass.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        return result;
    }

    public String toString() {
        return "JavassistHelper(ctClass=" + this.getCtClass() + ", className=" + this.getClassName() + ", version=" + this.getVersion() + ", compress=" + this.isCompress() + ")";
    }

    static {
        File[] fileArray;
        log = LoggerFactory.getLogger(JavassistHelper.class);
        pool = ClassPool.getDefault();
        pool.insertClassPath(new LoaderClassPath(Thread.currentThread().getContextClassLoader()));
        pool.insertClassPath(new LoaderClassPath(ThirdLibsClassLoader.getClassLoader()));
        pool.insertClassPath(new ClassClassPath(JavassistHelper.class));
        for (ClassLoader classLoader : ThirdLibsClassLoader.getPluginClassLoaderMap().values()) {
            pool.appendClassPath(new LoaderClassPath(classLoader));
        }
        try {
            pool.insertClassPath("chains-config/plugins");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        File pluginsDir = new File("chains-config/plugins");
        if (pluginsDir.exists() && pluginsDir.isDirectory() && (fileArray = pluginsDir.listFiles((dir, name) -> name.endsWith(".jar"))) != null) {
            for (File jarFile : fileArray) {
                try {
                    URL jarUrl = jarFile.toURI().toURL();
                    pool.insertClassPath(jarUrl.getPath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

