/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.common.util;

import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.Payload;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.PayloadAnnotation;
import com.ar3h.chains.common.util.MessageSourceContext;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class MessageUtils {
    private static final Logger log = LoggerFactory.getLogger(MessageUtils.class);
    public static final Locale defaultLocale = Locale.CHINA;
    private static final String baseName = "messages";

    public static String getI18nPayloadName(Class<? extends Payload> clazz) {
        PayloadAnnotation annotation = clazz.getAnnotation(PayloadAnnotation.class);
        String payloadClassName = clazz.getSimpleName();
        return MessageUtils.getI18NString(payloadClassName + ".name", annotation.name());
    }

    public static String getI18nPayloadDesc(Class<? extends Gadget> clazz) {
        PayloadAnnotation annotation = clazz.getAnnotation(PayloadAnnotation.class);
        String payloadClassName = clazz.getSimpleName();
        return MessageUtils.getI18NString(payloadClassName + ".desc", annotation.description());
    }

    public static String getI18nGadgetName(Class<? extends Gadget> clazz) {
        GadgetAnnotation annotation = clazz.getAnnotation(GadgetAnnotation.class);
        String gadgetClassName = clazz.getSimpleName();
        return MessageUtils.getI18NString(gadgetClassName + ".name", annotation.name());
    }

    public static String getI18nGadgetDesc(Class<? extends Gadget> clazz) {
        GadgetAnnotation annotation = clazz.getAnnotation(GadgetAnnotation.class);
        String gadgetClassName = clazz.getSimpleName();
        return MessageUtils.getI18NString(gadgetClassName + ".desc", annotation.description());
    }

    public static String getI18nParamName(String className, String filedName, String defaultValue) {
        String string = MessageUtils.getI18NString(className + "." + filedName + ".name", "");
        if ("".equals(string)) {
            string = MessageUtils.getI18NString("common.param." + filedName + ".name", "");
        }
        if ("".equals(string)) {
            return defaultValue;
        }
        return string;
    }

    public static String getI18nParamDesc(String className, String filedName, String defaultValue) {
        String string = MessageUtils.getI18NString(className + "." + filedName + ".desc", "");
        if ("".equals(string)) {
            string = MessageUtils.getI18NString("common.param." + filedName + ".desc", "");
        }
        if ("".equals(string)) {
            return defaultValue;
        }
        return string;
    }

    public static String getI18nChoiceParam(String filedName, String choiceValue, String defaultValue) {
        String string = MessageUtils.getI18NString(filedName + "." + choiceValue, "");
        if ("".equals(string)) {
            return defaultValue;
        }
        return string;
    }

    public static String getI18nName(String className, String defaultValue) {
        return MessageUtils.getI18NString(className + ".name", defaultValue);
    }

    public static String getI18nDesc(String className, String defaultValue) {
        return MessageUtils.getI18NString(className + ".desc", defaultValue);
    }

    public static String getI18NString(String code) {
        String result = null;
        MessageSource messageSource = MessageSourceContext.get();
        if (messageSource != null) {
            result = messageSource.getMessage(code, null, "", MessageUtils.getLocale());
        } else {
            try {
                result = MessageUtils.getResourceBundle().getString(code);
            }
            catch (MissingResourceException e) {
                result = "";
            }
        }
        return result;
    }

    public static String getI18NStringWithArgs(String code, String ... args) {
        String result = null;
        MessageSource messageSource = MessageSourceContext.get();
        if (messageSource != null) {
            result = messageSource.getMessage(code, args, "", MessageUtils.getLocale());
        } else {
            try {
                result = String.format(MessageUtils.getResourceBundle().getString(code), args);
            }
            catch (MissingResourceException e) {
                result = "";
            }
        }
        return result;
    }

    public static String getI18NString(String code, String defaultValue) {
        String result = null;
        MessageSource messageSource = MessageSourceContext.get();
        if (messageSource != null) {
            result = messageSource.getMessage(code, null, defaultValue, MessageUtils.getLocale());
        } else {
            try {
                result = MessageUtils.getResourceBundle().getString(code);
            }
            catch (MissingResourceException e) {
                result = defaultValue;
            }
        }
        return result;
    }

    private static ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle(baseName, MessageUtils.getLocale(), new UTF8Control());
    }

    private static Locale getLocale() {
        Locale locale = LocaleContextHolder.getLocale();
        if (locale == null) {
            locale = defaultLocale;
        }
        return locale;
    }

    private static class UTF8Control
    extends ResourceBundle.Control {
        private UTF8Control() {
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            try (InputStreamReader reader = new InputStreamReader(loader.getResourceAsStream(resourceName), "UTF-8");){
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(reader);
                return propertyResourceBundle;
            }
        }
    }
}

