/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.common.util;

import com.ar3h.chains.common.exception.ThrowsUtil;
import com.ar3h.chains.common.util.ThirdLibsClassLoader;
import com.nqzero.permit.Permit;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sun.reflect.ReflectionFactory;

public class Reflections {
    public static void setAccessible(AccessibleObject member) {
        Permit.setAccessible(member);
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            Collections.addAll(fields, clazz.getDeclaredFields());
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Field field;
        block2: {
            field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
                Reflections.setAccessible(field);
            }
            catch (NoSuchFieldException ex) {
                if (clazz.getSuperclass() == null) break block2;
                field = Reflections.getField(clazz.getSuperclass(), fieldName);
            }
        }
        return field;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws Exception {
        Field field = Reflections.getField(obj.getClass(), fieldName);
        if (field != null) {
            field.set(obj, value);
        }
    }

    public static void setStaticFieldValue(Class<?> clazz, String fieldName, Object value) throws Exception {
        Field field = Reflections.getField(clazz, fieldName);
        if (field != null) {
            field.set(clazz, value);
        }
    }

    public static Object getFieldValue(Object obj, String fieldName) throws Exception {
        Field field = Reflections.getField(obj.getClass(), fieldName);
        return field.get(obj);
    }

    public static Constructor<?> getFirstCtor(String name) throws Exception {
        Constructor<?> ctor = ThirdLibsClassLoader.loadClass_(name).getDeclaredConstructors()[0];
        Reflections.setAccessible(ctor);
        return ctor;
    }

    public static Constructor<?> getConstructor(String classname, Class<?>[] paramTypes) throws ClassNotFoundException, NoSuchMethodException {
        Constructor<?> ctor = ThirdLibsClassLoader.loadClass_(classname).getDeclaredConstructor(paramTypes);
        Reflections.setAccessible(ctor);
        return ctor;
    }

    public static Object newInstance(String className, Object ... args) throws Exception {
        return Reflections.getFirstCtor(className).newInstance(args);
    }

    public static Object newInstance(String classname, Class<?>[] paramTypes, Object ... args) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return Reflections.getConstructor(classname, paramTypes).newInstance(args);
    }

    public static <T> T newInstance(Class<T> cls, Class<?>[] paramTypes, Object ... args) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor<T> ctor = cls.getDeclaredConstructor(paramTypes);
        Reflections.setAccessible(ctor);
        return ctor.newInstance(args);
    }

    public static <T> T createWithConstructor(Class<T> classToInstantiate, Class<? super T> constructorClass, Class<?>[] consArgTypes, Object[] consArgs) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<T> objCons = constructorClass.getDeclaredConstructor(consArgTypes);
        objCons.setAccessible(true);
        Constructor<?> sc = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(classToInstantiate, objCons);
        sc.setAccessible(true);
        return (T)sc.newInstance(consArgs);
    }

    public static Object createWithoutConstructor(String classname) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return Reflections.createWithoutConstructor(ThirdLibsClassLoader.loadClass_(classname));
    }

    public static <T> T createWithoutConstructor(Class<T> classToInstantiate) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return (T)Reflections.createWithConstructor(classToInstantiate, Object.class, new Class[0], new Object[0]);
    }

    public static <T> T set(T thisObj, String key, Object value) throws Exception {
        Reflections.setFieldValue(thisObj, key, value);
        return thisObj;
    }

    public static Object get(Object thisObj, String key) {
        try {
            Object obj = Reflections.getFieldValue(thisObj, key);
            return obj;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean has(Object thisObj, String key) {
        return Reflections.getField(thisObj.getClass(), key) != null;
    }

    public static Method getMethod(Object obj, String methodName, Class<?>[] paramTypes) {
        Class<?> clazz = obj.getClass();
        Method method = null;
        try {
            method = obj.getClass().getDeclaredMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            ThrowsUtil.throwGadgetException(e);
        }
        while (method == null && clazz != Object.class) {
            try {
                method = clazz.getDeclaredMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
        }
        if (method == null) {
            return null;
        }
        method.setAccessible(true);
        return method;
    }
}

