/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.common.util;

import java.io.InputStream;
import java.util.Map;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;

public class SafeYamlUtils {
    private SafeYamlUtils() {
    }

    private static Yaml createSafeYaml() {
        return new Yaml((BaseConstructor)new SafeConstructor());
    }

    public static <T> T parse(String yamlContent) {
        if (yamlContent == null || yamlContent.trim().isEmpty()) {
            return null;
        }
        try {
            return (T)SafeYamlUtils.createSafeYaml().load(yamlContent);
        }
        catch (YAMLException e) {
            throw new RuntimeException("Failed to parse YAML content", e);
        }
    }

    public static <T> T parse(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            return (T)SafeYamlUtils.createSafeYaml().load(inputStream);
        }
        catch (YAMLException e) {
            throw new RuntimeException("Failed to parse YAML stream", e);
        }
    }

    public static Map<String, Object> parseMap(String yamlContent) {
        return (Map)SafeYamlUtils.parse(yamlContent);
    }

    public static <T> T parseAs(String yamlContent, Class<T> rootClass) {
        if (yamlContent == null) {
            return null;
        }
        LoaderOptions options = new LoaderOptions();
        Constructor constructor = new Constructor(rootClass, options);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        return (T)yaml.load(yamlContent);
    }
}

