/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.common.util;

import com.ar3h.chains.common.Result;
import com.ar3h.chains.common.util.CustomTraversableResolver;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationUtil {
    private static final Logger log = LoggerFactory.getLogger(ValidationUtil.class);
    private static ValidatorFactory factory;
    private static Validator validator;

    public static Result validate(Object object) {
        if (validator == null) {
            return Result.success("validator is null");
        }
        Set violations = validator.validate(object, new Class[0]);
        if (violations.isEmpty()) {
            return Result.success();
        }
        StringBuilder message = new StringBuilder();
        for (ConstraintViolation violation : violations) {
            message.append(violation.getPropertyPath()).append(": ").append(violation.getMessage()).append("\n");
        }
        message.deleteCharAt(message.length() - 1);
        return Result.error(message.toString());
    }

    static {
        try {
            factory = Validation.byDefaultProvider().configure().traversableResolver((TraversableResolver)new CustomTraversableResolver()).buildValidatorFactory();
            validator = factory.getValidator();
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
    }
}

