/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.core;

import com.ar3h.chains.common.BuildResult;
import com.ar3h.chains.common.Constants;
import com.ar3h.chains.common.ContextTag;
import com.ar3h.chains.common.Engine;
import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.GadgetParam;
import com.ar3h.chains.common.Payload;
import com.ar3h.chains.common.Result;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.annotations.PayloadAnnotation;
import com.ar3h.chains.common.exception.GadgetException;
import com.ar3h.chains.common.exception.ThrowsUtil;
import com.ar3h.chains.common.param.Choice;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.param.ParamType;
import com.ar3h.chains.common.util.MessageUtils;
import com.ar3h.chains.common.util.Reflections;
import com.ar3h.chains.core.GadgetChainImpl;
import com.ar3h.chains.core.GadgetFactory;
import com.ar3h.chains.core.PayloadFactory;
import com.ar3h.chains.core.payload.PayloadParam;
import com.ar3h.chains.gadget.impl.mysql.proto.ColumnPacket;
import com.ar3h.chains.util.AnnotationProcessor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEngine<ObjectOut, ObjectIn>
implements Engine {
    private static final Logger log = LoggerFactory.getLogger(ExecutionEngine.class);
    private Payload<ObjectOut, ObjectIn> payload;
    private GadgetChainImpl chain = new GadgetChainImpl();
    private static final Map<Field, Boolean> ACCESSIBLE_CACHE = new ConcurrentHashMap<Field, Boolean>();
    private static final List<String> sensitiveKeywords = new ArrayList<String>();

    public ExecutionEngine(Payload<ObjectOut, ObjectIn> payload) {
        this.payload = payload;
    }

    public ExecutionEngine(Class<Payload<ObjectOut, ObjectIn>> payloadClazz) {
        try {
            this.payload = payloadClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new GadgetException("Failed to create payload instance: " + payloadClazz.getName(), e);
        }
    }

    public static ExecutionEngine create(Payload payload) {
        return new ExecutionEngine(payload);
    }

    public static ExecutionEngine create(Class<? extends Payload> payloadClass) {
        try {
            return ExecutionEngine.create(payloadClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new GadgetException("Failed to create payload instance: " + payloadClass.getName(), e);
        }
    }

    public static List<GadgetParam> getParamsFromGadget(String gadgetName) {
        Class gadget = GadgetFactory.getGadgetClass(gadgetName);
        if (gadget == null) {
            return Collections.emptyList();
        }
        ArrayList<GadgetParam> params = new ArrayList<GadgetParam>();
        for (Field field : Reflections.getAllFields(gadget)) {
            if (!field.isAnnotationPresent(Param.class)) continue;
            Object o = null;
            try {
                o = gadget.newInstance();
            }
            catch (InstantiationException e) {
                ThrowsUtil.throwGadgetException(e);
            }
            catch (IllegalAccessException e) {
                ThrowsUtil.throwGadgetException(e);
            }
            field.setAccessible(true);
            String key = gadget.getSimpleName() + "." + field.getName();
            log.debug("show param: {}", (Object)key);
            GadgetParam param = new GadgetParam();
            param.setName(MessageUtils.getI18nParamName(gadgetName, field.getName(), field.getAnnotation(Param.class).name()));
            param.setKey(key);
            param.setFieldName(field.getName());
            try {
                param.setValue(field.get(o));
            }
            catch (IllegalAccessException e) {
                ThrowsUtil.throwGadgetException(e);
            }
            param.setGadget(null);
            param.setDescription(MessageUtils.getI18nParamDesc(gadgetName, field.getName(), field.getAnnotation(Param.class).description()));
            param.setRequired(field.getAnnotation(Param.class).requires());
            param.setType(ExecutionEngine.getParamType(field, field.getAnnotation(Param.class)));
            param.setChoices(ExecutionEngine.convertChoiceToMap(field.getAnnotation(Param.class).choices(), field.getName()));
            params.add(param);
        }
        return params;
    }

    public static List<PayloadParam> getParamsFromPayload(String payloadName) {
        Class payload = PayloadFactory.getPayloadClass(payloadName);
        if (payload == null) {
            return Collections.emptyList();
        }
        ArrayList<PayloadParam> params = new ArrayList<PayloadParam>();
        for (Field field : Reflections.getAllFields(payload)) {
            if (!field.isAnnotationPresent(Param.class)) continue;
            Object o = null;
            try {
                o = payload.newInstance();
            }
            catch (InstantiationException e) {
                ThrowsUtil.throwGadgetException(e);
            }
            catch (IllegalAccessException e) {
                ThrowsUtil.throwGadgetException(e);
            }
            field.setAccessible(true);
            String key = o.getClass().getSimpleName() + "." + field.getName();
            log.debug(o.getClass() + " " + key);
            PayloadParam param = new PayloadParam();
            param.setName(MessageUtils.getI18nParamName(payloadName, field.getName(), field.getAnnotation(Param.class).name()));
            param.setKey(key);
            param.setFieldName(field.getName());
            try {
                param.setValue(field.get(o));
            }
            catch (IllegalAccessException e) {
                ThrowsUtil.throwGadgetException(e);
            }
            param.setPayload(null);
            param.setDescription(MessageUtils.getI18nParamDesc(payloadName, field.getName(), field.getAnnotation(Param.class).description()));
            param.setRequired(field.getAnnotation(Param.class).requires());
            param.setType(ExecutionEngine.getParamType(field, field.getAnnotation(Param.class)));
            param.setChoices(ExecutionEngine.convertChoiceToMap(field.getAnnotation(Param.class).choices(), field.getName()));
            params.add(param);
        }
        return params;
    }

    public static GadgetParam getParamFromGadgetClass(Class<?> gadgetClass) {
        GadgetParam param = new GadgetParam();
        for (Field field : Reflections.getAllFields(gadgetClass)) {
            if (!field.isAnnotationPresent(Param.class)) continue;
            field.setAccessible(true);
            String key = gadgetClass.getSimpleName() + "." + field.getName();
            log.debug(gadgetClass + " " + key);
            param.setName(field.getAnnotation(Param.class).name());
            param.setKey(key);
            param.setFieldName(field.getName());
            param.setGadget(null);
            param.setDescription(field.getAnnotation(Param.class).description());
            param.setRequired(field.getAnnotation(Param.class).requires());
            param.setType(ExecutionEngine.getParamType(field, field.getAnnotation(Param.class)));
            param.setChoices(ExecutionEngine.convertChoiceToMap(field.getAnnotation(Param.class).choices(), field.getName()));
        }
        return param;
    }

    public static Result validationNextTag(Class<?> gadgetClazz, String ... targetTags) {
        Result<?> tagsResult = ExecutionEngine.getGadgetCurrentTags(gadgetClazz);
        if (!tagsResult.isSuccess()) {
            return tagsResult;
        }
        String[] tags = (String[])tagsResult.getData();
        return ExecutionEngine.validationTag(gadgetClazz.getSimpleName(), tags, targetTags);
    }

    public static Result validationPreTags(Class<?> gadgetClazz, String ... targetTags) {
        Result<?> tagsResult = ExecutionEngine.getGadgetNextTags(gadgetClazz);
        if (!tagsResult.isSuccess()) {
            return tagsResult;
        }
        String[] tags = (String[])tagsResult.getData();
        return ExecutionEngine.validationTag(gadgetClazz.getSimpleName(), tags, targetTags);
    }

    public static Result validationTag(String gadgetName, String[] tags, String[] targetTags) {
        List<String> list = Arrays.asList(tags);
        Result result = new Result();
        for (String tag : targetTags) {
            if (list.contains(tag)) {
                return Result.success();
            }
            if (!gadgetName.equalsIgnoreCase(tag)) continue;
            return Result.success();
        }
        result.setMessage(result.getMessage() + gadgetName + " not contain '" + Arrays.toString(targetTags) + "' tag\n");
        return result.error();
    }

    private static Result<?> getGadgetCurrentTags(Class<?> gadgetClass) {
        Result<GadgetTags> result = ExecutionEngine.getGadgetTags(gadgetClass);
        if (!result.isSuccess()) {
            return result;
        }
        GadgetTags gadgetTags = result.getData();
        String[] tags = gadgetTags.tags();
        if (tags == null || tags.length == 0) {
            return Result.error(gadgetClass.getName() + " gadget tags is empty");
        }
        return Result.success(tags);
    }

    private static Result<?> getGadgetNextTags(Class<?> gadgetClass) {
        Result<GadgetTags> result = ExecutionEngine.getGadgetTags(gadgetClass);
        if (!result.isSuccess()) {
            return result;
        }
        GadgetTags gadgetTags = result.getData();
        String[] tags = gadgetTags.nextTags();
        if (tags == null || tags.length == 0) {
            return Result.error(gadgetClass.getName() + " gadget nextTags is empty");
        }
        return Result.success(tags);
    }

    public static Result getNextGadgets(String targetClass) {
        return ExecutionEngine.getNextGadgets(GadgetFactory.getGadgetMap().get(targetClass));
    }

    public static Result getNextGadgets(Class<?> targetClass) {
        List list = GadgetFactory.getGadgetMap().entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        HashSet<Class> gadgets = new HashSet<Class>();
        for (Class annotatedClass : list) {
            if (!ExecutionEngine.validationGadget(annotatedClass, targetClass).isSuccess()) continue;
            gadgets.add(annotatedClass);
        }
        return Result.success(gadgets);
    }

    private static Result<?> getGadgetPreTags(Class<?> gadgetClass) {
        Result<GadgetTags> result = ExecutionEngine.getGadgetTags(gadgetClass);
        if (!result.isSuccess()) {
            return result;
        }
        GadgetTags gadgetTags = result.getData();
        String[] tags = gadgetTags.preTags();
        if (tags == null || tags.length == 0) {
            return Result.error(gadgetClass.getName() + " gadget nextTags is empty");
        }
        return Result.success(tags);
    }

    public ExecutionEngine add(Gadget gadget) {
        this.chain.add(gadget);
        return this;
    }

    public ExecutionEngine add(Class gadgetClazz) {
        Gadget gadget;
        if (!Gadget.class.isAssignableFrom(gadgetClazz)) {
            throw new GadgetException(gadgetClazz.getSimpleName() + " is not a Gadget class");
        }
        try {
            gadget = (Gadget)gadgetClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new GadgetException("Failed to create gadget instance: " + gadgetClazz.getName(), e);
        }
        return this.add(gadget);
    }

    public ExecutionEngine add(String gadgetName) {
        return this.add(GadgetFactory.create(gadgetName));
    }

    public ExecutionEngine addAll(List<String> gadgetList) {
        for (String gadget : gadgetList) {
            this.add(gadget);
        }
        return this;
    }

    public ExecutionEngine setAll(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ExecutionEngine set(String key, Object value) {
        String[] split2 = key.split("\\.");
        String gadgetSimpleName = "";
        String paramFieldName = "";
        boolean isSingle = false;
        if (split2.length == 2) {
            gadgetSimpleName = split2[0];
            paramFieldName = split2[1];
            isSingle = false;
        } else if (split2.length == 1) {
            paramFieldName = key;
            isSingle = true;
        } else {
            ThrowsUtil.throwParamException("key format error: " + key);
        }
        if (!Objects.isNull(PayloadFactory.getPayloadMap().getOrDefault(gadgetSimpleName, null))) {
            this.setPayloadParam(paramFieldName, value);
            return this;
        }
        if (isSingle) {
            this.setGadgetParam(paramFieldName, value);
        } else {
            this.setGadgetParam(key, value, gadgetSimpleName, paramFieldName);
        }
        return this;
    }

    @Override
    public void setGadgetParam(String key, Object value, String gadgetSimpleName, String paramFieldName) {
        for (Gadget gadget : this.chain.getGadgetList()) {
            if (!gadgetSimpleName.isEmpty() && !gadget.getClass().getSimpleName().equals(gadgetSimpleName)) continue;
            for (Field field : Reflections.getAllFields(gadget.getClass())) {
                if (!field.isAnnotationPresent(Param.class) || !field.getName().equalsIgnoreCase(paramFieldName)) continue;
                log.debug("set param {}  {}={}", gadget.getClass().getSimpleName(), key, value);
                try {
                    this.setFieldValue(gadget, field, value);
                    return;
                }
                catch (Exception e) {
                    ThrowsUtil.throwParamException(e);
                }
            }
        }
        log.debug("gadgets not found field {}", (Object)paramFieldName);
    }

    @Override
    public void setGadgetParam(String fieldName, Object value) {
        if (this.setPayloadParam(fieldName, value)) {
            return;
        }
        for (Gadget gadget : this.chain.getGadgetList()) {
            for (Field field : Reflections.getAllFields(gadget.getClass())) {
                if (!field.isAnnotationPresent(Param.class) || !field.getName().equalsIgnoreCase(fieldName)) continue;
                log.debug("set param {}  {}={}", gadget.getClass().getSimpleName(), fieldName, value);
                try {
                    this.setFieldValue(gadget, field, value);
                    return;
                }
                catch (Exception e) {
                    ThrowsUtil.throwParamException(e);
                }
            }
        }
        log.debug("gadgets not found field {}", (Object)fieldName);
    }

    private boolean setPayloadParam(String fieldName, Object value) {
        for (Field field : Reflections.getAllFields(this.payload.getClass())) {
            if (!field.isAnnotationPresent(Param.class) || !field.getName().equalsIgnoreCase(fieldName)) continue;
            log.info("set payload param {}  {}={}", this.payload.getClass().getSimpleName(), fieldName, value);
            try {
                this.setFieldValue(this.payload, field, value);
                return true;
            }
            catch (Exception e) {
                ThrowsUtil.throwParamException(e);
            }
        }
        log.debug("not found Payload field {}", (Object)fieldName);
        return false;
    }

    public void setFieldValue(Object targetObject, Field field, Object value) {
        Boolean accessible = ACCESSIBLE_CACHE.get(field);
        field.setAccessible(true);
        if (accessible == null || !accessible.booleanValue()) {
            ACCESSIBLE_CACHE.put(field, true);
        }
        try {
            Class<?> fieldType = field.getType();
            if (value == null) {
                field.set(targetObject, null);
                return;
            }
            Param annotation = field.getAnnotation(Param.class);
            if (annotation.type() == ParamType.Choice) {
                Choice[] choices = annotation.choices();
                Map<String, String> choiceMap = ExecutionEngine.convertChoiceToMap(choices, field.getName());
                if (choices.length == 0) {
                    ThrowsUtil.throwParamException("choice is empty for field: " + field.getName());
                }
                if (!(value instanceof String)) {
                    ThrowsUtil.throwParamException("choice type must to be String type for field: " + field.getName() + ", actual type: " + value.getClass().getName());
                }
                if (choiceMap.getOrDefault((String)value, null) == null) {
                    ThrowsUtil.throwParamException("choice value error for field: " + field.getName() + ", value: " + value);
                }
            }
            if (fieldType.isAssignableFrom(value.getClass())) {
                field.set(targetObject, value);
                return;
            }
            if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                boolean booleanValue = false;
                if (value instanceof String) {
                    booleanValue = Boolean.parseBoolean((String)value);
                } else if (value instanceof Boolean) {
                    booleanValue = (Boolean)value;
                } else {
                    ThrowsUtil.throwParamException("Failed to convert value to boolean for field: " + field.getName());
                }
                field.set(targetObject, booleanValue);
            } else if (fieldType == Integer.TYPE || fieldType == Integer.class) {
                int intValue = 0;
                if (value instanceof String) {
                    try {
                        intValue = Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException e) {
                        ThrowsUtil.throwParamException("Failed to convert value to int for field: " + field.getName());
                    }
                } else if (value instanceof Integer) {
                    intValue = (Integer)value;
                } else {
                    ThrowsUtil.throwParamException("Failed to convert value to int for field: " + field.getName());
                }
                field.set(targetObject, intValue);
            } else if (fieldType == String.class) {
                field.set(targetObject, String.valueOf(value));
            } else {
                ThrowsUtil.throwParamException("Unsupported field type: " + fieldType.getName() + "for field: " + field.getName());
            }
        }
        catch (IllegalAccessException e) {
            ThrowsUtil.throwParamException("Failed to set value for field: " + field.getName() + ", error: " + e.getMessage());
        }
    }

    public List<PayloadParam> getAllPayloadParams() {
        ArrayList<PayloadParam> list = new ArrayList<PayloadParam>();
        for (Field field : Reflections.getAllFields(this.payload.getClass())) {
            if (!field.isAnnotationPresent(Param.class)) continue;
            try {
                String payloadName = this.payload.getClass().getSimpleName();
                String key = payloadName + "." + field.getName();
                field.setAccessible(true);
                Object value = field.get(this.payload);
                log.debug("<print> {} \t {}", (Object)this.payload.getClass().getSimpleName(), (Object)(field.getName() + "=" + value));
                PayloadParam param = new PayloadParam();
                param.setName(MessageUtils.getI18nParamName(payloadName, field.getName(), field.getAnnotation(Param.class).name()));
                param.setKey(key);
                param.setFieldName(field.getName());
                param.setValue(value);
                param.setPayload(this.getPayload());
                param.setDescription(MessageUtils.getI18nParamDesc(payloadName, field.getName(), field.getAnnotation(Param.class).description()));
                param.setRequired(field.getAnnotation(Param.class).requires());
                param.setType(ExecutionEngine.getParamType(field, field.getAnnotation(Param.class)));
                param.setChoices(ExecutionEngine.convertChoiceToMap(field.getAnnotation(Param.class).choices(), field.getName()));
                list.add(param);
            }
            catch (IllegalAccessException e) {
                throw new GadgetException("Failed to get payload field value: " + field.getName(), e);
            }
        }
        return list;
    }

    public List<GadgetParam> getAllGadgetParams() {
        ArrayList<GadgetParam> list = new ArrayList<GadgetParam>();
        for (Gadget gadget : this.chain.getGadgetList()) {
            for (Field field : Reflections.getAllFields(gadget.getClass())) {
                if (!field.isAnnotationPresent(Param.class)) continue;
                try {
                    String gadgetName = gadget.getClass().getSimpleName();
                    String key = gadgetName + "." + field.getName();
                    field.setAccessible(true);
                    Object value = field.get(gadget);
                    log.info("<check> {} \t {}", (Object)gadget.getClass().getSimpleName(), (Object)(field.getName() + "=" + this.truncateValue(value, 200)));
                    GadgetParam param = new GadgetParam();
                    param.setName(MessageUtils.getI18nParamName(gadgetName, field.getName(), field.getAnnotation(Param.class).name()));
                    param.setKey(key);
                    param.setFieldName(field.getName());
                    param.setValue(value);
                    param.setGadget(gadget);
                    param.setDescription(MessageUtils.getI18nParamDesc(gadgetName, field.getName(), field.getAnnotation(Param.class).description()));
                    param.setRequired(field.getAnnotation(Param.class).requires());
                    param.setType(ExecutionEngine.getParamType(field, field.getAnnotation(Param.class)));
                    param.setChoices(ExecutionEngine.convertChoiceToMap(field.getAnnotation(Param.class).choices(), field.getName()));
                    list.add(param);
                }
                catch (IllegalAccessException e) {
                    throw new GadgetException("Failed to get gadget field value: " + field.getName(), e);
                }
            }
        }
        return list;
    }

    private String truncateValue(Object value, int maxLength) {
        if (value == null) {
            return "null";
        }
        String valueStr = String.valueOf(value);
        if (valueStr.length() <= maxLength) {
            return valueStr;
        }
        return valueStr.substring(0, maxLength) + "......";
    }

    public static ParamType getParamType(Field field, Param annotation) {
        ParamType type = annotation.type();
        Class<?> fieldType = field.getType();
        if (type == ParamType.Choice) {
            return ParamType.Choice;
        }
        if (fieldType == Integer.class || fieldType == Integer.TYPE) {
            return ParamType.Integer;
        }
        if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
            return ParamType.Boolean;
        }
        return type;
    }

    public Result checkNullParams() {
        String message;
        Object value;
        Result result = new Result();
        List<PayloadParam> payloadParams = this.getAllPayloadParams();
        List<GadgetParam> gadgetParams = this.getAllGadgetParams();
        boolean errorFlag = false;
        for (PayloadParam payloadParam : payloadParams) {
            if (!payloadParam.isRequired() || !Objects.isNull(value = payloadParam.getValue()) && (!String.class.isAssignableFrom(value.getClass()) || !"".equals(value))) continue;
            errorFlag = true;
            message = payloadParam.getPayload().getClass().getSimpleName() + ": '" + payloadParam.getFieldName() + "' param is null, plz input !";
            log.debug(message);
            if (result.getMessage() == "") {
                result.setMessage(message);
                continue;
            }
            result.setMessage(result.getMessage() + "\n" + message);
        }
        for (GadgetParam gadgetParam : gadgetParams) {
            if (!gadgetParam.isRequired() || !Objects.isNull(value = gadgetParam.getValue()) && (!String.class.isAssignableFrom(value.getClass()) || !"".equals(value))) continue;
            errorFlag = true;
            message = gadgetParam.getGadget().getClass().getSimpleName() + ": '" + gadgetParam.getFieldName() + "' param is null, plz input !";
            log.debug(message);
            if (result.getMessage() == "") {
                result.setMessage(message);
                continue;
            }
            result.setMessage(result.getMessage() + "\n" + message);
        }
        if (errorFlag) {
            return result;
        }
        return Result.success();
    }

    private static Result validationExpress(Class<?> newGadgetClass, Class<? extends Gadget> lastGadgetClass) {
        try {
            if (AnnotationProcessor.evaluateExpression(lastGadgetClass, newGadgetClass)) {
                return Result.success();
            }
        }
        catch (Exception e) {
            return Result.error(e.getMessage());
        }
        return Result.error("gadget " + newGadgetClass.getName() + " is not valid");
    }

    public BuildResult<ObjectOut> build() {
        return this.build(new GadgetContext());
    }

    public BuildResult<ObjectOut> build(GadgetContext context) {
        long startTime = System.currentTimeMillis();
        Result result = this.checkNullParams();
        if (!result.isSuccess()) {
            ThrowsUtil.throwParamException(result.getMessage());
        }
        this.validationChains();
        Object objectIn = null;
        context.setEngine(this);
        context.setPayload(this.payload);
        context.setChain(this.chain);
        context.setGadgetList(this.chain.getGadgetList());
        try {
            objectIn = this.chain.doCreate(context);
        }
        catch (Exception e) {
            throw new GadgetException("Gadget chain creation failed: " + e.getMessage(), e);
        }
        byte[] objectOut = null;
        try {
            objectOut = (byte[])this.payload.marshal(objectIn);
        }
        catch (Exception e) {
            log.warn("Serialization failed: {}", (Object)e.getMessage());
            ThrowsUtil.throwGadgetException(e);
        }
        if (objectOut instanceof byte[]) {
            byte[] b = objectOut;
            String string = context.getString(ContextTag.SUID_REPLACE);
            if (string != null && !string.trim().isEmpty()) {
                String[] entries;
                for (String entry : entries = string.split(";")) {
                    if (entry == null || entry.trim().isEmpty() || entry.trim().equals("null") || (entry = entry.trim()).isEmpty()) continue;
                    String[] kv = entry.split("\\|", 2);
                    if (kv.length != 2) {
                        log.warn("Invalid SUID_REPLACE kv: {}", (Object)entry);
                        continue;
                    }
                    String target = kv[0].trim();
                    String replacement = kv[1].trim();
                    if (target.isEmpty() || replacement.isEmpty()) {
                        log.warn("Invalid SUID_REPLACE kv: {}", (Object)entry);
                        continue;
                    }
                    try {
                        byte[] targetBytes = ExecutionEngine.parseReplaceValue(target);
                        byte[] replacementBytes = ExecutionEngine.parseReplaceValue(replacement);
                        if (targetBytes == null || replacementBytes == null) {
                            log.warn("Invalid replace value: {}", (Object)entry);
                            continue;
                        }
                        int count = ExecutionEngine.countOccurrences(b, targetBytes);
                        if (count > 0) {
                            b = ExecutionEngine.replaceBytes(b, targetBytes, replacementBytes);
                        }
                        log.info("suid replace: {} -> {} ({})", target, replacement, count);
                    }
                    catch (Exception e) {
                        log.warn("Serialization replace failed: {}", (Object)e.getMessage());
                    }
                }
                objectOut = b;
            }
            log.debug("{} Payload Size: {}", (Object)this.payload.getClass().getSimpleName(), (Object)b.length);
            context.put("Result byte[] Size", b.length + " Bytes");
            if (b.length < 0x6400000) {
                context.put("Result byte[] MD5 Digest", DigestUtils.md5Hex(b));
            }
        }
        long endTime = System.currentTimeMillis();
        context.put("Time", String.format("%s - %s = %s millisecond", endTime, startTime, endTime - startTime));
        return BuildResult.success(objectOut);
    }

    public ObjectOut marshal(ObjectIn objectIn) throws Exception {
        return this.payload.marshal(objectIn);
    }

    public ObjectIn unmarshal(ObjectOut objectOut) throws Exception {
        return this.payload.unmarshal(objectOut);
    }

    public static byte[] replaceBytes(byte[] src, byte[] target, byte[] replacement) throws IOException {
        if (src == null || target == null || replacement == null) {
            return src;
        }
        if (target.length == 0) {
            return src;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(src.length);
        int i = 0;
        int n = src.length;
        int m = target.length;
        while (i <= n - m) {
            boolean match = true;
            for (int j = 0; j < m; ++j) {
                if (src[i + j] == target[j]) continue;
                match = false;
                break;
            }
            if (match) {
                out.write(replacement);
                i += m;
                continue;
            }
            out.write(src[i]);
            ++i;
        }
        if (i < n) {
            out.write(src, i, n - i);
        }
        return out.toByteArray();
    }

    private static byte[] parseReplaceValue(String v) {
        String hex;
        String s;
        String string = s = v == null ? null : v.trim();
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (!s.startsWith("0x") && !s.startsWith("0X")) {
            s = String.format("0x%016x", Long.parseLong(s));
        }
        if ((hex = s.substring(2)).isEmpty()) {
            return null;
        }
        if (hex.length() % 2 != 0) {
            return null;
        }
        if (!hex.matches("[0-9a-fA-F]+")) {
            return null;
        }
        return ColumnPacket.hexToBytes(hex);
    }

    private static int countOccurrences(byte[] src, byte[] target) {
        if (src == null || target == null || target.length == 0) {
            return 0;
        }
        int i = 0;
        int n = src.length;
        int m = target.length;
        int count = 0;
        while (i <= n - m) {
            boolean match = true;
            for (int j = 0; j < m; ++j) {
                if (src[i + j] == target[j]) continue;
                match = false;
                break;
            }
            if (match) {
                ++count;
                i += m;
                continue;
            }
            ++i;
        }
        return count;
    }

    public void validationChains() {
        List<Gadget> gadgetList = this.chain.getGadgetList();
        if (gadgetList.size() == 0) {
            throw new GadgetException("gadgets is empty");
        }
        Class<?> startGadget = gadgetList.get(0).getClass();
        String[] payloadStartTag = this.payload.getClass().getAnnotation(PayloadAnnotation.class).gadgetTags();
        ExecutionEngine.validationTag(startGadget, payloadStartTag);
        Class<?> lastGadget = gadgetList.get(gadgetList.size() - 1).getClass();
        ExecutionEngine.validationTag(lastGadget, "END");
    }

    public static void validationTag(Class<?> gadgetClazz, String ... targetTags) {
        Result<?> tagsResult = ExecutionEngine.getGadgetCurrentTags(gadgetClazz);
        String[] tags = (String[])tagsResult.getData();
        List<String> tagList = Arrays.asList(tags);
        for (String tag : targetTags) {
            if (tagList.contains(tag)) {
                return;
            }
            if (!gadgetClazz.getSimpleName().equalsIgnoreCase(tag)) continue;
            return;
        }
        String message = gadgetClazz.getSimpleName() + " not contain '" + Arrays.toString(targetTags) + "' tag\n";
        throw new GadgetException(message);
    }

    public static Result validationGadget(Class<?> newGadgetClass, Class<?> lastGadgetClass) {
        String[] preTags;
        Result validatePreTagResult;
        String[] tags;
        Result validateNextTagResult;
        String expression = lastGadgetClass.getAnnotation(GadgetTags.class).expression();
        if (expression != null && !expression.isEmpty()) {
            return ExecutionEngine.validationExpress(newGadgetClass, lastGadgetClass);
        }
        Result<?> result = ExecutionEngine.getGadgetNextTags(lastGadgetClass);
        if (result.isSuccess() && (validateNextTagResult = ExecutionEngine.validationNextTag(newGadgetClass, tags = (String[])result.getData())).isSuccess()) {
            return validateNextTagResult;
        }
        result = ExecutionEngine.getGadgetPreTags(newGadgetClass);
        if (result.isSuccess() && (validatePreTagResult = ExecutionEngine.validationPreTags(lastGadgetClass, preTags = (String[])result.getData())).isSuccess()) {
            return validatePreTagResult;
        }
        return Result.error("gadget " + newGadgetClass.getName() + " is not valid");
    }

    private static Result<GadgetTags> getGadgetTags(Class<?> gadgetClass) {
        if (!Gadget.class.isAssignableFrom(gadgetClass)) {
            throw new GadgetException(gadgetClass.getName() + " class is not a gadget class");
        }
        GadgetTags gadgetTags = gadgetClass.getAnnotation(GadgetTags.class);
        if (gadgetTags == null) {
            throw new GadgetException(gadgetClass.getName() + " GadgetTags is null");
        }
        return Result.success(gadgetTags);
    }

    public static Map<String, String> convertChoiceToMap(Choice[] choices, String choiceParamName) {
        if (choices == null || choices.length == 0) {
            return new HashMap<String, String>();
        }
        return Arrays.stream(choices).collect(Collectors.toMap(Choice::value, choice -> {
            String label = choice.label();
            String value = choice.value();
            String i18nLabel = MessageUtils.getI18nChoiceParam(choiceParamName, value, null);
            if (i18nLabel != null) {
                return i18nLabel;
            }
            if (label == null || label.isEmpty()) {
                return value;
            }
            return label;
        }, (oldValue, newValue) -> newValue, HashMap::new));
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public GadgetChainImpl getChain() {
        return this.chain;
    }

    public void setChain(GadgetChainImpl chain) {
        this.chain = chain;
    }

    static {
        sensitiveKeywords.add(Constants.PACKAGE_NAME);
    }
}

