/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.core;

import com.ar3h.chains.common.Constants;
import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.Payload;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.PayloadAnnotation;
import com.ar3h.chains.common.util.ThirdLibsClassLoader;
import com.ar3h.chains.core.GadgetFactory;
import com.ar3h.chains.core.PayloadFactory;
import groovy.lang.GroovyClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLoader {
    private static final Logger log = LoggerFactory.getLogger(PluginLoader.class);
    private static boolean initialized = false;
    public static final String pluginDir = "chains-config/plugins";
    public static List<byte[]> innerClassList = new ArrayList<byte[]>();

    public static synchronized void initPlugin() {
        if (initialized) {
            return;
        }
        PluginLoader.loadPlugins(pluginDir);
        PluginLoader.handleInnerClass();
        initialized = true;
    }

    public static void reload() {
        innerClassList = new ArrayList<byte[]>();
        initialized = false;
        PluginLoader.initPlugin();
    }

    private static void loadClassesFromJar(File file, Set<Class<?>> loadedClasses) throws Exception {
        JarFile jarFile = new JarFile(file);
        String name = jarFile.getName();
        ThirdLibsClassLoader jarClassLoader = new ThirdLibsClassLoader(new URL[]{file.toURI().toURL()}, (ClassLoader)ThirdLibsClassLoader.getInstance());
        Map<String, URLClassLoader> map = ThirdLibsClassLoader.getPluginClassLoaderMap();
        if (map.get(name) != null) {
            log.warn("'{}' plugin already load", (Object)name);
            return;
        }
        map.put(name, jarClassLoader);
        PluginLoader.scanClassByJar(file, Constants.PACKAGE_NAME, loadedClasses, jarClassLoader);
    }

    /*
     * Exception decompiling
     */
    private static byte[] loadClassBytesFromJarEntry(JarFile jar, JarEntry entry) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> clz = ThirdLibsClassLoader.getClassLoader().loadClass(className);
        if (clz != null) {
            PluginLoader.initializeClass(clz);
        }
        return clz;
    }

    private static void initializeClass(Class<?> clazz) throws ClassNotFoundException {
        try {
            if (Gadget.class.isAssignableFrom(clazz) && clazz.getAnnotation(Deprecated.class) == null) {
                GadgetFactory.registry(clazz);
            }
            if (Payload.class.isAssignableFrom(clazz) && clazz.getAnnotation(Deprecated.class) == null) {
                PayloadFactory.registry(clazz);
            }
            log.debug("Loaded and initialized plugin: {}", (Object)clazz.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadClassFromClassFile(File classFile, Set<Class<?>> classes) throws Exception {
        byte[] classBytes = Files.readAllBytes(classFile.toPath());
        PluginLoader.loadClassFromClassFile(classFile.getName(), classBytes, classes);
    }

    public static void loadClassFromClassFile(String className, byte[] classBytes, Set<Class<?>> classes) throws Exception {
        if (className.contains("$")) {
            innerClassList.add(classBytes);
            return;
        }
        Class<?> clz = PluginLoader.tryDefineClass(classBytes);
        if (clz != null && clz.getName().startsWith("com.ar3h.chains")) {
            classes.add(clz);
            PluginLoader.initializeClass(clz);
        }
    }

    public static Class<?> tryDefineClass(byte[] classBytes) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Class<?> mainClass = null;
        URLClassLoader commonClassLoader = ThirdLibsClassLoader.getClassLoader();
        try {
            mainClass = PluginLoader.defineClass(commonClassLoader, classBytes);
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
        if (mainClass == null) {
            Collection<URLClassLoader> classLoaders = ThirdLibsClassLoader.getPluginClassLoaderMap().values();
            for (URLClassLoader classLoader : classLoaders) {
                try {
                    mainClass = PluginLoader.defineClass(classLoader, classBytes);
                }
                catch (Exception e) {
                    log.debug(e.getMessage());
                }
                if (mainClass == null) continue;
                break;
            }
        }
        if (mainClass != null) {
            ClassLoader classLoader = PluginLoader.getGadgetThirdLibClassLoader(mainClass);
            if (classLoader != null) {
                mainClass = PluginLoader.defineClass(classLoader, classBytes);
            }
            if ((classLoader = PluginLoader.getPayloadThirdLibClassLoader(mainClass)) != null) {
                mainClass = PluginLoader.defineClass(classLoader, classBytes);
            }
        }
        return mainClass;
    }

    public static Class tryLoadClass(String className) {
        Class<?> aClass = null;
        if (className != null) {
            Collection<URLClassLoader> classLoaders = ThirdLibsClassLoader.getPluginClassLoaderMap().values();
            for (URLClassLoader classLoader : classLoaders) {
                try {
                    aClass = classLoader.loadClass(className);
                }
                catch (Exception e) {
                    log.debug(e.getMessage());
                }
                if (aClass == null) continue;
                break;
            }
        }
        return aClass;
    }

    public static ClassLoader getPayloadThirdLibClassLoader(Class<?> clazz) {
        try {
            URLClassLoader classLoader;
            String thirdLib;
            PayloadAnnotation annotation = clazz.getAnnotation(PayloadAnnotation.class);
            if (annotation != null && !(thirdLib = annotation.thirdLib()).isEmpty() && (classLoader = ThirdLibsClassLoader.getClassLoaderForDirectory(thirdLib)) != null) {
                log.info("use '{}' classLoader to load '{}'", (Object)thirdLib, (Object)clazz.getSimpleName());
                return classLoader;
            }
        }
        catch (Exception e) {
            log.debug(e.getMessage(), e);
        }
        return null;
    }

    public static ClassLoader getGadgetThirdLibClassLoader(Class<?> clazz) {
        try {
            URLClassLoader classLoader;
            String thirdLib;
            GadgetAnnotation annotation = clazz.getAnnotation(GadgetAnnotation.class);
            if (annotation != null && !(thirdLib = annotation.thirdLib()).isEmpty() && (classLoader = ThirdLibsClassLoader.getClassLoaderForDirectory(thirdLib)) != null) {
                log.info("use '{}' classLoader to load '{}'", (Object)thirdLib, (Object)clazz.getSimpleName());
                return classLoader;
            }
        }
        catch (Exception e) {
            log.debug(e.getMessage(), e);
        }
        return null;
    }

    public static Class<?> defineClass(ClassLoader classLoader, byte[] classBytes) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class aClass = null;
        try {
            Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", byte[].class, Integer.TYPE, Integer.TYPE);
            defineClass.setAccessible(true);
            aClass = (Class)defineClass.invoke((Object)classLoader, classBytes, 0, classBytes.length);
        }
        catch (InvocationTargetException e) {
            log.debug(e.getMessage());
        }
        return aClass;
    }

    public static void loadPlugins(String pluginDir) {
        File dir = new File(pluginDir);
        if (!dir.exists() || !dir.isDirectory()) {
            log.info("Plugins directory does not exist or is not a directory.");
            return;
        }
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        PluginLoader.collectFiles(dir, files);
        if (files.isEmpty()) {
            log.info("No jar or class files found in the plugins directory.");
            return;
        }
        try {
            for (File file : files) {
                urls.add(file.toURI().toURL());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load plugin URLs", e);
        }
        LinkedHashSet loadedClasses = new LinkedHashSet();
        String name = null;
        try {
            for (File file : files) {
                name = file.getName();
                if (name.startsWith("_")) {
                    log.info("Skip plugin file {}", (Object)name);
                    continue;
                }
                if (name.endsWith(".jar")) {
                    try {
                        PluginLoader.loadClassesFromJar(file, loadedClasses);
                    }
                    catch (IOException e) {
                        log.error("Failed to load classes from JAR file: {}", (Object)name, (Object)e);
                    }
                    continue;
                }
                if (name.endsWith(".class")) {
                    PluginLoader.loadClassFromClassFile(file, loadedClasses);
                    continue;
                }
                if (name.endsWith(".groovy")) {
                    PluginLoader.loadClassFromGroovy(file, loadedClasses);
                    continue;
                }
                if (!name.endsWith(".java")) continue;
                PluginLoader.loadClassFromJava(file, loadedClasses);
            }
        }
        catch (Exception e) {
            log.error("Failed to load class from file: {}", (Object)name, (Object)e);
        }
    }

    private static void handleInnerClass() {
        try {
            for (byte[] bytes : innerClassList) {
                Class<?> innerClazz = PluginLoader.tryDefineClass(bytes);
                if (innerClazz == null) continue;
                String innerClassName = innerClazz.getName();
                String mainClassName = innerClassName.substring(0, innerClassName.lastIndexOf(36));
                Class mainClazz = PluginLoader.tryLoadClass(mainClassName);
                if (mainClazz == null) {
                    log.error("can't found main class from '{}'", (Object)innerClassName);
                    return;
                }
                ClassLoader loader = mainClazz.getClassLoader();
                PluginLoader.defineClass(loader, bytes);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    private static void collectFiles(File dir, Set<File> files) {
        File[] listFiles = dir.listFiles();
        if (listFiles != null) {
            for (File file : listFiles) {
                if (file.isDirectory()) {
                    PluginLoader.collectFiles(file, files);
                    continue;
                }
                if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".class") && !file.getName().endsWith(".groovy") && !file.getName().endsWith(".java")) continue;
                files.add(file);
            }
        }
    }

    public static void loadClassFromJava(File javaFile, Set<Class<?>> classes) throws Exception {
        String className = PluginLoader.getClassName(javaFile);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new IllegalStateException("No Java compiler available");
        }
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjects(javaFile);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, null, null, compilationUnits);
        boolean success = task.call();
        if (!success) {
            throw new RuntimeException("Compilation failed.");
        }
        fileManager.close();
        File parentDir = javaFile.getParentFile();
        URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{parentDir.toURI().toURL()});
        Class<?> loadedClass = classLoader.loadClass(className);
        classes.add(loadedClass);
    }

    private static String getClassName(File javaFile) throws IOException {
        String packageName = "";
        String className = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(javaFile));){
            String line;
            Pattern packagePattern = Pattern.compile("^\\s*package\\s+([\\w\\.]+)\\s*;");
            Pattern classPattern = Pattern.compile("^\\s*(public\\s+)?class\\s+(\\w+)");
            while ((line = reader.readLine()) != null) {
                Matcher classMatcher;
                Matcher packageMatcher = packagePattern.matcher(line);
                if (packageMatcher.find()) {
                    packageName = packageMatcher.group(1);
                }
                if (!(classMatcher = classPattern.matcher(line)).find()) continue;
                className = classMatcher.group(2);
                break;
            }
        }
        if (className == null) {
            throw new IllegalArgumentException("No class found in file: " + javaFile.getName());
        }
        if (!packageName.isEmpty()) {
            className = packageName + "." + className;
        }
        return className;
    }

    private static void loadClassFromGroovy(File groovyFile, Set<Class<?>> classes) throws Exception {
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader((ClassLoader)ThirdLibsClassLoader.getClassLoader());
        Class clz = groovyClassLoader.parseClass(groovyFile);
        if (clz != null) {
            classes.add(clz);
            PluginLoader.initializeClass(clz);
        }
    }

    private static int scanClassByJar(File srcJarFile, String packageName, Set<Class<?>> destList, ClassLoader classLoader) throws Exception {
        int addNum = 0;
        try {
            JarFile jarFile = new JarFile(srcJarFile);
            Enumeration<JarEntry> jarFiles = jarFile.entries();
            packageName = packageName.replace(".", "/");
            while (jarFiles.hasMoreElements()) {
                JarEntry jarEntry = jarFiles.nextElement();
                String name = jarEntry.getName();
                if (!name.startsWith(packageName) || !name.endsWith(".class")) continue;
                name = name.replace("/", ".");
                name = name.substring(0, name.length() - 6);
                try {
                    String objectClassName = name;
                    Class<?> objectClass = Class.forName(objectClassName, true, classLoader);
                    if (Gadget.class.isAssignableFrom(objectClass) && objectClass.isAnnotationPresent(GadgetAnnotation.class)) {
                        destList.add(objectClass);
                        PluginLoader.initializeClass(objectClass);
                        ++addNum;
                        continue;
                    }
                    if (!Payload.class.isAssignableFrom(objectClass) || !objectClass.isAnnotationPresent(PayloadAnnotation.class)) continue;
                    destList.add(objectClass);
                    PluginLoader.initializeClass(objectClass);
                    ++addNum;
                }
                catch (Exception var14) {
                    Exception e = var14;
                    log.error(e.getMessage());
                }
            }
            jarFile.close();
        }
        catch (Exception var15) {
            Exception e = var15;
            log.error(e.getMessage());
        }
        return addNum;
    }
}

