/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.core.payload.enhance;

import com.ar3h.chains.common.util.CommonUtil;
import com.ar3h.chains.common.util.JavassistHelper;
import com.ar3h.chains.core.payload.enhance.RandomString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirtyDataWrapper {
    private static final Logger log = LoggerFactory.getLogger(DirtyDataWrapper.class);
    private int dirtyCollectionSize;
    private int dirtyClassSize;
    private Object wrapper;

    public DirtyDataWrapper(Object object) {
        this.wrapper = object;
    }

    public static DirtyDataWrapper builder(Object object) {
        return new DirtyDataWrapper(object);
    }

    public DirtyDataWrapper withDirtyCollectionSize(int dirtyCollectionSize) {
        this.dirtyCollectionSize = dirtyCollectionSize;
        return this;
    }

    public DirtyDataWrapper withDirtyClassSize(int dirtyClassSize) {
        this.dirtyClassSize = dirtyClassSize;
        return this;
    }

    public Object build() {
        this.wrapper = this.collectionWrap(this.wrapper);
        this.wrapper = this.classWrap(this.wrapper);
        return this.wrapper;
    }

    public Object collectionWrap(Object object) {
        if (this.dirtyCollectionSize <= 0) {
            return object;
        }
        log.info("Random collection dirty data size: {}", (Object)this.dirtyCollectionSize);
        String dirtyData = RandomString.getDirtyString(this.dirtyCollectionSize);
        String key1 = RandomString.getDirtyString(this.dirtyCollectionSize);
        String key2 = RandomString.getDirtyString(this.dirtyCollectionSize);
        int type = (int)(Math.random() * 10.0) % 10 + 1;
        Cloneable wrapper = null;
        switch (type) {
            case 0: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(dirtyData);
                arrayList.add(object);
                wrapper = arrayList;
                break;
            }
            case 1: {
                LinkedList<Object> linkedList = new LinkedList<Object>();
                linkedList.add(dirtyData);
                linkedList.add(object);
                wrapper = linkedList;
                break;
            }
            case 2: {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(key1, dirtyData);
                map.put(key2, object);
                wrapper = map;
                break;
            }
            case 3: {
                LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
                linkedHashMap.put(key1, dirtyData);
                linkedHashMap.put(key2, object);
                wrapper = linkedHashMap;
                break;
            }
            default: {
                TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
                treeMap.put(key1, dirtyData);
                treeMap.put(key2, object);
                wrapper = treeMap;
            }
        }
        return wrapper;
    }

    public Object classWrap(Object object) {
        if (this.dirtyClassSize <= 0) {
            return object;
        }
        log.info("LinkedList dirty data size: {}", (Object)this.dirtyCollectionSize);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; i < this.dirtyClassSize; ++i) {
            linkedList.add(JavassistHelper.makeClass(CommonUtil.getRandomString(10)));
        }
        linkedList.add(object);
        return linkedList;
    }

    public int getDirtyCollectionSize() {
        return this.dirtyCollectionSize;
    }

    public int getDirtyClassSize() {
        return this.dirtyClassSize;
    }

    public Object getWrapper() {
        return this.wrapper;
    }

    public void setDirtyCollectionSize(int dirtyCollectionSize) {
        this.dirtyCollectionSize = dirtyCollectionSize;
    }

    public void setDirtyClassSize(int dirtyClassSize) {
        this.dirtyClassSize = dirtyClassSize;
    }

    public void setWrapper(Object wrapper) {
        this.wrapper = wrapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DirtyDataWrapper)) {
            return false;
        }
        DirtyDataWrapper other = (DirtyDataWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDirtyCollectionSize() != other.getDirtyCollectionSize()) {
            return false;
        }
        if (this.getDirtyClassSize() != other.getDirtyClassSize()) {
            return false;
        }
        Object this$wrapper = this.getWrapper();
        Object other$wrapper = other.getWrapper();
        return !(this$wrapper == null ? other$wrapper != null : !this$wrapper.equals(other$wrapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DirtyDataWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDirtyCollectionSize();
        result = result * 59 + this.getDirtyClassSize();
        Object $wrapper = this.getWrapper();
        result = result * 59 + ($wrapper == null ? 43 : $wrapper.hashCode());
        return result;
    }

    public String toString() {
        return "DirtyDataWrapper(dirtyCollectionSize=" + this.getDirtyCollectionSize() + ", dirtyClassSize=" + this.getDirtyClassSize() + ", wrapper=" + this.getWrapper() + ")";
    }
}

