/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.mysql.proto;

import com.ar3h.chains.gadget.impl.mysql.proto.utils.LenUtil;
import java.util.ArrayList;
import java.util.List;

public class ColumnPacket {
    public static byte[] buildColumnValuesPacket(byte[][] values) {
        ArrayList<Byte> finalValues = new ArrayList<Byte>();
        for (byte[] value : values) {
            byte[] encodedValue = ColumnPacket.strEncode(value);
            finalValues.addAll(ColumnPacket.bytesToList(encodedValue));
        }
        return ColumnPacket.listToBytes(finalValues);
    }

    public static byte[] buildColumnPacket(String column) {
        byte[] def = ColumnPacket.strEncode("def".getBytes());
        ArrayList<Byte> packet = new ArrayList<Byte>(ColumnPacket.bytesToList(def));
        packet.add((byte)0);
        byte[] table = ColumnPacket.strEncode("a".getBytes());
        packet.addAll(ColumnPacket.bytesToList(table));
        byte[] orgTable = ColumnPacket.strEncode("a".getBytes());
        packet.addAll(ColumnPacket.bytesToList(orgTable));
        byte[] name = ColumnPacket.strEncode(column.getBytes());
        packet.addAll(ColumnPacket.bytesToList(name));
        packet.addAll(ColumnPacket.bytesToList(name));
        packet.add((byte)12);
        packet.add((byte)63);
        packet.add((byte)0);
        packet.add((byte)28);
        packet.add((byte)0);
        packet.add((byte)0);
        packet.add((byte)0);
        packet.add((byte)-4);
        packet.add((byte)-1);
        packet.add((byte)-1);
        packet.add((byte)0);
        packet.add((byte)0);
        packet.add((byte)0);
        return ColumnPacket.listToBytes(packet);
    }

    public static byte[] strEncode(byte[] d) {
        byte[] l = LenUtil.write(d.length);
        String packetHex = ColumnPacket.bytesToHex(l) + ColumnPacket.bytesToHex(d);
        return ColumnPacket.hexToBytes(packetHex);
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    public static byte[] hexToBytes(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    public static List<Byte> bytesToList(byte[] bytes) {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (byte b : bytes) {
            list.add(b);
        }
        return list;
    }

    public static byte[] listToBytes(List<Byte> list) {
        byte[] bytes = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            bytes[i] = list.get(i);
        }
        return bytes;
    }
}

