/*
 * Decompiled with CFR 0.152.
 */
package com.ar3h.chains.gadget.impl.mysql.proto;

import com.ar3h.chains.gadget.impl.mysql.proto.ColumnPacket;
import com.ar3h.chains.gadget.impl.mysql.proto.utils.ByteUtil;
import java.io.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreetingMessage {
    private static final Logger log = LoggerFactory.getLogger(GreetingMessage.class);
    private byte[] ProtocolVersion;
    private byte[] VersionString;
    private byte[] ServerThreadID;
    private byte[] Random;
    private byte[] Padding;
    private byte[] CaLow;
    private byte[] Encode;
    private byte[] ServerStatus;
    private byte[] CaHigh;
    private byte[] CL;
    private byte[] OtherPadding;
    private byte[] SECURE_CONNECTION;
    private byte[] PLUGIN_AUTH;
    private byte[] End;

    public GreetingMessage() {
        try {
            this.ProtocolVersion = new byte[]{10};
            log.debug("protocol version: {}", (Object)ColumnPacket.bytesToHex(this.ProtocolVersion));
            this.VersionString = "5.0.2".getBytes();
            log.debug("version string: {}", (Object)new String(this.VersionString));
            this.ServerThreadID = new byte[]{0, 0, 0, 0};
            log.debug("server thread id: {}", (Object)ColumnPacket.bytesToHex(this.ServerThreadID));
            this.Random = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
            log.debug("random: {}", (Object)ColumnPacket.bytesToHex(this.Random));
            this.Padding = new byte[]{0};
            log.debug("padding: {}", (Object)ColumnPacket.bytesToHex(this.Padding));
            int finalCapability = 565773;
            int low = finalCapability & 0xFFFF;
            int high = finalCapability >> 16 & 0xFFFF;
            this.CaLow = ByteUtil.int16ToByteArray((short)low);
            log.debug("capability low hex: {}", (Object)ColumnPacket.bytesToHex(this.CaLow));
            this.Encode = new byte[]{33};
            log.debug("encode: {}", (Object)ColumnPacket.bytesToHex(this.Encode));
            this.ServerStatus = ByteUtil.int16ToByteArray((short)2);
            log.debug("capability low hex: {}", (Object)ColumnPacket.bytesToHex(this.ServerStatus));
            this.CaHigh = ByteUtil.int16ToByteArray((short)high);
            log.debug("capability high hex: {}", (Object)ColumnPacket.bytesToHex(this.CaHigh));
            this.CL = new byte[]{0};
            log.debug("cl: {}", (Object)ColumnPacket.bytesToHex(this.CL));
            this.OtherPadding = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
            log.debug("other padding: {}", (Object)ColumnPacket.bytesToHex(this.OtherPadding));
            this.SECURE_CONNECTION = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            log.debug("SECURE_CONNECTION: {}", (Object)ColumnPacket.bytesToHex(this.SECURE_CONNECTION));
            this.PLUGIN_AUTH = "mysql_clear_password".getBytes();
            log.debug("PLUGIN_AUTH: {}", (Object)ColumnPacket.bytesToHex(this.PLUGIN_AUTH));
            this.End = new byte[]{0};
            log.debug("end: {}", (Object)ColumnPacket.bytesToHex(this.End));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public byte[] getBytes() {
        ByteArrayOutputStream out;
        try {
            out = new ByteArrayOutputStream();
            out.write(this.ProtocolVersion);
            out.write(this.VersionString);
            out.write(new byte[]{0});
            out.write(this.ServerThreadID);
            out.write(this.Random);
            out.write(this.Padding);
            out.write(this.CaLow);
            out.write(this.Encode);
            out.write(this.ServerStatus);
            out.write(this.CaHigh);
            out.write(this.CL);
            out.write(this.OtherPadding);
            out.write(this.SECURE_CONNECTION);
            out.write(this.PLUGIN_AUTH);
            out.write(this.End);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return out.toByteArray();
    }
}

