/*
 * Decompiled with CFR 0.152.
 */
package com.controller;

import com.core.checkContext;
import com.core.configContext;
import com.dto.config.attackConfigDTO;
import com.dto.result.checkResult;
import com.service.attack.checkService;
import com.service.commonConfigService;
import com.ui.Frame;
import com.utils.logUtils;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;

public class CheckController {
    private final Frame frame;

    public CheckController(Frame frame) {
        this.frame = frame;
        this.BindEvents();
    }

    private void BindEvents() {
        JButton checkButton = this.frame.getCheckButton();
        final JToggleButton killKeyButton = this.frame.getKillKeyButton();
        checkButton.addActionListener(e -> {
            final attackConfigDTO config = new commonConfigService().doConfig(this.frame);
            configContext.setConfig(config);
            SwingWorker<checkResult, Void> swingWorker = new SwingWorker<checkResult, Void>(){

                @Override
                protected checkResult doInBackground() throws Exception {
                    return new checkService().doCheck(config);
                }

                @Override
                protected void done() {
                    try {
                        checkResult checkResult2;
                        killKeyButton.setEnabled(false);
                        if (checkContext.isIsShiro()) {
                            killKeyButton.setEnabled(true);
                        }
                        if ((checkResult2 = (checkResult)this.get()).getSuccess().booleanValue()) {
                            checkContext.setCheckSuccess(true);
                            CheckController.this.frame.getFindButton().setEnabled(true);
                            CheckController.this.frame.getExecButton().setEnabled(true);
                            CheckController.this.frame.getMemButton().setEnabled(true);
                            CheckController.this.frame.getChangeKeyButton().setEnabled(true);
                            CheckController.this.frame.getTomcatHeaderButton().setEnabled(true);
                        } else {
                            checkContext.setCheckSuccess(false);
                        }
                        logUtils.setOutText(CheckController.this.frame.getCheckOutTextArea(), checkResult2.getMessage());
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        logUtils.setOutText(CheckController.this.frame.getCheckOutTextArea(), "Error: " + ex.getCause().getMessage());
                    }
                }
            };
            swingWorker.execute();
        });
    }
}

