/*
 * Decompiled with CFR 0.152.
 */
package com.controller;

import com.dto.config.attackConfigDTO;
import com.service.attack.commandService;
import com.service.commonConfigService;
import com.ui.Frame;
import com.utils.logUtils;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.SwingWorker;

public class ComandController {
    private final Frame frame;

    public ComandController(Frame frame) {
        this.frame = frame;
        this.BindEvents();
    }

    private void BindEvents() {
        JButton execButton = this.frame.getExecButton();
        execButton.addActionListener(e -> {
            final String type = Objects.requireNonNull(this.frame.getExpComboBox().getSelectedItem()).toString();
            attackConfigDTO config = new commonConfigService().doConfig(this.frame);
            final commandService commandService2 = new commandService(config);
            SwingWorker<String, Void> swingWorker = new SwingWorker<String, Void>(){
                String result = "";

                @Override
                protected String doInBackground() throws Exception {
                    if (type.contains("CB") && type.contains("9")) {
                        return commandService2.cb19Exec();
                    }
                    if (type.contains("CB") && type.contains("8")) {
                        return commandService2.cb18Exec();
                    }
                    if (type.contains("CCK1")) {
                        return commandService2.cck1Exec();
                    }
                    if (type.contains("CCK2")) {
                        return commandService2.cck2Exec();
                    }
                    if (type.contains("fastjson")) {
                        return commandService2.fastjsonExec();
                    }
                    if (type.contains("jackson")) {
                        return commandService2.jacksonExec();
                    }
                    return "error";
                }

                @Override
                protected void done() {
                    try {
                        this.result = (String)this.get();
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        this.result = ex.getMessage();
                    }
                    logUtils.setOutText(ComandController.this.frame.getCommandTextArea(), this.result);
                }
            };
            swingWorker.execute();
        });
    }
}

