/*
 * Decompiled with CFR 0.152.
 */
package com.controller;

import com.core.ThreadContext;
import com.core.configContext;
import com.dto.config.attackConfigDTO;
import com.dto.result.crackResult;
import com.service.attack.keyCrackService;
import com.ui.Frame;
import com.utils.logUtils;
import java.util.concurrent.ExecutionException;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;

public class CrackController {
    private final Frame frame;
    private SwingWorker<crackResult, String> swingWorker;
    private boolean isCracking = false;

    public CrackController(Frame frame) {
        this.frame = frame;
        this.BindEvents();
    }

    private void BindEvents() {
        JToggleButton killKeyButton = this.frame.getKillKeyButton();
        final keyCrackService keyCrackService2 = new keyCrackService();
        killKeyButton.addActionListener(e -> {
            final attackConfigDTO config = configContext.getConfig();
            if (killKeyButton.isSelected()) {
                this.isCracking = true;
                killKeyButton.setText("\u505c\u6b62\u7206\u7834");
                this.swingWorker = new SwingWorker<crackResult, String>(){

                    @Override
                    protected crackResult doInBackground() throws Exception {
                        return keyCrackService2.doCrack(config, CrackController.this.frame);
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                            CrackController.this.frame.getExecButton().setEnabled(true);
                            CrackController.this.frame.getMemButton().setEnabled(true);
                            CrackController.this.frame.getChangeKeyButton().setEnabled(true);
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            logUtils.setOutText(CrackController.this.frame.getCheckOutTextArea(), "Error: " + ex.getCause().getMessage());
                        }
                    }
                };
                this.swingWorker.execute();
            } else if (this.isCracking && this.swingWorker != null) {
                this.swingWorker.cancel(true);
                keyCrackService2.doThreadEnd(ThreadContext.thread);
                this.isCracking = false;
                killKeyButton.setText("\u7206\u7834\u5bc6\u94a5");
                logUtils.setOutText(this.frame.getCheckOutTextArea(), "Key\u503c\u7206\u7834\u5df2\u7ecf\u505c\u6b62\uff01");
            }
        });
    }
}

