/*
 * Decompiled with CFR 0.152.
 */
package com.core.chains;

import com.ar3h.chains.common.GadgetContext;
import com.ar3h.chains.common.Payload;
import com.ar3h.chains.common.Result;
import com.ar3h.chains.common.exception.GadgetParamException;
import com.ar3h.chains.common.warpper.impl.GzipWrapper;
import com.ar3h.chains.common.warpper.impl.HexWrapper;
import com.ar3h.chains.core.ExecutionEngine;
import com.ar3h.chains.core.PayloadFactory;
import com.core.chains.impl.GadgetService;
import com.core.chains.impl.ParseHandler;
import com.core.chains.parseHelper;
import com.dto.config.ParseReq;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;

public class PayloadParse
implements ParseHandler {
    @Autowired
    public GadgetService gadgetService;
    private static PayloadParse INSTANCE;

    public static PayloadParse getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PayloadParse();
        }
        return INSTANCE;
    }

    public static byte[] urlEncode(byte[] bytes) {
        return URLEncoder.encode(new String(bytes)).getBytes();
    }

    @Override
    public Result handle(ParseReq parseReq) throws Exception {
        String payloadName = parseReq.getPayloadName();
        List<String> gadgetList = parseReq.getGadgetList();
        Map<String, Object> params = parseReq.getParams();
        if (payloadName != null && gadgetList != null && !gadgetList.isEmpty()) {
            Class payloadClazz = PayloadFactory.getPayloadClass(payloadName);
            if (payloadClazz == null) {
                return Result.error("payloadName not found");
            }
            Payload payload = PayloadFactory.create(payloadName);
            ExecutionEngine engine = ExecutionEngine.create(payload);
            engine.addAll(gadgetList);
            if (params != null) {
                engine.setAll(params);
            }
            byte[] payloadBytes = "empty".getBytes();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("encode", "null");
            GadgetContext context = new GadgetContext();
            try {
                Object build;
                try {
                    build = engine.build(context).getData();
                }
                catch (GadgetParamException var14) {
                    GadgetParamException e = var14;
                    return Result.error(e.getMessage());
                }
                if (build instanceof byte[]) {
                    byte[] data = (byte[])build;
                    if ("hex".equalsIgnoreCase(parseReq.getEncode())) {
                        payloadBytes = new HexWrapper().process(data).getBytes();
                        if (parseReq.isUrlEncoding()) {
                            payloadBytes = PayloadParse.urlEncode(payloadBytes);
                        }
                        map.put("encode", "hex");
                    } else if ("base64".equalsIgnoreCase(parseReq.getEncode())) {
                        payloadBytes = Base64.encodeBase64String(data).getBytes();
                        if (parseReq.isUrlEncoding()) {
                            payloadBytes = PayloadParse.urlEncode(payloadBytes);
                        }
                        map.put("encode", "base64");
                    } else if ("gzip_base64".equalsIgnoreCase(parseReq.getEncode())) {
                        payloadBytes = Base64.encodeBase64String(new GzipWrapper().process(data)).getBytes();
                        if (parseReq.isUrlEncoding()) {
                            payloadBytes = PayloadParse.urlEncode(payloadBytes);
                        }
                        map.put("encode", "gzip_base64");
                    } else if ("raw".equalsIgnoreCase(parseReq.getEncode())) {
                        payloadBytes = data;
                        map.put("encode", "raw");
                    } else {
                        payloadBytes = data;
                        map.put("encode", "raw");
                    }
                } else if (build instanceof String) {
                    payloadBytes = ((String)build).getBytes();
                    if (parseReq.isUrlEncoding()) {
                        payloadBytes = PayloadParse.urlEncode(payloadBytes);
                    }
                    map.put("encode", "disable");
                }
            }
            catch (Exception var15) {
                return Result.error(var15.getMessage());
            }
            map.put("payload", payloadBytes);
            map.put("context", parseHelper.convertContextData(context.getContextData()));
            return Result.success(map);
        }
        return Result.error("payloadName or gadgetList not found");
    }
}

