/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Arrays2 {
    @SafeVarargs
    public static <T> T[] of(T ... values) {
        return values;
    }

    public static <T> Optional<T> find(@NonNull T @NonNull [] array, Predicate<? super T> predicate) {
        for (T value : array) {
            if (!predicate.test(value)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static <T> OptionalInt findIndex(T[] array, Predicate<? super T> predicate) {
        return Arrays2.findIndex(array, 0, predicate);
    }

    public static <T> OptionalInt findIndex(T[] array, int from, Predicate<? super T> predicate) {
        for (int i = from = Math.max(0, from); i < array.length; ++i) {
            if (!predicate.test(array[i])) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public static <T> Optional<T> reverseFind(@NonNull T @NonNull [] array, Predicate<? super T> predicate) {
        for (int i = array.length - 1; i >= 0; --i) {
            T value = array[i];
            if (!predicate.test(value)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static <T> OptionalInt reverseFindIndex(T[] array, Predicate<? super T> predicate) {
        return Arrays2.reverseFindIndex(array, array.length - 1, predicate);
    }

    public static <T> OptionalInt reverseFindIndex(T[] array, int from, Predicate<? super T> predicate) {
        for (int i = from = Math.min(array.length - 1, from); i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public static <S, T> T[] convert(S[] array, IntFunction<T[]> maker, Function<? super S, ? extends T> function) {
        Objects.requireNonNull(array);
        T[] target = maker.apply(array.length);
        for (int i = 0; i < array.length; ++i) {
            target[i] = function.apply(array[i]);
        }
        return target;
    }

    @SafeVarargs
    public static <T> T[] concat(IntFunction<T[]> maker, T[] array1, T ... array2) {
        Objects.requireNonNull(array1);
        Objects.requireNonNull(array2);
        T[] array = maker.apply(array1.length + array2.length);
        System.arraycopy(array1, 0, array, 0, array1.length);
        System.arraycopy(array2, 0, array, array1.length, array1.length);
        return array;
    }
}

