/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.util.Objects;
import net.dongliu.commons.Lazy;
import net.dongliu.commons.exception.HexDecodeException;

public class Hexes {
    private static final Lazy<Encoder> decodeUpper = Lazy.of(() -> new Encoder(true));
    private static final Lazy<Encoder> decodeLower = Lazy.of(() -> new Encoder(false));
    private static final Lazy<Decoder> decoder = Lazy.of(Decoder::new);

    public static Encoder encoder(boolean uppercase) {
        return uppercase ? decodeUpper.get() : decodeLower.get();
    }

    public static Encoder encoder() {
        return Hexes.encoder(true);
    }

    public static Decoder decoder() {
        return decoder.get();
    }

    public static class Decoder {
        public byte[] decode(String data) throws HexDecodeException {
            Objects.requireNonNull(data);
            return this.decode((CharSequence)data);
        }

        public byte[] decode(CharSequence data) throws HexDecodeException {
            Objects.requireNonNull(data);
            int len = data.length();
            if ((len & 1) != 0) {
                throw new HexDecodeException("Invalid hex characters with odd len: " + len);
            }
            byte[] result = new byte[len >> 1];
            for (int i = 0; i < result.length; ++i) {
                int f = this.toDigit(data.charAt(2 * i)) << 4;
                result[i] = (byte)((f |= this.toDigit(data.charAt(2 * i + 1))) & 0xFF);
            }
            return result;
        }

        private int toDigit(char ch) throws HexDecodeException {
            if ('0' <= ch && ch <= '9') {
                return ch - 48;
            }
            if ('a' <= ch && ch <= 'f') {
                return ch - 97 + 10;
            }
            if ('A' <= ch && ch <= 'F') {
                return ch - 65 + 10;
            }
            throw new HexDecodeException("Illegal hexadecimal character " + ch);
        }
    }

    public static class Encoder {
        private static final char[] HEX_CHARS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        private static final char[] HEX_CHARS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        private final boolean uppercase;

        private Encoder(boolean uppercase) {
            this.uppercase = uppercase;
        }

        public String encode(byte[] data) {
            Objects.requireNonNull(data);
            return this.encode(data, this.uppercase ? HEX_CHARS_UPPER : HEX_CHARS_LOWER);
        }

        private String encode(byte[] data, char[] hexChars) {
            StringBuilder sb = new StringBuilder(data.length * 2);
            for (byte b : data) {
                sb.append(hexChars[(0xF0 & b) >> 4]);
                sb.append(hexChars[0xF & b]);
            }
            return sb.toString();
        }
    }
}

